package com.elitesland.tw.tw5.server.prd.humanresources.resource.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ResourcePlanQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResourcePlanQueryService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResourcePlanQueryVO;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsResourcePlanRoleQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanRoleService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsResourcePlanRoleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/res/planquery")
@RequiredArgsConstructor
@Api(value = "资源计划查看", tags = {"资源计划查看"})
public class ResPlanQueryController {

    private final ResourcePlanQueryService service;

    private final PmsResourcePlanRoleService resourcePlanRoleService;

    /**
     * 资源计划查看
     *
     * @param query
     * @return result
     */
    @ApiOperation("资源计划查看")
    @PostMapping("/query")
    public TwOutputUtil<PagingVO<ResourcePlanQueryVO>> queryByKey(@RequestBody ResourcePlanQuery query) {

        return TwOutputUtil.ok(service.query(query));
    }

    /**
     * 资源计划查看测试
     *
     * @param resId
     * @return result
     */
    @ApiOperation("资源计划查看测试")
    @PostMapping("/test/{resId}")
    public TwOutputUtil<List<PmsResourcePlanRoleVO>> test(@PathVariable Long resId) {
        PmsResourcePlanRoleQuery planRoleQuery = new PmsResourcePlanRoleQuery();
        planRoleQuery.setResId(resId);
        List<PmsResourcePlanRoleVO> pmsResourcePlanRoleVOList = null;// resourcePlanRoleService.querySimpleList(planRoleQuery);

        return TwOutputUtil.ok(pmsResourcePlanRoleVOList);
    }


}
