package com.elitesland.tw.tw5.server.prd.humanresources.resource.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Entity
@Table(name = "res_withdrawal_apply")
@org.hibernate.annotations.Table(appliesTo = "res_withdrawal_apply", comment = "资源提现申请")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class ResWithdrawApplyDO extends BaseModel {

    @Comment("申请人id")
    @Column()
    private Long applyUserId;

    @Comment("申请人")
    @Column()
    private String applyUserName;

    @Comment("提现单号")
    @Column()
    private String withdrawNo;

    @Comment("审批状态")
    @Column()
    private String apprStatus;

    @Comment("资源类型")
    @Column()
    private String resType;

    @Comment("提现当量")
    @Column(precision = 12, scale = 4)
    private BigDecimal withdrawEqva;

    @Comment("提现金额")
    @Column()
    private BigDecimal withdrawAmt;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    @Comment("调整提现金额")
    @Column()
    private BigDecimal adjWithdrawAmt;

    @Comment("提现付款状态")
    @Column()
    private String withdrawPayStatus;

    @Comment("付款申请单id")
    @Column()
    private Long paymentApplyId;
}
