package com.elitesland.tw.tw5.server.prd.inv.common;

import lombok.Getter;

/**
 * @author likunpeng
 * @date 2023/12/14
 * 发票枚举
 */
public interface InvEnum {
    /**
     * 发票核销状态【inv:invoice_state】
     */
    @Getter
    enum InvoiceState implements InvEnum {
        UN_WRITE_OFF("un_write_off", "未核销"),
        WRITTEN_OFF("written_off", "已核销"),
        WRITE_OFF_PART("write_off_part", "部分核销"),
        TENTATIVE("tentative", "空"),
        ;

        private final String code;
        private final String desc;

        InvoiceState(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }
}
