package com.elitesland.tw.tw5.server.prd.inv.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvItemCatPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvItemCatQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvItemCatService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvItemCatVO;
import com.elitesland.tw.tw5.server.prd.inv.convert.InvItemCatConvert;
import com.elitesland.tw.tw5.server.prd.inv.dao.InvItemCatDAO;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvItemCatDO;
import com.elitesland.tw.tw5.server.prd.inv.repo.InvItemCatRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 发票商品分类对象
 *
 * @author zoey
 * @date 2023-07-31
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class InvItemCatServiceImpl extends BaseServiceImpl implements InvItemCatService {

    private final InvItemCatRepo invItemCatRepo;
    private final InvItemCatDAO invItemCatDAO;

    @Override
    public PagingVO<InvItemCatVO> queryPaging(InvItemCatQuery query) {
        return invItemCatDAO.queryPaging(query);
    }

    @Override
    public List<InvItemCatVO> queryListDynamic(InvItemCatQuery query) {
        return invItemCatDAO.queryListDynamic(query);
    }

    @Override
    public InvItemCatVO queryByKey(Long key) {
        InvItemCatDO entity = invItemCatRepo.findById(key).orElseGet(InvItemCatDO::new);
        Assert.notNull(entity.getId(), "不存在");
        InvItemCatVO vo = InvItemCatConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public InvItemCatVO insert(InvItemCatPayload payload) {
        InvItemCatDO entityDo = InvItemCatConvert.INSTANCE.toDo(payload);
        return InvItemCatConvert.INSTANCE.toVo(invItemCatRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public InvItemCatVO update(InvItemCatPayload payload) {
        InvItemCatDO entity = invItemCatRepo.findById(payload.getId()).orElseGet(InvItemCatDO::new);
        Assert.notNull(entity.getId(), "不存在");
        InvItemCatDO entityDo = InvItemCatConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return InvItemCatConvert.INSTANCE.toVo(invItemCatRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(InvItemCatPayload payload) {
        InvItemCatDO entity = invItemCatRepo.findById(payload.getId()).orElseGet(InvItemCatDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = invItemCatDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            invItemCatDAO.deleteSoft(keys);
        }
    }

}
