package com.elitesland.tw.tw5.server.prd.my.constant;

import lombok.Getter;


/**
 * 双周计划 类型枚举
 *
 * @author duwh
 * @date 2023/01/11
 */
public enum TimesheetBiweeklyDetailTypeEnum {
    /** 类型 10 本周预计工作 20 本周实际工作 30 预计下周工作*/
    TIMESHEET_PLAN("10", "本周工作计划"),
    TIMESHEET("20", "本周工作日志"),
    TIMESHEET_PLAN_NEXT_WEEK("30", "下周工作计划"),

    ;

    /**
     * 状态
     */
    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    TimesheetBiweeklyDetailTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
