package com.elitesland.tw.tw5.server.prd.my.controller;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceNormalQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceNormalService;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceNormalMonthVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceNormalVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;


@Api(tags = "正常打卡记录")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/tAttendanceNormals")
@Slf4j
public class TAttendanceNormalController {

    private final TAttendanceNormalService attendanceNormalService;

    /**
     * 正常打卡记录-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("报销明细餐费记录-分页")
    public TwOutputUtil<PagingVO<TAttendanceNormalVO>> paging(TAttendanceNormalQuery query) {
        return TwOutputUtil.ok(attendanceNormalService.queryPaging(query));
    }

    /**
     * 正常打卡记录-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("报销明细餐费记录-查询列表")
    public TwOutputUtil<List<TAttendanceNormalVO>> queryList(TAttendanceNormalQuery query) {
        return TwOutputUtil.ok(attendanceNormalService.queryListDynamic(query));
    }

    /**
     * 正常打卡记录-导出
     *
     * @param query 查询
     */
    @GetMapping("/exportList")
    @UdcNameClass
    @ApiOperation("报销明细餐费记录-分页")
    public void export(TAttendanceNormalQuery query, HttpServletResponse response) throws IOException {
        attendanceNormalService.export(query, response);
    }


    /**
     * 正常打卡记录(按月查询)-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging/month")
    @UdcNameClass
    @ApiOperation("报销明细餐费记录-分页")
    public TwOutputUtil<PagingVO<TAttendanceNormalMonthVO>> pagingMonth(TAttendanceNormalQuery query) {
        return TwOutputUtil.ok(attendanceNormalService.queryPagingMonth(query));
    }

    /**
     * 正常打卡记录-导出
     *
     * @param query 查询
     */
    @GetMapping("/exportListMonth")
    @UdcNameClass
    @ApiOperation("报销明细餐费记录-分页")
    public void exportListMonth(TAttendanceNormalQuery query, HttpServletResponse response) throws IOException {
        attendanceNormalService.exportListMonth(query, response);
    }


}
