package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TUserVacationCancelPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TUserVacationCancelQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TUserVacationCancelService;
import com.elitesland.tw.tw5.api.prd.my.vo.TUserVacationCancelVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 假期取消申请
 *
 * @author carl
 * @date 2024-06-18
 */
@Api(tags = "假期取消申请")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/my/tUserVacationCancel")
@Slf4j
public class TUserVacationCancelController {

    private final TUserVacationCancelService tUserVacationCancelService;

    /**
     * 假期取消申请-新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("假期取消申请-新增或修改")
    public TwOutputUtil<TUserVacationCancelVO> insertOrUpdate(@RequestBody TUserVacationCancelPayload payload) {
        return TwOutputUtil.ok(tUserVacationCancelService.insertOrUpdate(payload));
    }

//    /**
//     * 假期取消申请-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("假期取消申请-更新")
//    public TwOutputUtil<TUserVacationCancelVO> update(@RequestBody TUserVacationCancelPayload payload){
//        return TwOutputUtil.ok(tUserVacationCancelService.update(payload));
//    }

    /**
     * 假期取消申请-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("假期取消申请-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TUserVacationCancelPayload payload) {
        return TwOutputUtil.ok(tUserVacationCancelService.updateByKeyDynamic(payload));
    }

    /**
     * 假期取消申请-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("假期取消申请-主键查询")
    public TwOutputUtil<TUserVacationCancelVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(tUserVacationCancelService.queryByKey(key));
    }

    /**
     * 假期取消申请-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("假期取消申请-分页")
    public TwOutputUtil<PagingVO<TUserVacationCancelVO>> paging(TUserVacationCancelQuery query) {
        return TwOutputUtil.ok(tUserVacationCancelService.queryPaging(query));
    }

    /**
     * 假期取消申请-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("假期取消申请-查询列表")
    public TwOutputUtil<List<TUserVacationCancelVO>> queryList(TUserVacationCancelQuery query) {
        return TwOutputUtil.ok(tUserVacationCancelService.queryListDynamic(query));
    }

    /**
     * 假期取消申请-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("假期取消申请-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        tUserVacationCancelService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

