package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetSubsidySettingPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetSubsidySettingQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetSubsidySettingVO;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetSubsidySettingDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QTimesheetSubsidySettingDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetSubsidySettingRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 工时补贴标准配置表
 *
 * @author duwh
 * @date 2024-07-13
 */
@Repository
@RequiredArgsConstructor
public class TimesheetSubsidySettingDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final TimesheetSubsidySettingRepo repo;
    private final QTimesheetSubsidySettingDO qdo = QTimesheetSubsidySettingDO.timesheetSubsidySettingDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TimesheetSubsidySettingVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(TimesheetSubsidySettingVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 事由类型 PROJ_CONTRACT合同项目 PROJ_OPPO售前商机项目  PROJ_BU部门BU项目
                qdo.reasonType,
                // 可选 事由id
                qdo.reasonId,
                // 可选 事由名称
                qdo.reasonName,
                // 是否工作日 WORK工作日 HOLIDAY节假日
                qdo.workDateType,
                // 周末现场是否考虑补助 Y考虑 N不考虑
                qdo.holidaySubsidyType,
                // 可选补助类型
                qdo.subsidySelectTypeName,
                qdo.subsidySelectTypeCode,
                // 可选补助类型 是否默认值 Y赋值默认值 其他不管
                qdo.subsidySelectDefaultFlag,
                // 可填写工时 数值格式 多个英文逗号隔开
                qdo.workHourSelect,
                // 拓展 可填写工时对应udc
                qdo.workHourSelectUdcKey,
                // 工时计算调整 实际参与计算补助的值
                qdo.workHourCal,
                // 补贴标准 NO没有补助 TRAVEL出差补贴 ON_SITE现场补贴
                qdo.subsidyStdType,
                // 项目补助规则-周末可填写补助 工作日 无视  节假日根据项目中的规则判断  Y周末现场有补助
                qdo.projectSubsidyRole,
                // 拓展1
                qdo.ext1,
                // 拓展2
                qdo.ext2,
                // 拓展3
                qdo.ext3,
                // 拓展4
                qdo.ext4,
                // 拓展5
                qdo.ext5
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TimesheetSubsidySettingVO> getJpaQueryWhere(TimesheetSubsidySettingQuery query) {
        JPAQuery<TimesheetSubsidySettingVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(TimesheetSubsidySettingQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(TimesheetSubsidySettingQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 事由类型 PROJ_CONTRACT合同项目 PROJ_OPPO售前商机项目  PROJ_BU部门BU项目 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonType())) {
            list.add(qdo.reasonType.eq(query.getReasonType()));
        }
        /** 可选 事由id 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonId())) {
            list.add(qdo.reasonId.eq(query.getReasonId()));
        }
        /** 可选 事由名称 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonName())) {
            list.add(qdo.reasonName.eq(query.getReasonName()));
        }
        /** 是否工作日 WORK工作日 HOLIDAY节假日 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkDateType())) {
            list.add(qdo.workDateType.eq(query.getWorkDateType()));
        }
        /** 周末现场是否考虑补助 Y考虑 N不考虑 精确 */
        if (!ObjectUtils.isEmpty(query.getHolidaySubsidyType())) {
            list.add(qdo.holidaySubsidyType.eq(query.getHolidaySubsidyType()));
        }
        /** 可选补助类型 精确 */
        if (!ObjectUtils.isEmpty(query.getSubsidySelectTypeName())) {
            list.add(qdo.subsidySelectTypeName.eq(query.getSubsidySelectTypeName()));
        }
        if (!ObjectUtils.isEmpty(query.getSubsidySelectTypeCode())) {
            list.add(qdo.subsidySelectTypeCode.eq(query.getSubsidySelectTypeCode()));
        }
        /** 可选补助类型 是否默认值 Y赋值默认值 其他不管 精确 */
        if (!ObjectUtils.isEmpty(query.getSubsidySelectDefaultFlag())) {
            list.add(qdo.subsidySelectDefaultFlag.eq(query.getSubsidySelectDefaultFlag()));
        }
        /** 可填写工时 数值格式 多个英文逗号隔开 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkHourSelect())) {
            list.add(qdo.workHourSelect.eq(query.getWorkHourSelect()));
        }
        /** 拓展 可填写工时对应udc 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkHourSelectUdcKey())) {
            list.add(qdo.workHourSelectUdcKey.eq(query.getWorkHourSelectUdcKey()));
        }
        /** 工时计算调整 实际参与计算补助的值 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkHourCal())) {
            list.add(qdo.workHourCal.eq(query.getWorkHourCal()));
        }
        /** 补贴标准 NO没有补助 TRAVEL出差补贴 ON_SITE现场补贴 精确 */
        if (!ObjectUtils.isEmpty(query.getSubsidyStdType())) {
            list.add(qdo.subsidyStdType.eq(query.getSubsidyStdType()));
        }
        if (!ObjectUtils.isEmpty(query.getProjectSubsidyRole())) {
            list.add(qdo.projectSubsidyRole.eq(query.getProjectSubsidyRole()));
        }
        /** 拓展1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 拓展4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 拓展5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public TimesheetSubsidySettingVO queryByKey(Long id) {
        JPAQuery<TimesheetSubsidySettingVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TimesheetSubsidySettingVO> queryListDynamic(TimesheetSubsidySettingQuery query) {
        JPAQuery<TimesheetSubsidySettingVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TimesheetSubsidySettingVO> queryPaging(TimesheetSubsidySettingQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<TimesheetSubsidySettingVO> jpaQuery = getJpaQueryWhere(query);
        List<TimesheetSubsidySettingVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<TimesheetSubsidySettingVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public TimesheetSubsidySettingDO save(TimesheetSubsidySettingDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<TimesheetSubsidySettingDO> saveAll(List<TimesheetSubsidySettingDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(TimesheetSubsidySettingPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 事由类型 PROJ_CONTRACT合同项目 PROJ_OPPO售前商机项目  PROJ_BU部门BU项目
        if (payload.getReasonType() != null) {
            update.set(qdo.reasonType, payload.getReasonType());
        }
        // 可选 事由id
        if (payload.getReasonId() != null) {
            update.set(qdo.reasonId, payload.getReasonId());
        }
        // 可选 事由名称
        if (payload.getReasonName() != null) {
            update.set(qdo.reasonName, payload.getReasonName());
        }
        // 是否工作日 WORK工作日 HOLIDAY节假日
        if (payload.getWorkDateType() != null) {
            update.set(qdo.workDateType, payload.getWorkDateType());
        }
        // 周末现场是否考虑补助 Y考虑 N不考虑
        if (payload.getHolidaySubsidyType() != null) {
            update.set(qdo.holidaySubsidyType, payload.getHolidaySubsidyType());
        }
        // 可选补助类型
        if (payload.getSubsidySelectTypeName() != null) {
            update.set(qdo.subsidySelectTypeName, payload.getSubsidySelectTypeName());
        }
        if (payload.getSubsidySelectTypeCode() != null) {
            update.set(qdo.subsidySelectTypeCode, payload.getSubsidySelectTypeCode());
        }
        // 可选补助类型 是否默认值 Y赋值默认值 其他不管
        if (payload.getSubsidySelectDefaultFlag() != null) {
            update.set(qdo.subsidySelectDefaultFlag, payload.getSubsidySelectDefaultFlag());
        }
        // 可填写工时 数值格式 多个英文逗号隔开
        if (payload.getWorkHourSelect() != null) {
            update.set(qdo.workHourSelect, payload.getWorkHourSelect());
        }
        // 拓展 可填写工时对应udc
        if (payload.getWorkHourSelectUdcKey() != null) {
            update.set(qdo.workHourSelectUdcKey, payload.getWorkHourSelectUdcKey());
        }
        // 工时计算调整 实际参与计算补助的值
        if (payload.getWorkHourCal() != null) {
            update.set(qdo.workHourCal, payload.getWorkHourCal());
        }
        // 补贴标准 NO没有补助 TRAVEL出差补贴 ON_SITE现场补贴
        if (payload.getSubsidyStdType() != null) {
            update.set(qdo.subsidyStdType, payload.getSubsidyStdType());
        }
        if (payload.getProjectSubsidyRole() != null) {
            update.set(qdo.projectSubsidyRole, payload.getProjectSubsidyRole());
        }
        // 拓展1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 拓展4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 拓展5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 事由类型 PROJ_CONTRACT合同项目 PROJ_OPPO售前商机项目  PROJ_BU部门BU项目
            if (nullFields.contains("reasonType")) {
                update.setNull(qdo.reasonType);
            }
            // 可选 事由id
            if (nullFields.contains("reasonId")) {
                update.setNull(qdo.reasonId);
            }
            // 可选 事由名称
            if (nullFields.contains("reasonName")) {
                update.setNull(qdo.reasonName);
            }
            // 是否工作日 WORK工作日 HOLIDAY节假日
            if (nullFields.contains("workDateType")) {
                update.setNull(qdo.workDateType);
            }
            // 周末现场是否考虑补助 Y考虑 N不考虑
            if (nullFields.contains("holidaySubsidyType")) {
                update.setNull(qdo.holidaySubsidyType);
            }
            // 可选补助类型
            if (nullFields.contains("subsidySelectTypeName")) {
                update.setNull(qdo.subsidySelectTypeName);
            }
            if (nullFields.contains("subsidySelectTypeCode")) {
                update.setNull(qdo.subsidySelectTypeCode);
            }
            // 可选补助类型 是否默认值 Y赋值默认值 其他不管
            if (nullFields.contains("subsidySelectDefaultFlag")) {
                update.setNull(qdo.subsidySelectDefaultFlag);
            }
            // 可填写工时 数值格式 多个英文逗号隔开
            if (nullFields.contains("workHourSelect")) {
                update.setNull(qdo.workHourSelect);
            }
            // 拓展 可填写工时对应udc
            if (nullFields.contains("workHourSelectUdcKey")) {
                update.setNull(qdo.workHourSelectUdcKey);
            }
            // 工时计算调整 实际参与计算补助的值
            if (nullFields.contains("workHourCal")) {
                update.setNull(qdo.workHourCal);
            }
            // 补贴标准 NO没有补助 TRAVEL出差补贴 ON_SITE现场补贴
            if (nullFields.contains("subsidyStdType")) {
                update.setNull(qdo.subsidyStdType);
            }
            if (nullFields.contains("projectSubsidyRole")) {
                update.setNull(qdo.projectSubsidyRole);
            }
            // 拓展1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 拓展4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 拓展5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

