package com.elitesland.tw.tw5.server.prd.my.repo;

import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationApplyDetailDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * @author sunxw
 * @description 用户请假申请明细
 * @Date 2023/5/11
 */
public interface UserVacationApplyDetailRepo extends JpaRepository<UserVacationApplyDetailDO, Long>, JpaSpecificationExecutor<UserVacationApplyDetailDO> {

    @Query(value = "select * from t_user_vacation_apply_detail where apply_id = ?1", nativeQuery = true)
    List<UserVacationApplyDetailDO> selectDetailByApplyKey(Long applyId);

    /**
     * 根据idV4查询当前表中记录
     *
     * @param tw4UserVacationApplyDetailIds
     * @return
     */
    @Query(value = "select * from t_user_vacation_apply_detail where detail_id_v4 in (?1)", nativeQuery = true)
    List<UserVacationApplyDetailDO> selectByIdV4(List<Long> tw4UserVacationApplyDetailIds);


    List<UserVacationApplyDetailDO> findByProcInstIdAndExtVacationFlag(String procId, Boolean flag);


    List<UserVacationApplyDetailDO> findByApplyId(Long applyId);

    List<UserVacationApplyDetailDO> findByApplyIdAndExtVacationFlag(Long applyId, Boolean flag);

    @Modifying
    void deleteAllByApplyId(Long applyId);

}
