package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.OutWorkApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.OutWorkApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.OutWorkApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.OutWorkApplyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.OutWorkApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.OutWorkApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.OutWorkApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.OutWorkApplyRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;

/**
 * 远程办公申请
 *
 * @author carl
 * @date 2024-04-19
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class OutWorkApplyServiceImpl extends BaseServiceImpl implements OutWorkApplyService {

    private final OutWorkApplyRepo outWorkApplyRepo;
    private final OutWorkApplyDAO outWorkApplyDAO;
    private final WorkflowUtil workflowUtil;
    private final CacheUtil cacheUtil;
    private final TransactionUtilService transactionUtilService;

    //ProcDefKey.RES_VACATION.name(),
    @Override
    public PagingVO<OutWorkApplyVO> queryPaging(OutWorkApplyQuery query) {
        return outWorkApplyDAO.queryPaging(query);
    }

    @Override
    public List<OutWorkApplyVO> queryListDynamic(OutWorkApplyQuery query) {
        return outWorkApplyDAO.queryListDynamic(query);
    }

    @Override
    public OutWorkApplyVO queryByKey(Long key) {
        OutWorkApplyDO entity = outWorkApplyRepo.findById(key).orElseGet(OutWorkApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        OutWorkApplyVO vo = OutWorkApplyConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public OutWorkApplyVO insertOrUpdate(OutWorkApplyPayload payload) {
        String procInstId = null;
        if (payload.getId() != null) {
            OutWorkApplyDO entity = outWorkApplyRepo.findById(payload.getId()).orElseGet(OutWorkApplyDO::new);
            if (entity.getId() == null) {
                throw TwException.error("", "变更数据不存在");
            }
            procInstId = entity.getProcInstId();
        } else {
            payload.setApplyDate(LocalDate.now());
        }
        OutWorkApplyDO entityDo = OutWorkApplyConvert.INSTANCE.toDo(payload);
        OutWorkApplyDO save = outWorkApplyRepo.save(entityDo);
        payload.setId(save.getId());
        payload.setProcInstId(procInstId);
        if (payload.getSubmitFlag() && !StringUtils.hasText(procInstId)) {
            //发起流程
            startProcess(payload);
        }
        return OutWorkApplyConvert.INSTANCE.toVo(save);
    }

    /**
     * 提交流程
     *
     * @param payload
     */
    void startProcess(OutWorkApplyPayload payload) {
        HashMap<String, Object> variables = new HashMap<>();
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = cacheUtil.getUserDefaultOrg(payload.getApplyUserId());
        //直属领导审批
        variables.put("Activity_0ixka9u", CollUtil.newArrayList(prdOrgEmployeeRefVO.getParentId()));
        //BU负责人审批
        variables.put("Activity_0up3jog", CollUtil.newArrayList(prdOrgEmployeeRefVO.getManageId()));

        String procInstName = "A38." + ProcDefKey.OUT_WORK.getDesc() + "-" + prdOrgEmployeeRefVO.getEmployeeName() + "-" + payload.getApplyDate();
        //发起流程审批
        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                ProcDefKey.OUT_WORK.name(),
                procInstName,
                payload.getId() + "",
                variables)
        );
        OutWorkApplyPayload payload0 = new OutWorkApplyPayload();
        payload0.setId(payload.getId());
        payload0.setProcInstId(processInfo.getProcInstId());
        payload0.setProcInstStatus(processInfo.getProcInstStatus().name());
        payload0.setParentUserId(prdOrgEmployeeRefVO.getParentId());
        transactionUtilService.executeWithRunnable(() -> {
            outWorkApplyDAO.updateByKeyDynamic(payload0);
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public OutWorkApplyVO update(OutWorkApplyPayload payload) {
        OutWorkApplyDO entity = outWorkApplyRepo.findById(payload.getId()).orElseGet(OutWorkApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        OutWorkApplyDO entityDo = OutWorkApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return OutWorkApplyConvert.INSTANCE.toVo(outWorkApplyRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(OutWorkApplyPayload payload) {
        OutWorkApplyDO entity = outWorkApplyRepo.findById(payload.getId()).orElseGet(OutWorkApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = outWorkApplyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            outWorkApplyDAO.deleteSoft(keys);
        }
    }

    @Override
    public void processStatusChange(ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        Long applyId = Long.valueOf(businessKey);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        OutWorkApplyPayload payload0 = new OutWorkApplyPayload();
        payload0.setId(applyId);
        payload0.setProcInstStatus(procInstStatus.name());
        //以下代码可注释掉
        switch (procInstStatus) {
            case NOTSUBMIT://创建人提交节点
                payload0.setProcInstStatus(procInstStatus.NOTSUBMIT.name());
                break;
            case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                payload0.setProcInstStatus(procInstStatus.INTERRUPT.name());
                break;
            case INVALID://仅删除流程
                payload0.setProcInstStatus(procInstStatus.INVALID.name());
                break;
            case REJECTED://审批人拒绝，回到第一个节点
                payload0.setProcInstStatus(procInstStatus.NOTSUBMIT.name());
                break;
            case APPROVED:
                payload0.setProcInstStatus(procInstStatus.APPROVED.name());

                break;
            case APPROVING:
                payload0.setProcInstStatus(procInstStatus.APPROVING.name());
                break;
        }
        outWorkApplyDAO.updateByKeyDynamic(payload0);
    }

}
