package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.ProjectPayload;
import com.elitesland.tw.tw5.api.prd.my.query.ProjectQuery;
import com.elitesland.tw.tw5.api.prd.my.service.ProjectService;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjectAndTaskVO;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjectVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.ProjectConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.ProjectDO;
import com.elitesland.tw.tw5.server.prd.my.repo.ProjectRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConContractRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
 * 工时用-项目表
 *
 * @author duwh
 * @date 2022-12-09
 */
@Service
@RequiredArgsConstructor
@Slf4j
@Deprecated
public class ProjectServiceImpl implements ProjectService {

    private final ProjectRepo projectRepo;
    private final SaleConContractRepo saleConContractRepo;

    @Override
    public PagingVO<ProjectVO> paging(ProjectQuery query) {
        Page<ProjectDO> page = projectRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(ProjectConvert.INSTANCE::toVo));
    }

    @Override
    public List<ProjectVO> queryList(ProjectQuery query) {
        return ProjectConvert.INSTANCE.toVoList(projectRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public List<ProjectAndTaskVO> queryListForSelect(ProjectQuery query) {
        return ProjectConvert.INSTANCE.toSelectVoList(projectRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public ProjectVO queryByKey(Long key) {
        ProjectDO entity = projectRepo.findById(key).orElseGet(ProjectDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ProjectVO vo = ProjectConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    public ProjectVO queryByProjIdV4(Long projIdV4) {
        ProjectDO entity = projectRepo.getByProjIdV4(projIdV4);
        Assert.notNull(entity, "项目不存在");
        ProjectVO vo = ProjectConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ProjectVO insert(ProjectPayload payload) {
        ProjectDO entityDo = ProjectConvert.INSTANCE.toDo(payload);
        return ProjectConvert.INSTANCE.toVo(projectRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ProjectVO update(ProjectPayload payload) {
        ProjectDO entity = projectRepo.findById(payload.getId()).orElseGet(ProjectDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ProjectDO entityDo = ProjectConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ProjectConvert.INSTANCE.toVo(projectRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            projectRepo.deleteSoft(keys);
        }
    }

    @Override
    public void download(List<ProjectVO> all, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = new ArrayList<>();
        for (ProjectVO project : all) {
            Map<String, Object> map = new LinkedHashMap<>();
            map.put("4.0项目主键", project.getProjIdV4());
            map.put("项目名称", project.getProjName());
            map.put("项目编号", project.getProjNo());
            map.put("项目状态", project.getProjStatus());
            map.put("合同id", project.getContractId());
            map.put("关联项目编号", project.getRelatedProjNo());
            map.put("产品编号", project.getProductNo());
            map.put("拓展1", project.getExt1());
            map.put("拓展2", project.getExt2());
            map.put("拓展3", project.getExt3());
            map.put("拓展4", project.getExt4());
            map.put("拓展5", project.getExt5());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }

    @Override
    public Map<Long, Long> getV4AndV5ProjectIds() {
        Map<Long, Long> projectMap = new HashMap<>();
        //查询用户列表
        List<Map<String, Object>> v4AndV5ProjectIds = projectRepo.getV4AndV5ProjectIds();
        for (Map<String, Object> v4AndV5ProjectId : v4AndV5ProjectIds) {
            Long projectId = (Long) v4AndV5ProjectId.get("projectId");
            Long projectIdV4 = (Long) v4AndV5ProjectId.get("projectIdV4");
            projectMap.put(projectIdV4, projectId);
        }
        return projectMap;
    }
}
