package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.bank.feign.payload.PayPayload;
import com.elitesland.tw.tw5.api.bank.feign.service.TwBankPayService;
import com.elitesland.tw.tw5.api.bank.vo.BkPayDetailVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TMoneyTransferPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TMoneyTransferQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TMoneyTransferService;
import com.elitesland.tw.tw5.api.prd.my.vo.TMoneyTransferVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.api.prd.pay.payload.BkPayDetailRecordPayload;
import com.elitesland.tw.tw5.api.prd.pay.payload.TDocHistPayload;
import com.elitesland.tw.tw5.api.prd.pay.service.BkPayDetailRecordService;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PaymentSlipPayload;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PaymentSlipVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.GenerateSeqNumConstants;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.JdeTranslateEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TMoneyTransferConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TMoneyTransferDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TMoneyTransferDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TMoneyTransferRepo;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 资金划款
 *
 * @author wangluyu
 * @date 2024-02-27
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TMoneyTransferServiceImpl extends BaseServiceImpl implements TMoneyTransferService {

    private final TMoneyTransferRepo tMoneyTransferRepo;
    private final TMoneyTransferDAO tMoneyTransferDAO;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final CacheUtil cacheUtil;
    private final PrdSystemRoleService roleService;
    private final FileUtil fileUtil;
    private final BookAccountService bookAccountService;

    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;


    @Override
    public PagingVO<TMoneyTransferVO> queryPaging(TMoneyTransferQuery query) {
        PagingVO<TMoneyTransferVO> tMoneyTransferVOPagingVO = tMoneyTransferDAO.queryPaging(query);
        if (!CollectionUtils.isEmpty(tMoneyTransferVOPagingVO.getRecords())) {
            //查询划款和收款账号
            List<Long> accountList = new ArrayList();
            List<Long> collectionAccountList = tMoneyTransferVOPagingVO.stream().filter(p -> StringUtils.hasText(p.getCollectionAccount())).map(s -> Long.valueOf(s.getCollectionAccount())).collect(Collectors.toList());
            List<Long> transferAccountList = tMoneyTransferVOPagingVO.stream().filter(p -> StringUtils.hasText(p.getTransferAccount())).map(s -> Long.valueOf(s.getTransferAccount())).collect(Collectors.toList());
            accountList.addAll(collectionAccountList);
            accountList.addAll(transferAccountList);
            Map<Long, List<BookAccountVO>> bookAccountVOMap = bookAccountService.queryByIdList(accountList);
            tMoneyTransferVOPagingVO.stream().forEach(p -> translate(p, bookAccountVOMap));
        }
        return tMoneyTransferVOPagingVO;
    }

    @Override
    public List<TMoneyTransferVO> queryListDynamic(TMoneyTransferQuery query) {
        List<TMoneyTransferVO> tMoneyTransferVOS = tMoneyTransferDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(tMoneyTransferVOS)) {
            //查询划款和收款账号
            List<Long> accountList = new ArrayList();
            List<Long> collectionAccountList = tMoneyTransferVOS.stream().filter(p -> StringUtils.hasText(p.getCollectionAccount())).map(s -> Long.valueOf(s.getCollectionAccount())).collect(Collectors.toList());
            List<Long> transferAccountList = tMoneyTransferVOS.stream().filter(p -> StringUtils.hasText(p.getTransferAccount())).map(s -> Long.valueOf(s.getTransferAccount())).collect(Collectors.toList());
            accountList.addAll(collectionAccountList);
            accountList.addAll(transferAccountList);
            Map<Long, List<BookAccountVO>> bookAccountVOMap = bookAccountService.queryByIdList(accountList);
            tMoneyTransferVOS.stream().forEach(p -> translate(p, bookAccountVOMap));
        }
        return tMoneyTransferVOS;
    }

    @Override
    public TMoneyTransferVO queryByKey(Long key) {
        TMoneyTransferDO entity = tMoneyTransferRepo.findById(key).orElseGet(TMoneyTransferDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TMoneyTransferVO vo = TMoneyTransferConvert.INSTANCE.toVo(entity);
        //查询划款和收款账号
        List<Long> accountList = new ArrayList();
        accountList.add(Long.valueOf(vo.getCollectionAccount()));
        accountList.add(Long.valueOf(vo.getTransferAccount()));
        Map<Long, List<BookAccountVO>> bookAccountVOMap = bookAccountService.queryByIdList(accountList);
        translate(vo, bookAccountVOMap);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TMoneyTransferVO insert(TMoneyTransferPayload payload) {
        String transferNo = generateSeqNum(GenerateSeqNumConstants.MONEY_TRANSFER);
        payload.setTransferNo(transferNo);
        TMoneyTransferDO entityDo = TMoneyTransferConvert.INSTANCE.toDo(payload);
        TMoneyTransferDO save = tMoneyTransferRepo.save(entityDo);
        moneyTransferProc(save);
        return TMoneyTransferConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TMoneyTransferVO update(TMoneyTransferPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        TMoneyTransferDO entity = tMoneyTransferRepo.findById(payload.getId()).orElseGet(TMoneyTransferDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TMoneyTransferDO entityDo = TMoneyTransferConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TMoneyTransferConvert.INSTANCE.toVo(tMoneyTransferRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TMoneyTransferPayload payload) {
        TMoneyTransferDO entity = tMoneyTransferRepo.findById(payload.getId()).orElseGet(TMoneyTransferDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = tMoneyTransferDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            tMoneyTransferDAO.deleteSoft(keys);
        }
    }
    /**
     * 提交流程
     *
     * @param tMoneyTransferDO
     */
    private void moneyTransferProc(TMoneyTransferDO tMoneyTransferDO) {
        ProcessInfo processInfo = new ProcessInfo();
        if (workflow_enabled) {
            //获取申请人
            String applyResName = cacheUtil.getUserName(tMoneyTransferDO.getApplicantUserId());
            HashMap variables = dealWorkFlowVariables();
            String procInstName = applyResName + "-" + tMoneyTransferDO.getApplicantTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + "-" + tMoneyTransferDO.getTransferMoney() + "-" + "资金划款流程";
            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.ACC_MONEY_TRANSFER.name(),
                    procInstName,
                    tMoneyTransferDO.getId() + "",
                    variables)
            );
        }
        //流程启动成功后，回写业务表数据
        TMoneyTransferPayload payload = new TMoneyTransferPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(tMoneyTransferDO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            tMoneyTransferDAO.updateByKeyDynamic(payload);
        });
    }

    //处理流程参数
    public HashMap dealWorkFlowVariables() {
        HashMap<String, Object> variables = new HashMap<>();
        //平台财务经理审批
        variables.put("Activity_078sb1w", roleService.queryUserIdByRoleCode(RoleEnum.PLAT_FIN_MANAGER.getCode()));
        //运营总裁审批
        variables.put("Activity_1w917wj", roleService.queryUserIdByRoleCode(RoleEnum.OPERATION_PRESIDENT.getCode()));
        // 财务出纳审批
        variables.put("Activity_18nv388", roleService.queryUserIdByRoleCode(RoleEnum.PLAT_FIN_CASHIER.getCode()));
        return variables;
    }

    // 某些字段翻译
    private void translate(TMoneyTransferVO vo, Map<Long, List<BookAccountVO>> bookAccountVOMap) {
        if (StringUtils.hasText(vo.getFileCodes())) {
            vo.setFileDatas(fileUtil.getFileDatas(vo.getFileCodes()));
        }
        if (!CollectionUtils.isEmpty(bookAccountVOMap)) {
            if (bookAccountVOMap.containsKey(Long.valueOf(vo.getCollectionAccount()))) {
                vo.setCollectionAccountDesc(bookAccountVOMap.get(Long.valueOf(vo.getCollectionAccount())).get(0).getAccountNo());
            }
            if (bookAccountVOMap.containsKey(Long.valueOf(vo.getTransferAccount()))) {
                vo.setTransferAccountDesc(bookAccountVOMap.get(Long.valueOf(vo.getTransferAccount())).get(0).getAccountNo());
            }
        }

    }
}
