package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TPermissionApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TPermissionApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TPermissionApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.TPermissionApplyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TPermissionApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TPermissionApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TPermissionApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TPermissionApplyRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

/**
 * 权限申请
 *
 * @author lemon
 * @date 2023-09-11
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TPermissionApplyServiceImpl implements TPermissionApplyService {

    private final TPermissionApplyRepo tPermissionApplyRepo;
    private final TPermissionApplyDAO tPermissionApplyDAO;

    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;

    private final WorkflowUtil workflowUtil;

    private final TransactionUtilService transactionUtilService;
    private final CacheUtil cacheUtil;

    private final PrdOrgEmployeeDAO employeeDAO;

    private final PrdSystemRoleDAO systemRoleDAO;

    @Override
    public PagingVO<TPermissionApplyVO> queryPaging(TPermissionApplyQuery query){
        return tPermissionApplyDAO.queryPaging(query);
    }

    @Override
    public List<TPermissionApplyVO> queryListDynamic(TPermissionApplyQuery query){
        return tPermissionApplyDAO.queryListDynamic(query);
    }

    @Override
    public TPermissionApplyVO queryByKey(Long key) {
        TPermissionApplyDO entity = tPermissionApplyRepo.findById(key).orElseGet(TPermissionApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TPermissionApplyVO vo = TPermissionApplyConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TPermissionApplyVO insert(TPermissionApplyPayload payload) {
        TPermissionApplyDO entityDo = TPermissionApplyConvert.INSTANCE.toDo(payload);
        TPermissionApplyDO save = tPermissionApplyRepo.save(entityDo);
        permissionApplyProc(save);
        return TPermissionApplyConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TPermissionApplyVO update(TPermissionApplyPayload payload) {
        TPermissionApplyDO entity = tPermissionApplyRepo.findById(payload.getId()).orElseGet(TPermissionApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TPermissionApplyDO entityDo = TPermissionApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TPermissionApplyConvert.INSTANCE.toVo(tPermissionApplyRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TPermissionApplyPayload payload) {
        TPermissionApplyDO entity = tPermissionApplyRepo.findById(payload.getId()).orElseGet(TPermissionApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = tPermissionApplyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            tPermissionApplyDAO.deleteSoft(keys);
        }
    }

    /**
     * 权限申请流程
     *
     * @param permissionApplyDO
     */
    private void permissionApplyProc(TPermissionApplyDO permissionApplyDO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.CREATE_WORK.getCode();
        if (workflow_enabled) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<>();

            //获取申请人
            Long applyResId = permissionApplyDO.getApplyResId();
            String applyResName = cacheUtil.getUserName(applyResId);
            // 申请人上级
            PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(applyResId);
            if (ObjectUtils.isEmpty(prdOrgEmployeeRefVO)) {
                throw TwException.error("", "申请人没有上级，请完善申请人信息后提交！");
            }
            Long parentId = prdOrgEmployeeRefVO.getParentId();
            variables.put("Activity_1uj6v31", parentId);
            // 运维管理员
            List<Long> messageToUserIds = systemRoleDAO.queryUserIdByRoleCode(RoleEnum.OPS.getCode());
            variables.put("Activity_0pulfoc", messageToUserIds);

            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.PERMISSION_APPLY.name(),
                    applyResName + "-权限申请流程",
                    permissionApplyDO.getId() + "",
                    variables)
            );
        }
        //流程启动成功后，回写业务表数据
        TPermissionApplyPayload payload = new TPermissionApplyPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(permissionApplyDO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            tPermissionApplyDAO.updateByKeyDynamic(payload);
        });
    }
}
