package com.elitesland.tw.tw5.server.prd.partner.business.controller;



import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.partner.business.service.CrmBusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.PartnerBusinessCountVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 业务伙伴管理
 *
 * @folder 业务伙伴管理
 * @author wangluyu
 * @date 2023-05-16
 */
@Api(tags = "业务伙伴管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessPartner")
@Slf4j
public class CrmBusinessPartnerController {

    private final CrmBusinessPartnerService crmBusinessPartnerService;

    /**
         * 业务伙伴-客户下面的经营往来列表
     *
     * @param partnerId 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/followList")
    public TwOutputUtil<List<CrmFollowVO>> followList(Long partnerId,String type) {
        List<CrmFollowVO> vos = crmBusinessPartnerService.followList(partnerId,type);
        return TwOutputUtil.ok(vos);
    }

    /**
     * 业务伙伴-业务往来 数量统计 for APP
     *
     * @param partnerId 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/businessCount/{partnerId}")
    public TwOutputUtil businessCount(@PathVariable Long partnerId) {
        List<PartnerBusinessCountVO> vos = crmBusinessPartnerService.businessCount(partnerId);
        return TwOutputUtil.ok(vos);
    }

    /**
     * 业务伙伴管理-补充启信宝信息
     * @return
     */
    @PostMapping("fillQxbInfo")
    public TwOutputUtil<Boolean> fillQxbInfo(Long[] keys){
        boolean success = crmBusinessPartnerService.fillQxbInfo(Arrays.asList(keys));
        return TwOutputUtil.ok(success);
    }


}
