package com.elitesland.tw.tw5.server.prd.partner.business.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 业务合作伙伴-工商股东
 *
 * @author wangly
 * @date 2023-05-18
 */
@Entity
@Table(name = "com_business_operation_partner", indexes = {
        @Index(name = "partner_id_index", columnList = "partner_id")
})
@org.hibernate.annotations.Table(appliesTo = "com_business_operation_partner", comment = "业务合作伙伴-工商股东")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessOperationPartnerDO extends BaseModel implements Serializable  {
    /** 地址簿id */
    @Comment("地址簿id")
    @Column()
    private Long bookId;
    /** 总实缴 */
    @Comment("总实缴")
    @Column()
    private String totalRealCapi;
    /** 出资时间 */
    @Comment("出资时间")
    @Column()
    private String date;
    /** 历史股东 */
    @Comment("历史股东")
    @Column()
    private String isHstory;
    /** 股东类型 */
    @Comment("股东类型")
    @Column()
    private String stockType;
    /** 股东姓名 */
    @Comment("股东姓名")
    @Column()
    private String name;
    /** 人员id（股东为自然人显示pid） */
    @Comment("人员id（股东为自然人显示pid）")
    @Column()
    private String pid;
    /** 认缴出资列表 */
    @Comment("认缴出资列表")
    @Column()
    private String shouldcapiitems;
    /** 总认缴 */
    @Comment("总认缴")
    @Column()
    private String totalShouldCapi;
    /** 股比 */
    @Comment("股比")
    @Column()
    private String stockPercent;
    /** 企业id（股东为企业显示eid） */
    @Comment("企业id（股东为企业显示eid）")
    @Column()
    private String eid;
    /** 类型 */
    @Comment("类型")
    @Column()
    private String identifyType;
    /** 认缴出资额 */
    @Comment("认缴出资额")
    @Column()
    private String capi;
    /** 股东ID */
    @Comment("股东ID")
    @Column()
    private String identifyNo;
    /** 实缴出资列表 */
    @Comment("实缴出资列表")
    @Column()
    private String realCapiItems;
    /** 出资方式 */
    @Comment("出资方式")
    @Column()
    private String type;
    /** 业务伙伴主键 business_partner.id */
    @Comment("业务伙伴主键 business_partner.id")
    @Column(name="partner_id")
    private Long partnerId;
    /** 业务伙伴名称 */
    @Comment("业务伙伴名称")
    @Column(name="partner_name")
    private String partnerName;


    public void copy(BusinessOperationPartnerDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
