package com.elitesland.tw.tw5.server.prd.partner.business.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessOperationEnterpriseInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.query.BusinessOperationEnterpriseInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.service.BusinessOperationEnterpriseInfoService;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.BusinessOperationEnterpriseInfoVO;
import com.elitesland.tw.tw5.server.prd.partner.business.convert.BusinessOperationEnterpriseInfoConvert;
import com.elitesland.tw.tw5.server.prd.partner.business.dao.BusinessOperationEnterpriseInfoDAO;
import com.elitesland.tw.tw5.server.prd.partner.business.entity.BusinessOperationEnterpriseInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.business.repo.BusinessOperationEnterpriseInfoRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 业务伙伴-企业基本信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessOperationEnterpriseInfoServiceImpl extends BaseServiceImpl implements BusinessOperationEnterpriseInfoService {

    private final BusinessOperationEnterpriseInfoRepo businessOperationEnterpriseInfoRepo;
    private final BusinessOperationEnterpriseInfoDAO businessOperationEnterpriseInfoDAO;

    @Override
    public PagingVO<BusinessOperationEnterpriseInfoVO> queryPaging(BusinessOperationEnterpriseInfoQuery query){
        return businessOperationEnterpriseInfoDAO.queryPaging(query);
    }

    @Override
    public List<BusinessOperationEnterpriseInfoVO> queryListDynamic(BusinessOperationEnterpriseInfoQuery query){
        return businessOperationEnterpriseInfoDAO.queryListDynamic(query);
    }

    @Override
    public BusinessOperationEnterpriseInfoVO queryByKey(Long key) {
        BusinessOperationEnterpriseInfoDO entity = businessOperationEnterpriseInfoRepo.findById(key).orElseGet(BusinessOperationEnterpriseInfoDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessOperationEnterpriseInfoVO vo = BusinessOperationEnterpriseInfoConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessOperationEnterpriseInfoVO insert(BusinessOperationEnterpriseInfoPayload payload) {
        BusinessOperationEnterpriseInfoDO entityDo = BusinessOperationEnterpriseInfoConvert.INSTANCE.toDo(payload);
        return BusinessOperationEnterpriseInfoConvert.INSTANCE.toVo(businessOperationEnterpriseInfoRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessOperationEnterpriseInfoVO update(BusinessOperationEnterpriseInfoPayload payload) {
        BusinessOperationEnterpriseInfoDO entity = businessOperationEnterpriseInfoRepo.findById(payload.getId()).orElseGet(BusinessOperationEnterpriseInfoDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessOperationEnterpriseInfoDO entityDo = BusinessOperationEnterpriseInfoConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessOperationEnterpriseInfoConvert.INSTANCE.toVo(businessOperationEnterpriseInfoRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessOperationEnterpriseInfoDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional
    public void deleteByPartnerId(Long partnerId) {
        businessOperationEnterpriseInfoDAO.deleteByPartnerId(partnerId);
    }

}
