package com.elitesland.tw.tw5.server.prd.partner.common.controller;


import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookAccountPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookAccountQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 业务伙伴-账户信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Api(tags = "业务伙伴-账户信息")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/bookAccount")
@Slf4j
public class BookAccountController {

    private final BookAccountService bookAccountService;

    /**
     * 业务伙伴-账户信息-新增
     *

     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("业务伙伴-账户信息-新增")
    public TwOutputUtil insert(@RequestBody BookAccountPayload payload){
        //业务伙伴的地址信息传值为空 需要操作记录 公司主体传值为false 不需要操作记录
        boolean logFlag = true;
        if(payload.getLogFlag()!=null){
            logFlag = payload.getLogFlag();
        }
        return TwOutputUtil.ok(bookAccountService.insert(payload,logFlag));
    }

    /**
     * 业务伙伴-账户信息-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("业务伙伴-账户信息-更新")
    public TwOutputUtil update(@RequestBody BookAccountPayload payload){
        //业务伙伴的地址信息传值为空 需要操作记录 公司主体传值为false 不需要操作记录
        boolean logFlag = true;
        if(payload.getLogFlag()!=null){
            logFlag = payload.getLogFlag();
        }
        return TwOutputUtil.ok(bookAccountService.update(payload,logFlag));
    }

    /**
     * 业务伙伴-账户信息-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
//    @GetMapping("/{key}")
//    // @UdcNameClass
//    @ApiOperation("业务伙伴-账户信息-主键查询")
//    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(bookAccountService.queryByKey(key));
//    }

    /**
     * 业务伙伴-账户信息-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
//    @GetMapping("/paging")
//    // @UdcNameClass
//    @ApiOperation("业务伙伴-账户信息-分页")
//    public TwOutputUtil paging(BookAccountQuery query) {
//        return TwOutputUtil.ok(bookAccountService.queryPaging(query));
//    }

    /**
     * 业务伙伴-账户信息-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("业务伙伴-账户信息-查询列表")
    public TwOutputUtil<List<BookAccountVO>> queryList(BookAccountQuery query) {
        return TwOutputUtil.ok(bookAccountService.queryListDynamic(query));
    }

    /**
     * 业务伙伴-账户信息-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("业务伙伴-账户信息-删除")
    public TwOutputUtil deleteSoft(Long[] keys,Long bookId,Long partnerId) {
        bookAccountService.deleteSoft(Arrays.asList(keys),bookId,partnerId,true);
        return TwOutputUtil.ok();
    }

    /**
     * 业务伙伴-账户信息-查询内部公司的列表
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/select/internal")
    @UdcNameClass
    @ApiOperation("业务伙伴-账户信息-查询内部公司的列表")
    public TwOutputUtil<List<BookAccountVO>> queryInternalList(BookAccountQuery bookAccountQuery) {
        return TwOutputUtil.ok(bookAccountService.queryInternalList(bookAccountQuery));
    }

}
