package com.elitesland.tw.tw5.server.prd.partner.common.service;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeoplePayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleService;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookContactsPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookContactsQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookContactsService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookContactsVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.partner.common.convert.BookContactsConvert;
import com.elitesland.tw.tw5.server.prd.partner.common.dao.BookContactsDAO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.BookContactsDO;
import com.elitesland.tw.tw5.server.prd.partner.common.repo.BookContactsRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * 业务伙伴-联系信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BookContactsServiceImpl extends BaseServiceImpl implements BookContactsService {

    private final BookContactsRepo bookContactsRepo;
    private final BookContactsDAO bookContactsDAO;
    private final PrdSystemLogService logService;
    private final ChangeFieldLogUtil changeFieldLogUtil;

    @Override
    public PagingVO<BookContactsVO> queryPaging(BookContactsQuery query){
        return bookContactsDAO.queryPaging(query);
    }

    @Override
    public List<BookContactsVO> queryListDynamic(BookContactsQuery query){
        return bookContactsDAO.queryListDynamic(query);
    }

    @Override
    public BookContactsVO queryByKey(Long key) {
        BookContactsVO bookContactsVO = bookContactsDAO.queryByKey(key);
        if(bookContactsVO == null){
            throw TwException.error("","对象不存在");
        }
        return bookContactsVO;
    }

    /**
     * 根据bookId查询默认
     *
     * @param bookId bookId
     * @return {@link BookContactsVO}
     */
    @Override
    public BookContactsVO queryDefaultByBookId(Long bookId) {
        return bookContactsDAO.queryDefaultByBookId(bookId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BookContactsVO insert(BookContactsPayload payload,Boolean logFlag) {
        //如果默认值是true就将原来的默认数据置为false
        /**
         * 如果是新增的第一条 置为默认 不管他选择了没有
         * 如果新增的不是第一条  看他这条是不是默认 是默认 将之前的默认数据置为false 不是默认不管
         **/

        BookContactsDO defaultDO = bookContactsRepo.findByBookIdAndIsDefault(payload.getBookId(), true);
        if(payload.getIsDefault()!=null&&payload.getIsDefault()&&defaultDO!=null){
            defaultDO.setIsDefault(false);
            bookContactsRepo.save(defaultDO);
        }
        //空 说明是新增的第一条 新增的第一条置为默认
        if(defaultDO==null){
            payload.setIsDefault(true);
        }
        BookContactsDO entityDo = BookContactsConvert.INSTANCE.toDo(payload);
        //新增联系人的时候新增一条人脉
        CrmPeopleService crmPeopleService = SpringUtil.getBean(CrmPeopleService.class);
        CrmPeoplePayload crmPeoplePayload = new CrmPeoplePayload();
        crmPeoplePayload.setPeopleName(entityDo.getContactsName());
        crmPeoplePayload.setCustomerId(payload.getPartnerId());
        crmPeoplePayload.setBirthday(entityDo.getBirthday());
        crmPeoplePayload.setMobile(entityDo.getContactsPhone());
        crmPeoplePayload.setEmail(entityDo.getContactsEmail());
        crmPeoplePayload.setSocialIdentity(entityDo.getSocialAccountType());
        crmPeoplePayload.setJobs(entityDo.getContactsPosition());
        crmPeoplePayload.setLocationDetail(entityDo.getContactsAddress());
        crmPeoplePayload.setSex(entityDo.getSex());
        crmPeopleService.insertOrUpdate(crmPeoplePayload);
        //操作记录
        if(logFlag&&payload.getPartnerId()!=null){
            // 获取变更日志
//            final String fieldsCreateLog = changeFieldLogUtil.getFieldsCreateLog(entityDo);
//            logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsCreateLog);
            logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "新增了一条联系人信息");

        }
        //更新业务伙伴的更新时间 方便数据同步到4.0
        BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
        businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(payload.getBookId()));
        return BookContactsConvert.INSTANCE.toVo(bookContactsRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BookContactsVO update(BookContactsPayload payload,Boolean logFlag) {
        BookContactsDO entity = bookContactsRepo.findById(payload.getId()).orElseGet(BookContactsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        // 变更日志用
//        BookContactsDO entityLog = new BookContactsDO();
//        BeanUtils.copyProperties(entity, entityLog);
        //如果默认值是true就将原来的默认数据置为false
        if(payload.getIsDefault()!=null&&payload.getIsDefault()){
            BookContactsDO defaultDO = bookContactsRepo.findByBookIdAndIsDefault(payload.getBookId(), true);
            //确认不是自己
            if(defaultDO!=null && !defaultDO.getId().equals(payload.getId())){
                defaultDO.setIsDefault(false);
                bookContactsRepo.save(defaultDO);
            }
        }
        BookContactsDO entityDo = BookContactsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        //操作记录
        if (logFlag && null != payload.getPartnerId()) {
            logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "修改了一条联系人信息");
        }

//        //操作记录
//        if (logFlag&&null != payload.getPartnerId()) {
//            // 修改NULL值特殊处理
//            final StringBuilder fieldsUpdateLog = changeFieldLogUtil.nullFieldsProcess(payload, entityLog, entity);
//            //获取变更日志
//            fieldsUpdateLog.append(changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
//            if (org.springframework.util.StringUtils.hasText(fieldsUpdateLog)) {
//                logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
//            }
//        }
        //更新业务伙伴的更新时间 方便数据同步到4.0
        BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
        businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(entity.getBookId()));
        return BookContactsConvert.INSTANCE.toVo(bookContactsRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys,Long bookId,Long partnerId,Boolean logFlag) {
        if (!keys.isEmpty()) {
//            keys.stream().forEach(id -> {
//                Optional<BookContactsDO> optional = bookContactsRepo.findById(id);
//                if (!optional.isEmpty()) {
//                    BookContactsDO entity = optional.get();
//                    bookContactsRepo.save(entity);
//                }
//             });
            bookContactsDAO.deleteSoft(keys);
            //如果删除只剩最后一条 就设为默认地址
            List<BookContactsDO> dos = bookContactsDAO.queryByBookId(bookId);
            if(dos!=null&&dos.size()==1){
                BookContactsDO bookContactsDO = dos.get(0);
                bookContactsDO.setIsDefault(true);
                bookContactsRepo.save(bookContactsDO);
            }
            if(logFlag){
                logService.saveNewLog(partnerId, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "删除了 "+keys.size()+" 条联系人信息");
            }
            //更新业务伙伴的更新时间 方便数据同步到4.0
            BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
            businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(bookId));
        }
    }

    @Override
    public List<BookContactsVO> listSimple(){

        return bookContactsDAO.queryListDynamic(new BookContactsQuery());
    }

    @Override
    public Long count(BookContactsQuery query) {
        return bookContactsDAO.count(query);
    }

//    @Override
//    public List<PrdAbContactsPayload> queryTwBookContactsListByBookId(List<Long> bookIdList) {
//        return bookContactsDAO.queryTwBookContactsListByBookId(bookIdList);
//    }
}
