package com.elitesland.tw.tw5.server.prd.partner.identity.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 业务伙伴-合作伙伴
 *
 * @author wangly
 * @date 2023-05-16
 */
@Entity
@Table(name = "com_business_collaborate_partner_info", indexes = {
        @Index(name = "index_partner_id", columnList = "partner_id"),
        @Index(name="index_book_id",columnList = "book_id")
})
@org.hibernate.annotations.Table(appliesTo = "com_business_collaborate_partner_info", comment = "业务伙伴-合作伙伴")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessCollaboratePartnerInfoDO extends BaseModel implements Serializable {
    /**
     * 业务伙伴id business_partner.id
     */
    @Comment("业务伙伴id")
    @Column(name = "partner_id")
    private Long partnerId;

    /**
     * 地址薄id
     */
    @Comment("地址薄id")
    @Column(name = "book_id")
    private Long bookId;

    /**
     * 合作状态 udc[CRM:BUSINESS_PARTNER:STATUS]
     */
    @Comment("合作状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    @Column()
    @FieldUpdateLog(fieldName = "合作状态", selectionKey = "CRM:BUSINESS_PARTNER:STATUS")
    @FieldCreateLog(fieldName = "合作状态", selectionKey = "CRM:BUSINESS_PARTNER:STATUS")
    private String collaborateStatus;

    /**
     * 合作产品
     */
    @Comment("合作形式")
    @Column()
    @FieldCreateLog(fieldName = "合作形式")
    @FieldUpdateLog(fieldName = "合作形式")
    private String collaborateForm;

    /**
     * 合作等级 udc[crm:customer_grade]
     */
    @Comment("合作等级 udc[crm:customer_grade]")
    @Column()
    @FieldUpdateLog(fieldName = "合作等级", selectionKey = "crm:customer_grade")
    @FieldCreateLog(fieldName = "合作等级", selectionKey = "crm:customer_grade")
    private String collaborateGradle;

    /**
     * 合作等级 udc[crm:customer_grade]
     */
    @Comment("合作类别 udc[CRM:BUSINESS_PARTNER:COLLABORATE_TYPE]")
    @Column()
    @FieldUpdateLog(fieldName = "合作类别", selectionKey = "CRM:BUSINESS_PARTNER:COLLABORATE_TYPE")
    @FieldCreateLog(fieldName = "合作类别", selectionKey = "CRM:BUSINESS_PARTNER:COLLABORATE_TYPE")
    private String collaborateType;

    /**
     * 合作产品/服务
     */
    @Comment("合作产品/服务")
    @Column()
    @FieldCreateLog(fieldName = "合作产品/服务")
    @FieldUpdateLog(fieldName = "合作产品/服务")
    private String collaborateProduct;


    /**
     * 伙伴服务行业
     */
    @Comment("伙伴服务行业")
    @Column()
    @FieldCreateLog(fieldName = "伙伴服务行业")
    @FieldUpdateLog(fieldName = "伙伴服务行业")
    private String collaborateServiceIndustry;

    /**
     * 服务典型客户
     */
    @Comment("服务典型客户")
    @Column()
    @FieldCreateLog(fieldName = "服务典型客户")
    @FieldUpdateLog(fieldName = "服务典型客户")
    private String collaborateCustomer;

    /**
     * 服务客户规模
     */
    @Comment("服务客户规模")
    @Column()
    @FieldCreateLog(fieldName = "服务客户规模")
    @FieldUpdateLog(fieldName = "服务客户规模")
    private String serviceCustomerScale;

    /**
     * 渠道负责人
     */
    @Comment("渠道负责人")
    @Column()
    @FieldCreateLog(fieldName = "渠道负责人")
    @FieldUpdateLog(fieldName = "渠道负责人")
    private Long channelUserId;

    /**
     * 合作区域
     */
    @Comment("合作区域 udc[crm:customer_region]")
    @Column()
    @FieldCreateLog(fieldName = "合作区域")
    @FieldUpdateLog(fieldName = "合作区域")
    private String collaborateRegion;


    /**
     * 对接人类型
     */
    @Comment("对接人类型 udc[CRM:BUSINESS_PARTNER:CONTACT_TYPE]")
    @Column()
    @FieldCreateLog(fieldName = "对接人类型")
    @FieldUpdateLog(fieldName = "对接人类型")
    private String contactPeopleType;

    /**
     * 我司负责人bu
     */
    @Comment("我司负责人bu")
    @Column()
    @FieldCreateLog(fieldName = "我司负责人bu")
    @FieldUpdateLog(fieldName = "我司负责人bu")
    private Long buManageUserId;

    /**
     * 我司负责人电话
     */
    @Comment("我司负责人电话")
    @Column()
    @FieldCreateLog(fieldName = "我司负责人电话")
    @FieldUpdateLog(fieldName = "我司负责人电话")
    private String buManagePhone;

    /**
     * 我司负责人邮箱
     */
    @Comment("我司负责人邮箱")
    @Column()
    @FieldCreateLog(fieldName = "我司负责人邮箱")
    @FieldUpdateLog(fieldName = "我司负责人邮箱")
    private String buManageEmail;

    /**
     * 合作伙伴关键词
     */
    @Comment("合作伙伴关键词")
    @Column()
    @FieldCreateLog(fieldName = "合作伙伴关键词")
    @FieldUpdateLog(fieldName = "合作伙伴关键词")
    private String collaborateKeyword;


    /**
     * 合作伙伴标签
     */
    @Comment("合作伙伴标签")
    @Column()
    @FieldCreateLog(fieldName = "合作伙伴标签")
    @FieldUpdateLog(fieldName = "合作伙伴标签")
    private String collaborateTag;

    /**
     * 合作开始时间
     */
    @Comment("合作开始时间")
    @Column()
    @FieldCreateLog(fieldName = "合作开始时间")
    @FieldUpdateLog(fieldName = "合作开始时间")
    private LocalDate startTime;
    /**
     * 合作结束时间
     */
    @Comment("合作结束时间")
    @Column()
    @FieldCreateLog(fieldName = "合作结束时间")
    @FieldUpdateLog(fieldName = "合作结束时间")
    private LocalDate endTime;
    /**
     * 合作期间说明
     */
    @Comment("合作期间说明")
    @Column()
    @FieldCreateLog(fieldName = "合作期间说明")
    @FieldUpdateLog(fieldName = "合作期间说明")
    private String collaborateDescription;
    /**
     * 产品介绍附件
     */
    @Comment("产品介绍附件")
    @Column()
    private String fileCodes1;
    /**
     * 合作协议附件
     */
    @Comment("合作协议附件")
    @Column()
    private String fileCodes2;

    /**
     * 合作协议附件
     */
    @Comment("公司介绍附件")
    @Column()
    private String fileCodes3;
    /**
     * 扩展字段1
     */
    @Comment("扩展字段1")
    @Column()
    private String ext1;
    /**
     * 扩展字段2
     */
    @Comment("扩展字段2")
    @Column()
    private String ext2;
    /**
     * 扩展字段3
     */
    @Comment("扩展字段3")
    @Column()
    private String ext3;
    /**
     * 扩展字段4
     */
    @Comment("扩展字段4")
    @Column()
    private String ext4;
    /**
     * 扩展字段5
     */
    @Comment("扩展字段5")
    @Column()
    private String ext5;

    /**
     * 流程实例ID
     */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /**
     * 流程审批状态
     */
    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    public void copy(BusinessCollaboratePartnerInfoDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
