package com.elitesland.tw.tw5.server.prd.partner.strategy.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyGradeSettingPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyGradeSettingQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyGradeSettingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessStrategyGradeSettingDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.QBusinessStrategyGradeSettingDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessStrategyGradeSettingRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 分级策略等级配置
 *
 * @author wangly
 * @date 2023-06-16
 */
@Repository
@RequiredArgsConstructor
public class BusinessStrategyGradeSettingDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessStrategyGradeSettingRepo repo;
    private final QBusinessStrategyGradeSettingDO qdo = QBusinessStrategyGradeSettingDO.businessStrategyGradeSettingDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessStrategyGradeSettingVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessStrategyGradeSettingVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 策略id business_strategy.id
                qdo.strategyId,
                // 等级类别 udc[crm:customer_grade]
                qdo.gradleType,
                // 分数开始
                qdo.scoreStart,
                // 分数结束
                qdo.scoreEnd,
                // 排序号
                qdo.sortNo,
                // 拓展字段1
                qdo.ext1,
                // 拓展字段2
                qdo.ext2,
                // 拓展字段3
                qdo.ext3,
                // 拓展字段4
                qdo.ext4,
                // 拓展字段5
                qdo.ext5
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessStrategyGradeSettingVO> getJpaQueryWhere(BusinessStrategyGradeSettingQuery query) {
        JPAQuery<BusinessStrategyGradeSettingVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BusinessStrategyGradeSettingQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BusinessStrategyGradeSettingQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 策略id business_strategy.id 精确 */
        if (!ObjectUtils.isEmpty(query.getStrategyId())) {
            list.add(qdo.strategyId.eq(query.getStrategyId()));
        }
        /** 等级类别 udc[crm:customer_grade] 精确 */
        if (!ObjectUtils.isEmpty(query.getGradleType())) {
            list.add(qdo.gradleType.eq(query.getGradleType()));
        }
        /** 分数开始 精确 */
        if (!ObjectUtils.isEmpty(query.getScoreStart())) {
            list.add(qdo.scoreStart.eq(query.getScoreStart()));
        }
        /** 分数结束 精确 */
        if (!ObjectUtils.isEmpty(query.getScoreEnd())) {
            list.add(qdo.scoreEnd.eq(query.getScoreEnd()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 拓展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 拓展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BusinessStrategyGradeSettingVO queryByKey(Long id) {
        JPAQuery<BusinessStrategyGradeSettingVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BusinessStrategyGradeSettingVO> queryListDynamic(BusinessStrategyGradeSettingQuery query) {
        JPAQuery<BusinessStrategyGradeSettingVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BusinessStrategyGradeSettingVO> queryPaging(BusinessStrategyGradeSettingQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BusinessStrategyGradeSettingVO> jpaQuery = getJpaQueryWhere(query);
        List<BusinessStrategyGradeSettingVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessStrategyGradeSettingVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BusinessStrategyGradeSettingDO save(BusinessStrategyGradeSettingDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BusinessStrategyGradeSettingDO> saveAll(List<BusinessStrategyGradeSettingDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BusinessStrategyGradeSettingPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 策略id business_strategy.id
        if (payload.getStrategyId() != null) {
            update.set(qdo.strategyId, payload.getStrategyId());
        }
        // 等级类别 udc[crm:customer_grade]
        if (payload.getGradleType() != null) {
            update.set(qdo.gradleType, payload.getGradleType());
        }
        // 分数开始
        if (payload.getScoreStart() != null) {
            update.set(qdo.scoreStart, payload.getScoreStart());
        }
        // 分数结束
        if (payload.getScoreEnd() != null) {
            update.set(qdo.scoreEnd, payload.getScoreEnd());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        // 拓展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 拓展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 拓展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 策略id business_strategy.id
            if (nullFields.contains("strategyId")) {
                update.setNull(qdo.strategyId);
            }
            // 等级类别 udc[crm:customer_grade]
            if (nullFields.contains("gradleType")) {
                update.setNull(qdo.gradleType);
            }
            // 分数开始
            if (nullFields.contains("scoreStart")) {
                update.setNull(qdo.scoreStart);
            }
            // 分数结束
            if (nullFields.contains("scoreEnd")) {
                update.setNull(qdo.scoreEnd);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }
            // 拓展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 拓展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 拓展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

