package com.elitesland.tw.tw5.server.prd.pay.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 支付管理-支付履历
 *
 * @author wangly
 * @date 2023-12-12
 */
@Entity
@Table(name = "t_doc_hist", indexes = {
        @Index(name = "doc_id_index", columnList = "doc_id"),
})
@org.hibernate.annotations.Table(appliesTo = "t_doc_hist", comment = "支付管理-支付履历")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TDocHistDO extends BaseModel implements Serializable {
    /**
     * 履历类型
     */
    @Comment("履历类型")
    @Column()
    private String histType;
    /**
     * 履历详细
     */
    @Comment("履历详细")
    @Column()
    private String histDtl;
    /**
     * 履历日期时间
     */
    @Comment("履历日期时间")
    @Column()
    private LocalDateTime histTime;
    /**
     * 单据id
     */
    @Comment("单据id")
    @Column(name = "doc_id")
    private Long docId;
    /**
     * 单据编号
     */
    @Comment("单据编号")
    @Column()
    private String docNo;
    /**
     * 单据类型
     */
    @Comment("单据类型")
    @Column()
    private String docType;
    /**
     * 用户id
     */
    @Comment("用户id")
    @Column()
    private Long ownerId;

    public void copy(TDocHistDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
