package com.elitesland.tw.tw5.server.prd.personplan.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;


/**
 * @author : WWW
 * @date : 2024-2-21
 * @desc : 人员规划
 */
@Entity
@Table(name = "person_plan")
@org.hibernate.annotations.Table(appliesTo = "person_plan", comment = "人员规划")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PersonPlanDO extends BaseModel {

    /**
     * 关联对象ID
     */
    @Comment("关联对象ID")
    @Column()
    private Long objId;
    /**
     * 关联对象
     */
    @Comment("关联对象")
    @Column()
    private String objName;

    /**
     * 计划类型
     */
    @Comment("计划类型")
    @Column()
    private String planType;
    /**
     * 状态
     */
    @Column(name = "state", columnDefinition = "int(11) comment '状态'")
    private Integer state;

    /**
     * 开始日期
     */
    @Column(name = "start_date", columnDefinition = "date comment '开始日期'")
    private LocalDate startDate;

    /**
     * 结束日期
     */
    @Column(name = "end_date", columnDefinition = "date comment '结束日期'")
    private LocalDate endDate;

    /**
     * 持续时长
     */
    @Column(name = "duration", columnDefinition = "varchar(255) comment '持续时长'")
    private Integer duration;

    /**
     * 周期单位
     */
    @Column(name = "uom", columnDefinition = "varchar(255) comment '周期单位'")
    private String uom;

    /**
     * 当前版本
     */
    @Column(name = "version", columnDefinition = "varchar(255) comment '当前版本'")
    private String version;

    /**
     * 附件
     */
    @Column(name = "fileCodes", columnDefinition = "varchar(255) comment '附件'")
    private String fileCodes;
}

