package com.elitesland.tw.tw5.server.prd.personplan.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;


/**
 * @author : WWW
 * @date : 2024-2-21
 * @desc : 人员规划明细
 */
@Entity
@Table(name = "person_plan_dtl")
@org.hibernate.annotations.Table(appliesTo = "person_plan_dtl", comment = "人员规划明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PersonPlanDtlDO extends BaseModel {


    /**
     * 人员规划id
     */
    @Column(name = "plan_id", columnDefinition = "bigint(20) comment '人员规划id'")
    private Long planId;

    /**
     * 角色
     */
    @Comment("角色")
    @Column()
    private String roleCode;

    /**
     * 角色名称-冗余字段 迁移数据使用
     */
    @Comment("角色名称-冗余字段 迁移数据使用")
    @Column()
    private String roleName;
    /**
     * 复合能力级别ID
     */
    @Comment("复合能力级别ID")
    @Column()
    private Long capasetLevelId;
    /**
     * 资源
     */
    @Comment("资源")
    @Column()
    private Long resId;
    /**
     * 派发系数
     */
    @Comment("派发系数")
    @Column()
    private BigDecimal distributeRate;
    /**
     * 汇总当量
     */
    @Comment("汇总当量")
    @Column()
    private BigDecimal totalEqva;
    /**
     * 隐藏标志
     */
    @Comment("隐藏标志")
    @Column()
    private Integer hiddenFlag;

    /**
     * 投入精力
     */
    @Column(name = "input", columnDefinition = "decimal(20,2) comment '投入精力'")
    private BigDecimal input;

    /**
     * 人天单价
     */
    @Column(name = "price", columnDefinition = "decimal(20,2) comment '人天单价'")
    private BigDecimal price;

    /**
     * 人天合计
     */
    @Column(name = "days", columnDefinition = "decimal(20,2) comment '人天合计'")
    private BigDecimal days;

    /**
     * 金额合计
     */
    @Column(name = "amt", columnDefinition = "decimal(20,2) comment '金额合计'")
    private BigDecimal amt;

    /**
     * 天数明细
     */
    @Column(name = "days_json", columnDefinition = "text comment '天数明细'")
    private String daysJson;


}

