package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.math.BigDecimal;

/**
 * 内部项目申请
 *
 * @author carl
 * @date 2023-08-23
 */
@Entity
@Table(name = "pms_inner_project_apply", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_inner_project_apply", comment = "内部项目申请")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsInnerProjectApplyDO extends BaseModel implements Serializable  {
    /** 项目名称 */
    @Comment("项目名称")
    @Column()
    private String projName;
    /** 工作类型 */
    @Comment("工作类型")
    @Column()
    private String workType;
    /** 项目模板 */
    @Comment("项目模板")
    @Column()
    private Long projTempId;
    /** 项目id */
    @Comment("项目id")
    @Column()
    private Long projId;
    /** 签约公司 */
    @Comment("签约公司")
    @Column()
    private Long ouId;
    /** 币种 */
    @Comment("币种")
    @Column()
    private String currCode;
    /** 预计开始日期 */
    @Comment("预计开始日期")
    @Column()
    private LocalDate startDate;
    /** 预计结束日期 */
    @Comment("预计结束日期")
    @Column()
    private LocalDate endDate;
    /** 申请单号 */
    @Comment("申请单号")
    @Column()
    private String applyNo;
    /** 申请状态 */
    @Comment("申请状态")
    @Column()
    private String apprStatus;
    /** 申请人 */
    @Comment("申请人")
    @Column()
    private Long applyResId;
    /** 申请日期 */
    @Comment("申请日期")
    @Column()
    private LocalDate applyDate;
    /** 费用承担bu */
    @Comment("费用承担bu")
    @Column()
    private Long expenseBuId;
    /** 交付bu */
    @Comment("交付bu")
    @Column()
    private Long deliBuId;
    /** 交付负责人 */
    @Comment("交付负责人")
    @Column()
    private Long deliResId;
    /** 销售负责人 */
    @Comment("销售负责人")
    @Column()
    private Long salesmanResId;
    /** 项目经理 */
    @Comment("项目经理")
    @Column()
    private Long pmResId;
    /** 预计总人天 */
    @Comment("预计总人天")
    @Column()
    private BigDecimal totalDays;
    /** 预计总当量 */
    @Comment("预计总当量")
    @Column()
    private BigDecimal totalEqva;
    /** 当量预估单价 */
    @Comment("当量预估单价")
    @Column()
    private BigDecimal eqvaPrice;
    /** 费用总预算 */
    @Comment("费用总预算")
    @Column()
    private BigDecimal totalReimbursement;
    /** 预算总成本 */
    @Comment("预算总成本")
    @Column()
    private BigDecimal totalCost;
    /** 删除标志 */
    @Comment("删除标志")
    @Column()
    private Integer delFlag;
    /** 关联项目编号 */
    @Comment("关联项目编号")
    @Column()
    private String relatedProjNo;
    /** 产品编号 */
    @Comment("产品编号")
    @Column()
    private String productNo;
    /** 研发补贴金额 */
    @Comment("研发补贴金额")
    @Column()
    private BigDecimal subsidyAmt;
    /** 折旧月数 */
    @Comment("折旧月数")
    @Column()
    private Integer depreciationMonths;
    /** 折旧开始时间 */
    @Comment("折旧开始时间")
    @Column()
    private LocalDateTime depreciationStartDate;

    /**
     * sow节选
     */
    @Comment("sow节选")
    @Column()
    private String sowFiles;
    /**
     * 预算附件
     */
    @Comment("预算附件")
    @Column()
    private String budgetFiles;

    /**
     * 研发立项附件
     */
    @Comment("研发立项附件")
    @Column()
    private String researchFiles;


    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;

    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    /**
     * 合同id
     */
    @Comment("合同id")
    @Column(name = "contract_id")
    private Long contractId;


    public void copy(PmsInnerProjectApplyDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
