package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 会议纪要配置
 *
 * @author zoey
 * @date 2024-05-28
 */
@Entity
@Table(name = "pms_project_summary_setting", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_summary_setting", comment = "会议纪要配置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectSummarySettingDO extends BaseModel implements Serializable {
    /**
     * 交付BU
     */
    @Comment("交付BU")
    @Column()
    private Long deliOrgId;
    /**
     * 纪要人员
     */
    @Comment("纪要人员")
    @Column()
    private String summaryUsers;

    public void copy(PmsProjectSummarySettingDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
