package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectReportPlanPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectReportPlanQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectReportPlanService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectReportPlanVO;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectReportPlanConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectReportPlanDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectReportPlanDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectReportPlanRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 项目汇报计划管理
 *
 * @author carl
 * @date 2023-09-05
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectReportPlanServiceImpl extends BaseServiceImpl implements PmsProjectReportPlanService {

    private final PmsProjectReportPlanRepo pmsProjectReportPlanRepo;
    private final PmsProjectReportPlanDAO pmsProjectReportPlanDAO;

    @Override
    public PagingVO<PmsProjectReportPlanVO> queryPaging(PmsProjectReportPlanQuery query) {
        return pmsProjectReportPlanDAO.queryPaging(query);
    }

    @Override
    public List<PmsProjectReportPlanVO> queryListDynamic(PmsProjectReportPlanQuery query) {
        return pmsProjectReportPlanDAO.queryListDynamic(query);
    }

    @Override
    public PmsProjectReportPlanVO queryByKey(Long key) {
        PmsProjectReportPlanDO entity = pmsProjectReportPlanRepo.findById(key).orElseGet(PmsProjectReportPlanDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsProjectReportPlanVO vo = PmsProjectReportPlanConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectReportPlanVO insert(PmsProjectReportPlanPayload payload) {
        PmsProjectReportPlanDO entityDo = PmsProjectReportPlanConvert.INSTANCE.toDo(payload);
        return PmsProjectReportPlanConvert.INSTANCE.toVo(pmsProjectReportPlanRepo.save(entityDo));
    }

    @Override
    public void batchInsert(List<PmsProjectReportPlanPayload> payloads) {
        List<PmsProjectReportPlanDO> pmsProjectReportPlanDOS = PmsProjectReportPlanConvert.INSTANCE.toDos(payloads);
        pmsProjectReportPlanDAO.saveAll(pmsProjectReportPlanDOS);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectReportPlanVO update(PmsProjectReportPlanPayload payload) {
        PmsProjectReportPlanDO entity = pmsProjectReportPlanRepo.findById(payload.getId()).orElseGet(PmsProjectReportPlanDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsProjectReportPlanDO entityDo = PmsProjectReportPlanConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsProjectReportPlanConvert.INSTANCE.toVo(pmsProjectReportPlanRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsProjectReportPlanPayload payload) {
        PmsProjectReportPlanDO entity = pmsProjectReportPlanRepo.findById(payload.getId()).orElseGet(PmsProjectReportPlanDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = pmsProjectReportPlanDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            pmsProjectReportPlanDAO.deleteSoft(keys);
        }
    }

}
