package com.elitesland.tw.tw5.server.prd.product.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.product.payload.PrdProductPayload;
import com.elitesland.tw.tw5.api.prd.product.query.PrdProductQuery;
import com.elitesland.tw.tw5.api.prd.product.vo.PrdProductVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.product.entity.PrdProductDO;
import com.elitesland.tw.tw5.server.prd.product.entity.QPrdProductClassDO;
import com.elitesland.tw.tw5.server.prd.product.entity.QPrdProductDO;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 产品管理
 *
 * @author likunpeng
 * @date 2023-05-22
 */
@Repository
@RequiredArgsConstructor
public class PrdProductDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PrdProductRepo repo;
    private final QPrdProductDO qdo = QPrdProductDO.prdProductDO;

    private final QPrdProductClassDO classDO1 = new QPrdProductClassDO("classDO1");

    private final QPrdProductClassDO classDO2 = new QPrdProductClassDO("classDO2");

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdProductVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdProductVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                // 产品编号
                qdo.prodNo,
                // 产品名称
                qdo.prodName,
                // 产品大类;	表id，非udc
                qdo.classId,
                classDO1.className,
                // 产品小类
                qdo.subClassId,
                classDO2.className.as("subClassName"),
                // 税率
                qdo.taxRate,
                // 排序号
                qdo.sortNo,
                // 供应主体类别
                qdo.prodType,
                // BUID
                qdo.buId,
                // 产品负责人资源ID
                qdo.picResId,
                // 产品供应商ID
                qdo.coopId,
                // 状态
                qdo.prodStatus,
                // 适用行业
                qdo.industry,
                // 参考当量
                qdo.refEqva,
                // 参考价格
                qdo.refPrice,
                // 是否考察中
                qdo.inspectFlag,
                // 考察原因描述
                qdo.inspectReason,
                // 标签
                qdo.tagDesc,
                // 提成类别
                qdo.royaltyType,
                // LOGO路径
                qdo.logoPath,
                // 视频路径
                qdo.videoPath,
                // 软著名称
                qdo.copyrightName,
                // 软著编号
                qdo.copyrightCode,
                // 软著附件
                qdo.copyrightFileCodes,
                // 是否有测试报告
                qdo.reportFlag,
                // 测试报告附件
                qdo.reportFileCodes,
                // 是否有软件产品登记证
                qdo.sprcFlag,
                // 软件产品登记证名称
                qdo.sprcName,
                // 件产品登记证编号
                qdo.sprcCode,
                // 软著附件
                qdo.sprcFileCodes,
                // 软件产品登记证书有效日期开始
                qdo.startDate,
                // 软件产品登记证书有效日期开始
                qdo.endDate,
                // 产品简介
                qdo.prodDesc,
                // 功能模块
                qdo.functionDesc,
                // 目标客户
                qdo.customerDesc
        )).from(qdo)
                .leftJoin(classDO1).on(qdo.classId.longValue().eq(classDO1.id.longValue()))
                .leftJoin(classDO2).on(qdo.subClassId.longValue().eq(classDO2.id.longValue()));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdProductVO> getJpaQueryWhere(PrdProductQuery query) {
        JPAQuery<PrdProductVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PrdProductQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PrdProductQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 产品编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getProdNo())) {
             list.add(qdo.prodNo.like(SqlUtil.toSqlLikeString(query.getProdNo())));
        }
        /** 产品名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getProdName())) {
             list.add(qdo.prodName.like(SqlUtil.toSqlLikeString(query.getProdName())));
        }
        /** 产品大类;	表id，非udc 精确 */
        if (!ObjectUtils.isEmpty(query.getClassId())) {
            list.add(qdo.classId.eq(query.getClassId()));
        }
        /** 产品小类 精确 */
        if (!ObjectUtils.isEmpty(query.getSubClassId())) {
            list.add(qdo.subClassId.eq(query.getSubClassId()));
        }
        /** 税率 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxRate())) {
            list.add(qdo.taxRate.eq(query.getTaxRate()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 供应主体类别 精确 */
        if (!ObjectUtils.isEmpty(query.getProdType())) {
            list.add(qdo.prodType.eq(query.getProdType()));
        }
        /** BUID 精确 */
        if (!ObjectUtils.isEmpty(query.getBuId())) {
            list.add(qdo.buId.eq(query.getBuId()));
        }
        /** 产品负责人资源ID 精确 */
        if (!ObjectUtils.isEmpty(query.getPicResId())) {
            list.add(qdo.picResId.eq(query.getPicResId()));
        }
        /** 产品供应商ID 精确 */
        if (!ObjectUtils.isEmpty(query.getCoopId())) {
            list.add(qdo.coopId.eq(query.getCoopId()));
        }
        /** 状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProdStatus())) {
            list.add(qdo.prodStatus.eq(query.getProdStatus()));
        }
        /** 适用行业 精确 */
        if (!ObjectUtils.isEmpty(query.getIndustry())) {
            list.add(qdo.industry.eq(query.getIndustry()));
        }
        /** 参考当量 精确 */
        if (!ObjectUtils.isEmpty(query.getRefEqva())) {
            list.add(qdo.refEqva.eq(query.getRefEqva()));
        }
        /** 参考价格 精确 */
        if (!ObjectUtils.isEmpty(query.getRefPrice())) {
            list.add(qdo.refPrice.eq(query.getRefPrice()));
        }
        /** 是否考察中 精确 */
        if (!ObjectUtils.isEmpty(query.getInspectFlag())) {
            list.add(qdo.inspectFlag.eq(query.getInspectFlag()));
        }
        /** 考察原因描述 精确 */
        if (!ObjectUtils.isEmpty(query.getInspectReason())) {
            list.add(qdo.inspectReason.eq(query.getInspectReason()));
        }
        /** 标签 精确 */
        if (!ObjectUtils.isEmpty(query.getTagDesc())) {
            list.add(qdo.tagDesc.eq(query.getTagDesc()));
        }
        /** 提成类别 精确 */
        if (!ObjectUtils.isEmpty(query.getRoyaltyType())) {
            list.add(qdo.royaltyType.eq(query.getRoyaltyType()));
        }
        /** LOGO路径 精确 */
        if (!ObjectUtils.isEmpty(query.getLogoPath())) {
            list.add(qdo.logoPath.eq(query.getLogoPath()));
        }
        /** 视频路径 精确 */
        if (!ObjectUtils.isEmpty(query.getVideoPath())) {
            list.add(qdo.videoPath.eq(query.getVideoPath()));
        }
        /** 软著名称 精确 */
        if (!ObjectUtils.isEmpty(query.getCopyrightName())) {
            list.add(qdo.copyrightName.eq(query.getCopyrightName()));
        }
        /** 软著编号 精确 */
        if (!ObjectUtils.isEmpty(query.getCopyrightCode())) {
            list.add(qdo.copyrightCode.eq(query.getCopyrightCode()));
        }
        /** 软著附件 精确 */
        if (!ObjectUtils.isEmpty(query.getCopyrightFileCodes())) {
            list.add(qdo.copyrightFileCodes.eq(query.getCopyrightFileCodes()));
        }
        /** 是否有测试报告 精确 */
        if (!ObjectUtils.isEmpty(query.getReportFlag())) {
            list.add(qdo.reportFlag.eq(query.getReportFlag()));
        }
        /** 测试报告附件 精确 */
        if (!ObjectUtils.isEmpty(query.getReportFileCodes())) {
            list.add(qdo.reportFileCodes.eq(query.getReportFileCodes()));
        }
        /** 是否有软件产品登记证 精确 */
        if (!ObjectUtils.isEmpty(query.getSprcFlag())) {
            list.add(qdo.sprcFlag.eq(query.getSprcFlag()));
        }
        /** 软件产品登记证名称 精确 */
        if (!ObjectUtils.isEmpty(query.getSprcName())) {
            list.add(qdo.sprcName.eq(query.getSprcName()));
        }
        /** 件产品登记证编号 精确 */
        if (!ObjectUtils.isEmpty(query.getSprcCode())) {
            list.add(qdo.sprcCode.eq(query.getSprcCode()));
        }
        /** 软著附件 精确 */
        if (!ObjectUtils.isEmpty(query.getSprcFileCodes())) {
            list.add(qdo.sprcFileCodes.eq(query.getSprcFileCodes()));
        }
        /** 软件产品登记证书有效日期开始 精确 */
        if (!ObjectUtils.isEmpty(query.getStartDate())) {
            list.add(qdo.startDate.eq(query.getStartDate()));
        }
        /** 软件产品登记证书有效日期开始 精确 */
        if (!ObjectUtils.isEmpty(query.getEndDate())) {
            list.add(qdo.endDate.eq(query.getEndDate()));
        }
        /** 产品简介 精确 */
        if (!ObjectUtils.isEmpty(query.getProdDesc())) {
            list.add(qdo.prodDesc.eq(query.getProdDesc()));
        }
        /** 功能模块 精确 */
        if (!ObjectUtils.isEmpty(query.getFunctionDesc())) {
            list.add(qdo.functionDesc.eq(query.getFunctionDesc()));
        }
        /** 目标客户 精确 */
        if (!ObjectUtils.isEmpty(query.getCustomerDesc())) {
            list.add(qdo.customerDesc.eq(query.getCustomerDesc()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PrdProductVO queryByKey(Long id) {
        JPAQuery<PrdProductVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PrdProductVO> queryListDynamic(PrdProductQuery query) {
        JPAQuery<PrdProductVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdProductVO> queryPaging(PrdProductQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<PrdProductVO> jpaQuery = getJpaQueryWhere(query);
        List<PrdProductVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PrdProductVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdProductDO save(PrdProductDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PrdProductDO> saveAll(List<PrdProductDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PrdProductPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 产品编号
        if (payload.getProdNo() != null) {
            update.set(qdo.prodNo, payload.getProdNo());
        }
        // 产品名称
        if (payload.getProdName() != null) {
            update.set(qdo.prodName, payload.getProdName());
        }
        // 产品大类;	表id，非udc
        if (payload.getClassId() != null) {
            update.set(qdo.classId, payload.getClassId());
        }
        // 产品小类
        if (payload.getSubClassId() != null) {
            update.set(qdo.subClassId, payload.getSubClassId());
        }
        // 税率
        if (payload.getTaxRate() != null) {
            update.set(qdo.taxRate, payload.getTaxRate());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        // 供应主体类别
        if (payload.getProdType() != null) {
            update.set(qdo.prodType, payload.getProdType());
        }
        // BUID
        if (payload.getBuId() != null) {
            update.set(qdo.buId, payload.getBuId());
        }
        // 产品负责人资源ID
        if (payload.getPicResId() != null) {
            update.set(qdo.picResId, payload.getPicResId());
        }
        // 产品供应商ID
        if (payload.getCoopId() != null) {
            update.set(qdo.coopId, payload.getCoopId());
        }
        // 状态
        if (payload.getProdStatus() != null) {
            update.set(qdo.prodStatus, payload.getProdStatus());
        }
        // 适用行业
        if (payload.getIndustry() != null) {
            update.set(qdo.industry, payload.getIndustry());
        }
        // 参考当量
        if (payload.getRefEqva() != null) {
            update.set(qdo.refEqva, payload.getRefEqva());
        }
        // 参考价格
        if (payload.getRefPrice() != null) {
            update.set(qdo.refPrice, payload.getRefPrice());
        }
        // 是否考察中
        if (payload.getInspectFlag() != null) {
            update.set(qdo.inspectFlag, payload.getInspectFlag());
        }
        // 考察原因描述
        if (payload.getInspectReason() != null) {
            update.set(qdo.inspectReason, payload.getInspectReason());
        }
        // 标签
        if (payload.getTagDesc() != null) {
            update.set(qdo.tagDesc, payload.getTagDesc());
        }
        // 提成类别
        if (payload.getRoyaltyType() != null) {
            update.set(qdo.royaltyType, payload.getRoyaltyType());
        }
        // LOGO路径
        if (payload.getLogoPath() != null) {
            update.set(qdo.logoPath, payload.getLogoPath());
        }
        // 视频路径
        if (payload.getVideoPath() != null) {
            update.set(qdo.videoPath, payload.getVideoPath());
        }
        // 软著名称
        if (payload.getCopyrightName() != null) {
            update.set(qdo.copyrightName, payload.getCopyrightName());
        }
        // 软著编号
        if (payload.getCopyrightCode() != null) {
            update.set(qdo.copyrightCode, payload.getCopyrightCode());
        }
        // 软著附件
        if (payload.getCopyrightFileCodes() != null) {
            update.set(qdo.copyrightFileCodes, payload.getCopyrightFileCodes());
        }
        // 是否有测试报告
        if (payload.getReportFlag() != null) {
            update.set(qdo.reportFlag, payload.getReportFlag());
        }
        // 测试报告附件
        if (payload.getReportFileCodes() != null) {
            update.set(qdo.reportFileCodes, payload.getReportFileCodes());
        }
        // 是否有软件产品登记证
        if (payload.getSprcFlag() != null) {
            update.set(qdo.sprcFlag, payload.getSprcFlag());
        }
        // 软件产品登记证名称
        if (payload.getSprcName() != null) {
            update.set(qdo.sprcName, payload.getSprcName());
        }
        // 件产品登记证编号
        if (payload.getSprcCode() != null) {
            update.set(qdo.sprcCode, payload.getSprcCode());
        }
        // 软著附件
        if (payload.getSprcFileCodes() != null) {
            update.set(qdo.sprcFileCodes, payload.getSprcFileCodes());
        }
        // 软件产品登记证书有效日期开始
        if (payload.getStartDate() != null) {
            update.set(qdo.startDate, payload.getStartDate());
        }
        // 软件产品登记证书有效日期开始
        if (payload.getEndDate() != null) {
            update.set(qdo.endDate, payload.getEndDate());
        }
        // 产品简介
        if (payload.getProdDesc() != null) {
            update.set(qdo.prodDesc, payload.getProdDesc());
        }
        // 功能模块
        if (payload.getFunctionDesc() != null) {
            update.set(qdo.functionDesc, payload.getFunctionDesc());
        }
        // 目标客户
        if (payload.getCustomerDesc() != null) {
            update.set(qdo.customerDesc, payload.getCustomerDesc());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 产品编号
            if (nullFields.contains("prodNo")) {
                update.setNull(qdo.prodNo);
            }
            // 产品名称
            if (nullFields.contains("prodName")) {
                update.setNull(qdo.prodName);
            }
            // 产品大类;	表id，非udc
            if (nullFields.contains("classId")) {
                update.setNull(qdo.classId);
            }
            // 产品小类
            if (nullFields.contains("subClassId")) {
                update.setNull(qdo.subClassId);
            }
            // 税率
            if (nullFields.contains("taxRate")) {
                update.setNull(qdo.taxRate);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }
            // 供应主体类别
            if (nullFields.contains("prodType")) {
                update.setNull(qdo.prodType);
            }
            // BUID
            if (nullFields.contains("buId")) {
                update.setNull(qdo.buId);
            }
            // 产品负责人资源ID
            if (nullFields.contains("picResId")) {
                update.setNull(qdo.picResId);
            }
            // 产品供应商ID
            if (nullFields.contains("coopId")) {
                update.setNull(qdo.coopId);
            }
            // 状态
            if (nullFields.contains("prodStatus")) {
                update.setNull(qdo.prodStatus);
            }
            // 适用行业
            if (nullFields.contains("industry")) {
                update.setNull(qdo.industry);
            }
            // 参考当量
            if (nullFields.contains("refEqva")) {
                update.setNull(qdo.refEqva);
            }
            // 参考价格
            if (nullFields.contains("refPrice")) {
                update.setNull(qdo.refPrice);
            }
            // 是否考察中
            if (nullFields.contains("inspectFlag")) {
                update.setNull(qdo.inspectFlag);
            }
            // 考察原因描述
            if (nullFields.contains("inspectReason")) {
                update.setNull(qdo.inspectReason);
            }
            // 标签
            if (nullFields.contains("tagDesc")) {
                update.setNull(qdo.tagDesc);
            }
            // 提成类别
            if (nullFields.contains("royaltyType")) {
                update.setNull(qdo.royaltyType);
            }
            // LOGO路径
            if (nullFields.contains("logoPath")) {
                update.setNull(qdo.logoPath);
            }
            // 视频路径
            if (nullFields.contains("videoPath")) {
                update.setNull(qdo.videoPath);
            }
            // 软著名称
            if (nullFields.contains("copyrightName")) {
                update.setNull(qdo.copyrightName);
            }
            // 软著编号
            if (nullFields.contains("copyrightCode")) {
                update.setNull(qdo.copyrightCode);
            }
            // 软著附件
            if (nullFields.contains("copyrightFileCodes")) {
                update.setNull(qdo.copyrightFileCodes);
            }
            // 是否有测试报告
            if (nullFields.contains("reportFlag")) {
                update.setNull(qdo.reportFlag);
            }
            // 测试报告附件
            if (nullFields.contains("reportFileCodes")) {
                update.setNull(qdo.reportFileCodes);
            }
            // 是否有软件产品登记证
            if (nullFields.contains("sprcFlag")) {
                update.setNull(qdo.sprcFlag);
            }
            // 软件产品登记证名称
            if (nullFields.contains("sprcName")) {
                update.setNull(qdo.sprcName);
            }
            // 件产品登记证编号
            if (nullFields.contains("sprcCode")) {
                update.setNull(qdo.sprcCode);
            }
            // 软著附件
            if (nullFields.contains("sprcFileCodes")) {
                update.setNull(qdo.sprcFileCodes);
            }
            // 软件产品登记证书有效日期开始
            if (nullFields.contains("startDate")) {
                update.setNull(qdo.startDate);
            }
            // 软件产品登记证书有效日期开始
            if (nullFields.contains("endDate")) {
                update.setNull(qdo.endDate);
            }
            // 产品简介
            if (nullFields.contains("prodDesc")) {
                update.setNull(qdo.prodDesc);
            }
            // 功能模块
            if (nullFields.contains("functionDesc")) {
                update.setNull(qdo.functionDesc);
            }
            // 目标客户
            if (nullFields.contains("customerDesc")) {
                update.setNull(qdo.customerDesc);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

