package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PcontractPayplanVO;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 旧采购合同付款计划
 *
 * @author likunpeng
 * @date 2024-01-09
 */
@Entity
@Table(name = "t_pcontract_payplan", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_pcontract_payplan", comment = "旧采购合同付款计划")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PcontractPayplanDO extends BaseModel implements Serializable  {
    /** 采购合同ID */
    @Comment("采购合同ID")
    @Column()
    private Long pcontractId;
    /** 行号 */
    @Comment("行号")
    @Column()
    private BigDecimal lineNo;
    /** 付款阶段 */
    @Comment("付款阶段")
    @Column()
    private String phaseDesc;
    /** 付款号 */
    @Comment("付款号")
    @Column()
    private String payNo;
    /** 付款状态 */
    @Comment("付款状态")
    @Column()
    private String payStatus;
    /** 审批状态 */
    @Comment("审批状态")
    @Column()
    private String apprStatus;
    /** 当期付款比例 */
    @Comment("当期付款比例")
    @Column()
    private BigDecimal payRatio;
    /** 当期付款金额 */
    @Comment("当期付款金额")
    @Column()
    private BigDecimal payAmt;
    /** 预计付款日期 */
    @Comment("预计付款日期")
    @Column()
    private LocalDate planPayDate;
    /** 已付款金额 */
    @Comment("已付款金额")
    @Column()
    private BigDecimal actualPayAmt;
    /** 实际付款日期 */
    @Comment("实际付款日期")
    @Column()
    private LocalDate actualPayDate;
    /** 计划状态 */
    @Comment("计划状态")
    @Column()
    private String planStatus;
    /** 付款阶段号 */
    @Comment("付款阶段号")
    @Column()
    private String phaseNo;

    public void copy(PcontractPayplanDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
