package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchasePaymentPlanPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.LatePaymentPlanQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementPaymentQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchasePaymentPlanQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PaymentSlipService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentPlanService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.LatePaymentPlanVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentPlanVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.WriteOffPaymentApplyVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchasePaymentPlanConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchasePaymentPlanDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchasePaymentPlanDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchasePaymentPlanRepo;
import com.querydsl.core.Tuple;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 采购合同管理
 *
 * @author lipengfei
 * @date 2023-05-30
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PurchasePaymentPlanServiceImpl extends BaseServiceImpl implements PurchasePaymentPlanService {

    private final PurchasePaymentPlanRepo purchasePaymentPlanRepo;
    private final PurchasePaymentPlanDAO purchasePaymentPlanDAO;
    private final PrdSystemLogService logService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final BusinessPartnerService businessPartnerService;
    @Autowired
    private PurchasePaymentService purchasePaymentService;
    @Autowired
    private final PaymentSlipService paymentSlipService;

    @Override
    public PagingVO<PurchasePaymentPlanVO> queryPaging(PurchasePaymentPlanQuery query) {
        return purchasePaymentPlanDAO.queryPaging(query);
    }

    @Override
    public List<PurchasePaymentPlanVO> queryListDynamic(PurchasePaymentPlanQuery query) {
        return purchasePaymentPlanDAO.queryListDynamic(query);
    }

    @Override
    public PurchasePaymentPlanVO queryByKey(Long key) {
        PurchasePaymentPlanDO entity = purchasePaymentPlanRepo.findById(key).orElseGet(PurchasePaymentPlanDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PurchasePaymentPlanVO vo = PurchasePaymentPlanConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PurchasePaymentPlanVO insert(PurchasePaymentPlanPayload payload) {
        PurchasePaymentPlanDO entityDo = PurchasePaymentPlanConvert.INSTANCE.toDo(payload);
        PurchasePaymentPlanDO save = purchasePaymentPlanRepo.save(entityDo);
        // 获取变更日志
        final String fieldsCreateLog = changeFieldLogUtil.getFieldsCreateLog(entityDo);
        logService.saveNewLog(save.getId(), PrdSystemObjectEnum.PROCUREMENT_PAYPLAN.getCode(), fieldsCreateLog);
        return PurchasePaymentPlanConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PurchasePaymentPlanVO update(PurchasePaymentPlanPayload payload) {
        PurchasePaymentPlanDO entity = purchasePaymentPlanRepo.findById(payload.getId()).orElseGet(PurchasePaymentPlanDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PurchasePaymentPlanDO entityDo = PurchasePaymentPlanConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PurchasePaymentPlanConvert.INSTANCE.toVo(purchasePaymentPlanRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            purchasePaymentPlanDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<PurchasePaymentPlanVO> findListByConNo(String docNo, Boolean applyIdIsNull) {
        return purchasePaymentPlanDAO.findListByConNo(docNo, applyIdIsNull);
    }

    @Override
    public List<PurchasePaymentPlanVO> queryListByPaymentApplyId(Long paymentApplyId) {
        return purchasePaymentPlanDAO.queryListByPaymentApplyId(paymentApplyId);
    }

    @Override
    public void setPaymentApplyVOPlanList(PurchasePaymentVO purchasePaymentVO) {
        // 查询付款计划
        List<PurchasePaymentPlanVO> purchasePaymentPlanVOS = purchasePaymentPlanDAO.queryListByPaymentApplyId(purchasePaymentVO.getId());
        if (CollectionUtils.isEmpty(purchasePaymentPlanVOS)) {
            return;
        }
        // 如果为预付款核销单，查询其下付款明细未核销金额
        if (PurchasePaymentEnum.PaymentType.ADVANCE_PAY_WRITE_OFF.getCode().equals(purchasePaymentVO.getPaymentApplicationType())) {
            List<Long> prePaymentPlanIds = new ArrayList<>(purchasePaymentPlanVOS.size());
            purchasePaymentPlanVOS.forEach(purchasePaymentPlanVO -> {
                Long prePaymentPlanId = purchasePaymentPlanVO.getPrePaymentPlanId();
                if (prePaymentPlanId != null) {
                    prePaymentPlanIds.add(prePaymentPlanId);
                }
            });
            Map<Long, BigDecimal> writeOffAmtMap = this.findWriteOffAmtByPrePaymentPlanIdIn(prePaymentPlanIds);
            purchasePaymentPlanVOS.forEach(purchasePaymentPlanVO -> {
                BigDecimal paymentAmt = purchasePaymentPlanVO.getPaymentAmt() == null ? BigDecimal.ZERO : purchasePaymentPlanVO.getPaymentAmt();
                BigDecimal writeOffAmt = writeOffAmtMap.get(purchasePaymentPlanVO.getPrePaymentPlanId());
                writeOffAmt = writeOffAmt == null ? BigDecimal.ZERO : writeOffAmt;
                purchasePaymentPlanVO.setAlreadyWriteOffAmt(writeOffAmt);
                purchasePaymentPlanVO.setNoWriteOffAmt(paymentAmt.subtract(writeOffAmt));
            });
        }else if (PurchasePaymentEnum.PaymentType.ADVANCE_PAY.getCode().equals(purchasePaymentVO.getPaymentApplicationType())) {
            // 如果为预付款单据，设置付款计划的已核销金额、核销单（采购合同、采购协议）
            this.setWriteOffAmtAndPlans(purchasePaymentPlanVOS);
        }
        purchasePaymentVO.setPurchasePaymentPlanVOS(purchasePaymentPlanVOS);
    }

    /**
     * 查询付款计划已核销金额
     * @param prePaymentPlanIds 预付款核销付款计划关联预付款付款计划id
     * @return result
     */
    private Map<Long, BigDecimal> findWriteOffAmtByPrePaymentPlanIdIn(List<Long> prePaymentPlanIds) {
        Map<Long, BigDecimal> resultMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(prePaymentPlanIds)) {
            List<Tuple> writeOffAmtList = purchasePaymentPlanDAO.findWriteOffAmtByPrePaymentPlanIdIn(prePaymentPlanIds);
            if (!CollectionUtils.isEmpty(writeOffAmtList)) {
                writeOffAmtList.forEach(tuple -> {
                    Long prePaymentPlanId = tuple.get(0, Long.class);
                    BigDecimal writeOffAmt = tuple.get(1, BigDecimal.class) == null ? BigDecimal.ZERO : tuple.get(1, BigDecimal.class);
                    resultMap.put(prePaymentPlanId, writeOffAmt);
                });
            }
        }
        return resultMap;
    }

    @Override
    public void resettingPlanByPaymentId(Long paymentApplyId) {
        purchasePaymentPlanDAO.resettingPlanByPaymentId(paymentApplyId);
    }

    @Override
    public void updatePlans(List<PurchasePaymentPlanPayload> purchasePaymentPlanPayloads) {
        purchasePaymentPlanPayloads.forEach(purchasePaymentPlanDAO::updatePlan);
    }

    @Override
    public void insertAll(List<PurchasePaymentPlanPayload> purchasePaymentPlanPayloads) {
        List<PurchasePaymentPlanDO> purchasePaymentPlanDOS = new ArrayList<>();
        purchasePaymentPlanPayloads.forEach(purchasePaymentPlanPayload -> {
            PurchasePaymentPlanDO purchasePaymentPlanDO = PurchasePaymentPlanConvert.INSTANCE.toDo(purchasePaymentPlanPayload);
            purchasePaymentPlanDOS.add(purchasePaymentPlanDO);
        });
        purchasePaymentPlanRepo.saveAll(purchasePaymentPlanDOS);
    }

    @Override
    public void deleteByPaymentId(Long id) {
        purchasePaymentPlanDAO.deleteByPaymentId(id);
    }

    @Override
    public PagingVO<LatePaymentPlanVO> findLatePaymentPlanList(LatePaymentPlanQuery latePaymentPlanQuery) {
        PagingVO<LatePaymentPlanVO> latePaymentPlanList = purchasePaymentPlanDAO.findLatePaymentPlanList(latePaymentPlanQuery);
        this.translateBusinessPartner(latePaymentPlanList.getRecords());
        return latePaymentPlanList;
    }

    @Override
    public PagingVO<PurchasePaymentPlanVO> findPlanListByAgreementNo(PurchaseAgreementPaymentQuery query) {
        PagingVO<PurchasePaymentPlanVO> planListByAgreementNo = purchasePaymentPlanDAO.findPlanListByAgreementNo(query);
        // 查询付款计划，不包含预付款核销时新增的
        List<PurchasePaymentPlanVO> records = planListByAgreementNo.getRecords();
        this.setWriteOffAmtAndPlans(records);
        return planListByAgreementNo;
    }

    @Override
    public List<PurchasePaymentPlanVO> findPlanListByConOrAgreementNoAndPrePaymentNo(String conOrAgreementNo, String prePaymentNo) {
        // 预付款付款计划
        List<PurchasePaymentPlanVO> purchasePaymentPlanVOS = purchasePaymentPlanDAO.findPlanListByConOrAgreementNoAndPrePaymentNo(conOrAgreementNo, prePaymentNo);
        this.setWriteOffAmtAndPlans(purchasePaymentPlanVOS);
        return purchasePaymentPlanVOS;
    }

    @Override
    public List<PurchasePaymentPlanVO> queryListByConId(Long purConId, Boolean isIgnoreWriteOff) {
        List<PurchasePaymentPlanVO> purchasePaymentPlanVOS = purchasePaymentPlanDAO.queryListByConId(purConId, isIgnoreWriteOff);
        this.setWriteOffAmtAndPlans(purchasePaymentPlanVOS);
        return purchasePaymentPlanVOS;
    }

    /**
     * 翻译业务伙伴名称
     * @param result 要翻译的集合
     */
    private void translateBusinessPartner(List<LatePaymentPlanVO> result) {
        // 地址簿列表
        List<Long> bookIdList = new ArrayList<>();
        result.forEach(latePaymentPlanVO -> bookIdList.add(latePaymentPlanVO.getSupplierBookId()));
        Map<Long, String> nameByBookIds = businessPartnerService.findNameByBookIds(bookIdList);
        result.forEach(latePaymentPlanVO -> latePaymentPlanVO.setSupplierName(nameByBookIds.get(latePaymentPlanVO.getSupplierBookId())));
    }


    /**
     * 设置付款计划的已核销金额、核销单（采购合同、采购协议）
     * @param purchasePaymentPlanVOS 付款计划列表
     */
    private void setWriteOffAmtAndPlansOld(List<PurchasePaymentPlanVO> purchasePaymentPlanVOS) {
        // 预付款单据编号
        List<String> prePaymentApplyNoList = new ArrayList<>();
        purchasePaymentPlanVOS.forEach(purchasePaymentPlanVO -> {
            // 预付款单据
            if (PurchasePaymentEnum.PaymentType.ADVANCE_PAY.getCode().equals(purchasePaymentPlanVO.getPaymentApplicationType())) {
                prePaymentApplyNoList.add(purchasePaymentPlanVO.getPaymentApplyNo());
            }
        });
        // 如果存在预付款的，查询预付款已核销金额、核销单据号
        if (!CollectionUtils.isEmpty(prePaymentApplyNoList)) {
            Map<String, List<WriteOffPaymentApplyVO>> writeOffMap = purchasePaymentService.findWriteOffByPrePaymentNoList(prePaymentApplyNoList);
            purchasePaymentPlanVOS.forEach(purchasePaymentPlanVO -> {
                List<WriteOffPaymentApplyVO> writeOffPaymentApplyVOS = writeOffMap.get(purchasePaymentPlanVO.getPaymentApplyNo());
                if (!CollectionUtils.isEmpty(writeOffPaymentApplyVOS)) {
                    // 预付款核销单据
                    purchasePaymentPlanVO.setWriteOffAmtPaymentApplyVOS(writeOffPaymentApplyVOS);
                    // 已核销金额
                    BigDecimal alreadyWrittenOffAmount = BigDecimal.ZERO;
                    // 付款金额
                    BigDecimal paymentAmt = purchasePaymentPlanVO.getPaymentAmt() == null ? BigDecimal.ZERO : purchasePaymentPlanVO.getPaymentAmt();
                    for (WriteOffPaymentApplyVO writeOffPaymentApplyVO : writeOffPaymentApplyVOS) {
                        if (PurchasePaymentEnum.PaymentStatus.APPROVED.getCode().equals(writeOffPaymentApplyVO.getState())) {
                            BigDecimal currCurrPaymentAmt = writeOffPaymentApplyVO.getCurrPaymentAmt() == null ? BigDecimal.ZERO : writeOffPaymentApplyVO.getCurrPaymentAmt();
                            alreadyWrittenOffAmount = alreadyWrittenOffAmount.add(currCurrPaymentAmt);
                        }
                    }
                    purchasePaymentPlanVO.setAlreadyWriteOffAmt(alreadyWrittenOffAmount);
                    purchasePaymentPlanVO.setNoWriteOffAmt(paymentAmt.subtract(alreadyWrittenOffAmount));
                }
            });
        }
    }


    /**
     * 设置付款计划的已核销金额、核销单（采购合同、采购协议）
     * @param purchasePaymentPlanVOS 付款计划列表
     */
    private void setWriteOffAmtAndPlans(List<PurchasePaymentPlanVO> purchasePaymentPlanVOS) {
        // 预付款付款计划
        List<PurchasePaymentPlanVO> prePaymentPlanVOList = new ArrayList<>();
        // 预付款付款计划Id
        List<Long> prePaymentPlanId = new ArrayList<>();
        // 付款申请单Id
        Set<Long> paymentApplyIdSet = new HashSet<>();
        purchasePaymentPlanVOS.forEach(purchasePaymentPlanVO -> {
            // 预付款单据
            if (PurchasePaymentEnum.PaymentType.ADVANCE_PAY.getCode().equals(purchasePaymentPlanVO.getPaymentApplicationType())) {
                prePaymentPlanVOList.add(purchasePaymentPlanVO);
                prePaymentPlanId.add(purchasePaymentPlanVO.getId());
                paymentApplyIdSet.add(purchasePaymentPlanVO.getPaymentApplyId());
            }
        });
        // 如果存在预付款的，查询预付款的已核销金额、核销单据号
        if (!CollectionUtils.isEmpty(prePaymentPlanVOList)) {
            // 查询预付款付款计划的预付款核销单下的付款计划
            List<PurchasePaymentPlanVO> writeOffPlanVOS = purchasePaymentPlanDAO.queryListByPrePaymentPlanId(prePaymentPlanId);
            // 分组
            Map<Long, List<PurchasePaymentPlanVO>> writeOffMap = writeOffPlanVOS.stream()
                    .collect(Collectors.groupingBy(PurchasePaymentPlanVO::getPrePaymentPlanId));
            // 查询付款单记录未支付的金额
            Map<Long, BigDecimal> noPayAmtMap = paymentSlipService.findNoPayAmtByPaymentApplyIdIn(paymentApplyIdSet);
            // 设置该条付款计划的已核销金额、核销单据号、未核销金额
            prePaymentPlanVOList.forEach(purchasePaymentPlanVO -> {
                // 预付款核销中付款计划
                List<PurchasePaymentPlanVO> writeOffPaymentPlanVOS = writeOffMap.get(purchasePaymentPlanVO.getId());
                // 已核销金额
                final BigDecimal[] alreadyWriteOffAmt = {BigDecimal.ZERO};
                // 本次付款金额
                BigDecimal currentPaymentAmt = purchasePaymentPlanVO.getCurrentPaymentAmt() == null ? BigDecimal.ZERO : purchasePaymentPlanVO.getCurrentPaymentAmt();
                if (!CollectionUtils.isEmpty(writeOffPaymentPlanVOS)) {
                    // 核销单List
                    List<WriteOffPaymentApplyVO> writeOffPaymentApplyVOS = new ArrayList<>();
                    Map<Long, List<PurchasePaymentPlanVO>> writeOffPaymentPlanMap = writeOffPaymentPlanVOS.stream()
                            .collect(Collectors.groupingBy(PurchasePaymentPlanVO::getPaymentApplyId));
                    writeOffPaymentPlanMap.values().forEach(writeOffPlanVOList -> {
                        WriteOffPaymentApplyVO writeOffPaymentApplyVO = new WriteOffPaymentApplyVO();
                        writeOffPlanVOList.forEach(writeOffPlan -> {
                            writeOffPaymentApplyVO.setPaymentNo(writeOffPlan.getPaymentApplyNo());
                            writeOffPaymentApplyVO.setId(writeOffPlan.getPaymentApplyId());
                            alreadyWriteOffAmt[0] = alreadyWriteOffAmt[0].add(writeOffPlan.getCurrentPaymentAmt());
                        });
                        writeOffPaymentApplyVO.setCurrPaymentAmt(alreadyWriteOffAmt[0]);
                        writeOffPaymentApplyVOS.add(writeOffPaymentApplyVO);
                    });
                    // 预付款核销单据
                    purchasePaymentPlanVO.setWriteOffAmtPaymentApplyVOS(writeOffPaymentApplyVOS);
                }
                // 已核销金额
                purchasePaymentPlanVO.setAlreadyWriteOffAmt(alreadyWriteOffAmt[0]);
                // 付款单记录中未付款金额
                BigDecimal noPayAmt = noPayAmtMap.get(purchasePaymentPlanVO.getPaymentApplyId()) == null ? BigDecimal.ZERO : noPayAmtMap.get(purchasePaymentPlanVO.getPaymentApplyId());
                // 未核销金额 本次付款金额-已核销金额-付款单记录中状态不为已付款的金额
                purchasePaymentPlanVO.setNoWriteOffAmt(currentPaymentAmt.subtract(alreadyWriteOffAmt[0]).subtract(noPayAmt));
            });
        }
    }

    @Override
    public BigDecimal findWriteOffAmtByPrePaymentNo(String prePaymentNo) {
        return purchasePaymentPlanDAO.findWriteOffAmtByPrePaymentNo(prePaymentNo);
    }
}
