package com.elitesland.tw.tw5.server.prd.salecon.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanConfirmPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanConfirmQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanConfirmService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanConfirmVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 收款计划确认单
 *
 * @author lemon
 * @date 2023-12-23
 */
@Api(tags = "收款计划确认单")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/conReceivablePlanConfirm")
@Slf4j
public class ConReceivablePlanConfirmController {

    private final ConReceivablePlanConfirmService conReceivablePlanConfirmService;

    /**
     * 收款计划确认单-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("收款计划确认单-新增")
    public TwOutputUtil<ConReceivablePlanConfirmVO> insert(@RequestBody ConReceivablePlanConfirmPayload payload){
        return TwOutputUtil.ok(conReceivablePlanConfirmService.insert(payload));
    }

    /**
     * 收款计划确认单-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("收款计划确认单-更新")
    public TwOutputUtil<ConReceivablePlanConfirmVO> update(@RequestBody ConReceivablePlanConfirmPayload payload){
        return TwOutputUtil.ok(conReceivablePlanConfirmService.update(payload));
    }

    /**
     * 收款计划确认单-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("收款计划确认单-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody ConReceivablePlanConfirmPayload payload){
        return TwOutputUtil.ok(conReceivablePlanConfirmService.updateByKeyDynamic(payload));
    }

    /**
     * 收款计划确认单-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("收款计划确认单-主键查询")
    public TwOutputUtil<ConReceivablePlanConfirmVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(conReceivablePlanConfirmService.queryByKey(key));
    }

    /**
     * 收款计划确认单-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("收款计划确认单-分页")
    public TwOutputUtil<PagingVO<ConReceivablePlanConfirmVO>> paging(ConReceivablePlanConfirmQuery query) {
        return TwOutputUtil.ok(conReceivablePlanConfirmService.queryPaging(query));
    }

    /**
     * 收款计划确认单-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("收款计划确认单-查询列表")
    public TwOutputUtil<List<ConReceivablePlanConfirmVO>> queryList(ConReceivablePlanConfirmQuery query) {
        return TwOutputUtil.ok(conReceivablePlanConfirmService.queryListDynamic(query));
    }

    /**
     * 收款计划确认单-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("收款计划确认单-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        conReceivablePlanConfirmService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping("/autoCreateFlow")
    @ApiOperation("收款计划确认单定时任务")
    public TwOutputUtil autoCreateFlow(@RequestParam(required = false) Long signBuId){
        return TwOutputUtil.ok(conReceivablePlanConfirmService.autoCreateFlow(signBuId));
    }

}
