package com.elitesland.tw.tw5.server.prd.salecon.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvBatchInvdtlPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvBatchInvdtlQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchInvdtlVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvBatchInvdtlDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QConInvBatchInvdtlDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConInvBatchInvdtlRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * invdtl
 *
 * @author zoey
 * @date 2023-08-02
 */
@Repository
@RequiredArgsConstructor
public class ConInvBatchInvdtlDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final ConInvBatchInvdtlRepo repo;
    private final QConInvBatchInvdtlDO qdo = QConInvBatchInvdtlDO.conInvBatchInvdtlDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<ConInvBatchInvdtlVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(ConInvBatchInvdtlVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 开票批次ID
                qdo.invbatchId,
                // 发票号
                qdo.invNo,
                // 不含税金额
                qdo.netAmt,
                // 税额
                qdo.taxAmt,
                // 发票金额
                qdo.invAmt,
                // 发票状态
                qdo.invStatus,
                // 快递单号
                qdo.deliveryNo,
                // 快递日期
                qdo.deliveryDate,
                // 发票来源（null:手工插入）
                qdo.comeFrom,
                // 发票下载地址（null:手工插入无地址）
                qdo.downloadUrl,
                qdo.actualInvDate,
                qdo.taxRate
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<ConInvBatchInvdtlVO> getJpaQueryWhere(ConInvBatchInvdtlQuery query) {
        JPAQuery<ConInvBatchInvdtlVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(ConInvBatchInvdtlQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(ConInvBatchInvdtlQuery query) {
        List<Predicate> list = new ArrayList<>();
        /**  精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 开票批次ID 精确 */
        if (!ObjectUtils.isEmpty(query.getInvbatchId())) {
            list.add(qdo.invbatchId.eq(query.getInvbatchId()));
        }
        /** 发票号 精确 */
        if (!ObjectUtils.isEmpty(query.getInvNo())) {
            list.add(qdo.invNo.eq(query.getInvNo()));
        }
        /** 不含税金额 精确 */
        if (!ObjectUtils.isEmpty(query.getNetAmt())) {
            list.add(qdo.netAmt.eq(query.getNetAmt()));
        }
        /** 税额 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxAmt())) {
            list.add(qdo.taxAmt.eq(query.getTaxAmt()));
        }
        /** 发票金额 精确 */
        if (!ObjectUtils.isEmpty(query.getInvAmt())) {
            list.add(qdo.invAmt.eq(query.getInvAmt()));
        }
        /** 发票状态 精确 */
        if (!ObjectUtils.isEmpty(query.getInvStatus())) {
            list.add(qdo.invStatus.eq(query.getInvStatus()));
        }
        /** 快递单号 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliveryNo())) {
            list.add(qdo.deliveryNo.eq(query.getDeliveryNo()));
        }
        /** 快递日期 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliveryDate())) {
            list.add(qdo.deliveryDate.eq(query.getDeliveryDate()));
        }
        /** 发票来源（null:手工插入） 精确 */
        if (!ObjectUtils.isEmpty(query.getComeFrom())) {
            list.add(qdo.comeFrom.eq(query.getComeFrom()));
        }
        /** 发票下载地址（null:手工插入无地址） 精确 */
        if (!ObjectUtils.isEmpty(query.getDownloadUrl())) {
            list.add(qdo.downloadUrl.eq(query.getDownloadUrl()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public ConInvBatchInvdtlVO queryByKey(Long id) {
        JPAQuery<ConInvBatchInvdtlVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<ConInvBatchInvdtlVO> queryListDynamic(ConInvBatchInvdtlQuery query) {
        JPAQuery<ConInvBatchInvdtlVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<ConInvBatchInvdtlVO> queryPaging(ConInvBatchInvdtlQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<ConInvBatchInvdtlVO> jpaQuery = getJpaQueryWhere(query);
        List<ConInvBatchInvdtlVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<ConInvBatchInvdtlVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public ConInvBatchInvdtlDO save(ConInvBatchInvdtlDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<ConInvBatchInvdtlDO> saveAll(List<ConInvBatchInvdtlDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(ConInvBatchInvdtlPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 开票批次ID
        if (payload.getInvbatchId() != null) {
            update.set(qdo.invbatchId, payload.getInvbatchId());
        }
        // 发票号
        if (payload.getInvNo() != null) {
            update.set(qdo.invNo, payload.getInvNo());
        }
        // 不含税金额
        if (payload.getNetAmt() != null) {
            update.set(qdo.netAmt, payload.getNetAmt());
        }
        // 税额
        if (payload.getTaxAmt() != null) {
            update.set(qdo.taxAmt, payload.getTaxAmt());
        }
        // 发票金额
        if (payload.getInvAmt() != null) {
            update.set(qdo.invAmt, payload.getInvAmt());
        }
        // 发票状态
        if (payload.getInvStatus() != null) {
            update.set(qdo.invStatus, payload.getInvStatus());
        }
        // 快递单号
        if (payload.getDeliveryNo() != null) {
            update.set(qdo.deliveryNo, payload.getDeliveryNo());
        }
        // 快递日期
        if (payload.getDeliveryDate() != null) {
            update.set(qdo.deliveryDate, payload.getDeliveryDate());
        }
        // 发票来源（null:手工插入）
        if (payload.getComeFrom() != null) {
            update.set(qdo.comeFrom, payload.getComeFrom());
        }
        // 发票下载地址（null:手工插入无地址）
        if (payload.getDownloadUrl() != null) {
            update.set(qdo.downloadUrl, payload.getDownloadUrl());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 开票批次ID
            if (nullFields.contains("invbatchId")) {
                update.setNull(qdo.invbatchId);
            }
            // 发票号
            if (nullFields.contains("invNo")) {
                update.setNull(qdo.invNo);
            }
            // 不含税金额
            if (nullFields.contains("netAmt")) {
                update.setNull(qdo.netAmt);
            }
            // 税额
            if (nullFields.contains("taxAmt")) {
                update.setNull(qdo.taxAmt);
            }
            // 发票金额
            if (nullFields.contains("invAmt")) {
                update.setNull(qdo.invAmt);
            }
            // 发票状态
            if (nullFields.contains("invStatus")) {
                update.setNull(qdo.invStatus);
            }
            // 快递单号
            if (nullFields.contains("deliveryNo")) {
                update.setNull(qdo.deliveryNo);
            }
            // 快递日期
            if (nullFields.contains("deliveryDate")) {
                update.setNull(qdo.deliveryDate);
            }
            // 发票来源（null:手工插入）
            if (nullFields.contains("comeFrom")) {
                update.setNull(qdo.comeFrom);
            }
            // 发票下载地址（null:手工插入无地址）
            if (nullFields.contains("downloadUrl")) {
                update.setNull(qdo.downloadUrl);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}