package com.elitesland.tw.tw5.server.prd.salecon.repo;

import com.elitesland.tw.tw5.server.prd.salecon.entity.ConAchieveDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

import java.util.List;

/**
 * 业绩统计
 *
 * @author likunpeng
 * @date 2023-04-24
 */
public interface ConAchieveRepo extends JpaRepository<ConAchieveDO, Long>, JpaSpecificationExecutor<ConAchieveDO> {

    @Query(value = " select * from con_achieve e where e.modify_time >= ?1  ", nativeQuery = true)
    List<ConAchieveDO> findByModifyTimeStart(String format);

    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update con_achieve set modify_time=now() where id=?1",nativeQuery = true)
    @Modifying
    void updateRemark(Long id);

    List<ConAchieveDO> findByAchieveIdV4In(List<Long> tw4ContractAchieveIds);
}
