package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFinPeriodPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFinPeriodQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFinPeriodVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFinPeriodService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 财务期间
 *
 * @author likunpeng
 * @date 2023-04-12
 */
@Api(tags = "财务期间")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/system/prdSystemFinPeriod")
@Slf4j
public class PrdSystemFinPeriodController {

    private final PrdSystemFinPeriodService prdSystemFinPeriodService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody PrdSystemFinPeriodPayload payload){
        return TwOutputUtil.ok(prdSystemFinPeriodService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody PrdSystemFinPeriodPayload payload){
        return TwOutputUtil.ok(prdSystemFinPeriodService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(prdSystemFinPeriodService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(PrdSystemFinPeriodQuery query) {
        return TwOutputUtil.ok(prdSystemFinPeriodService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(PrdSystemFinPeriodQuery query) {
        return TwOutputUtil.ok(prdSystemFinPeriodService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        prdSystemFinPeriodService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


}
