package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFunctionSpecialPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionSpecialQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFunctionSpecialService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionSpecialVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

import static com.elitesland.tw.tw5.server.prd.common.SystemConstants.API_SYSTEM;

/**
 * 系统功能关键行为项
 *
 * @author wangding
 */
@Api("系统设置关键行为项")
@RestController
@RequiredArgsConstructor
@RequestMapping(API_SYSTEM)
@Slf4j
public class PrdSystemFunctionSpecialController {

    private final PrdSystemFunctionSpecialService service;

    /**
     * 新建
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/function/special/insert")
    public TwOutputUtil insert(PrdSystemFunctionSpecialPayload entity) {
        PrdSystemFunctionSpecialVO vo = service.insert(entity);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 全部修改
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("修改")
    @PutMapping("/function/special/update")
    public TwOutputUtil update(PrdSystemFunctionSpecialPayload entity) {
        service.update(entity);
        return TwOutputUtil.ok();
    }
    
    /**
     * 分页查询
     *
     * @param query 查询条件
     * @return result
     */
    @ApiOperation("分页查询")
    @GetMapping("/function/special/paging")
    public TwOutputUtil findByConditionPaging(PrdSystemFunctionSpecialQuery query) {
        PagingVO<PrdSystemFunctionSpecialVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 列表查询
     *
     * @param query 查询条件
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/function/special/list")
    public TwOutputUtil list(PrdSystemFunctionSpecialQuery query) {
        List<PrdSystemFunctionSpecialVO> paging = service.queryList(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("物理删除")
    @DeleteMapping("/function/special/delete")
    public TwOutputUtil delete(Long[] keys) {
        service.delete(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 根据主键查询
     *
     * @param key 主键
     * @return result
     */
    @ApiOperation("主键查询")
    @GetMapping("/function/Special/{key}")
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdSystemFunctionSpecialVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

}
