package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemPermissionFieldObjRoleFunctionPayload;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRolePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionFieldObjRoleFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemPermissionFieldObjRoleFunctionService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemPermissionFieldService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemPermissionFunctionObjectService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.*;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.RedisUtils;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemPermissionFieldObjRoleFunctionConvert;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemRoleConvert;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemRoleGroupRoleConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.*;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemBusinessObjectRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemPermissionFieldObjRoleFunctionRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemPermissionFunctionObjectRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 菜单管理service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemRoleServiceImpl implements PrdSystemRoleService {
    private final PrdSystemRoleDAO dao;
    private final PrdSystemPermissionFunctionObjectRepo functionObjectRepo;
    private final PrdSystemPermissionFunctionObjectService functionObjectService;
    private final PrdSystemPermissionFieldObjRoleFunctionRepo fieldObjRoleFunctionRepo;
    private final PrdSystemPermissionFieldObjRoleFunctionService fieldObjRoleFunctionService;
    private final PrdSystemBusinessObjectRepo businessObjectRepo;
    private final PrdSystemPermissionFieldService fieldService;
    private final RedisUtils redisUtils;
    private static final String FIELD_RULE_CACHE_PREFIX = "sys:permission:field:rule:";
    private static final String REPLACE_STR = "-";
    private static final String REPLACE_MENT = "";

    @Transactional
    @Override
    public PrdSystemRoleVO insert(PrdSystemRolePayload payload) {
        if (dao.queryByCodeOrName(payload.getRoleCode(), payload.getRoleName()) != null) {
            throw TwException.error("", "编号或名称不可重复");
        }
        PrdSystemRoleDO ado = PrdSystemRoleConvert.INSTANCE.toDo(payload);
        ado = dao.save(ado);
        if (payload.getMenuIds() != null && payload.getMenuIds().size() > 0) {
            List<PrdSystemRoleMenuDO> roleMenuDOS = new ArrayList<>();
            for (Long menuId : payload.getMenuIds()) {
                PrdSystemRoleMenuDO roleMenuDO = new PrdSystemRoleMenuDO();
                roleMenuDO.setMenuId(menuId);
                roleMenuDO.setRoleId(ado.getId());
                roleMenuDOS.add(roleMenuDO);
            }
            dao.saveRoleMenuAll(roleMenuDOS);
        }
        if (payload.getUserIds() != null && payload.getUserIds().size() > 0) {
            List<PrdSystemUserRoleDO> userDOS = new ArrayList<>();
            for (Long userId : payload.getUserIds()) {
                PrdSystemUserRoleDO userDO = new PrdSystemUserRoleDO();
                userDO.setUserId(userId);
                userDO.setRoleId(ado.getId());
                userDOS.add(userDO);
            }
            dao.saveUserRoleAll(userDOS);
        }
        //维护角色与角色组关系
        if (payload.getRoleGroupId() != null) {
            PrdSystemRoleGroupRoleDO roleGroupRoleDO = new PrdSystemRoleGroupRoleDO();
            roleGroupRoleDO.setRoleId(ado.getId());
            roleGroupRoleDO.setRoleGroupId(payload.getRoleGroupId());
            dao.saveRoleGroupRole(roleGroupRoleDO);
        }
        return PrdSystemRoleConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    @Override
    public Long update(PrdSystemRolePayload payload) {
        PrdSystemRoleVO roleVO = dao.queryByCodeOrName(payload.getRoleCode(), payload.getRoleName());
        if (roleVO != null && roleVO.getId().longValue() != payload.getId().longValue()) {
            throw TwException.error("", "编号不可重复");
        }
        dao.updateByKeyDynamic(payload);
        if (payload.getMenuIds() != null) {
            if (payload.getMenuIds().size() > 0) {
                List<PrdSystemRoleMenuDO> roleMenuDOS = new ArrayList<>();
                for (Long menuId : payload.getMenuIds()) {
                    PrdSystemRoleMenuDO roleMenuDO = new PrdSystemRoleMenuDO();
                    roleMenuDO.setMenuId(menuId);
                    roleMenuDO.setRoleId(payload.getId());
                    roleMenuDOS.add(roleMenuDO);
                }
                dao.deleteRoleMenusByRoleId(payload.getId());
                dao.saveRoleMenuAll(roleMenuDOS);
            } else {
                dao.deleteRoleMenusByRoleId(payload.getId());
            }

        }
        if (payload.getUserIds() != null) {
            if (payload.getUserIds().size() > 0) {
                List<PrdSystemUserRoleDO> userDOS = new ArrayList<>();
                for (Long userId : payload.getUserIds()) {
                    PrdSystemUserRoleDO userDO = new PrdSystemUserRoleDO();
                    userDO.setUserId(userId);
                    userDO.setRoleId(payload.getId());
                    userDOS.add(userDO);
                }
                dao.deleteRolesByUserId(payload.getId());
                dao.saveUserRoleAll(userDOS);
            } else {
                dao.deleteRolesByUserId(payload.getId());
            }
        }
        if (payload.getFunctionIds() != null) {
            if (payload.getFunctionIds().size() > 0) {
                List<PrdSystemRoleFunctionDO> functionDOS = new ArrayList<>();
                for (Long functionId : payload.getFunctionIds()) {
                    PrdSystemRoleFunctionDO functionDO = new PrdSystemRoleFunctionDO();
                    functionDO.setFunctionId(functionId);
                    functionDO.setRoleId(payload.getId());
                    functionDOS.add(functionDO);
                }
                //配置功能权限时，初始化字段
                initialField(payload);

                dao.deleteRoleFunctionsByRoleId(payload.getId());
                dao.saveRoleFunctionAll(functionDOS);
            } else {
                dao.deleteRoleFunctionsByRoleId(payload.getId());
            }
        }
        //如果角色组有则需要更改角色与角色组关系
        if (!ObjectUtils.isEmpty(payload.getRoleGroupId())) {
            PrdSystemRoleGroupRoleVO roleGroupRoleVO = dao.queryRoleGroupRoleByRoleId(payload.getId());
            Assert.notNull(roleGroupRoleVO.getId(), "不存在的角色组关系");
            PrdSystemRoleGroupRoleDO roleGroupRoleDO = PrdSystemRoleGroupRoleConvert.INSTANCE.toDo(roleGroupRoleVO);
            roleGroupRoleDO.setRoleGroupId(payload.getRoleGroupId());
            dao.saveRoleGroupRole(roleGroupRoleDO);
        }
        return 0L;
    }

    @Transactional
    @Override
    public Long updateStatus(Long id, Boolean enabled) {
        if (!ObjectUtils.isEmpty(id) && !ObjectUtils.isEmpty(enabled)) {
            dao.updateStatus(id, enabled);
            return 0L;
        } else {
            throw TwException.error("", "参数错误");
        }
    }


    @Transactional
    @Override
    public boolean deleteSoft(List<Long> keys) {
        dao.deleteSoft(keys);
        return true;
    }

    @Override
    public PrdSystemRoleVO queryByKey(Long key) {
        PrdSystemRoleVO roleVO = dao.queryByKey(key);
        roleVO.setMenuIds(dao.queryRoleMenuIds(key));
        roleVO.setUserDatas(dao.queryUsers(key));
        roleVO.setRoleGroupId(dao.queryRoleGroupId(key));
        return roleVO;
    }

    @Override
    public PagingVO<PrdSystemRoleVO> paging(PrdSystemRoleQuery query) {
        return dao.queryPaging(query);
    }

    @Override
    public List<PrdSystemRoleVO> queryList() {
        return dao.queryList();
    }

    @Override
    public List<Long> queryUserIdByRoleCode(String roleNo) {
        return dao.queryUserIdByRoleCode(roleNo);
    }

    /**
     * 角色下的用户列表模糊分页
     *
     * @param query
     * @return
     */
    @Override
    public PagingVO<PrdOrgEmployeeVO> pagingUserList(PrdSystemRoleFunctionQuery query) {
        //校验查询数据
        checkPagingUserList(query);
        return dao.queryPagingUserList(query);
    }

    /**
     * 角色下 展示的用户列表需要提供一个关系移除
     *
     * @param roleId
     * @param userId
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteUserList(Long roleId, Long userId) {
        dao.deleteRoleByUserId(roleId, userId);
    }

    /**
     * 角色下 功能列表 模糊分页
     *
     * @param query
     * @return
     */
    @Override
    public PagingVO<PrdSystemRoleFunctionVO> pagingFunctionList(PrdSystemRoleFunctionQuery query) {
        //校验角色功能列表参数
        checkPagingFunctionList(query);
        //拿到需要的菜单
        PagingVO<PrdSystemRoleFunctionVO> pagingVO = dao.queryByBusinessObject(query);
        List<PrdSystemRoleFunctionVO> records = pagingVO.getRecords();
        //拿到需要的业务对象了 填充对象
        for (PrdSystemRoleFunctionVO next : records) {
            List<PrdSystemNewFunctionVO> app = dao.queryByNewFunction(next.getId(), "APP");
            app.forEach(prdSystemNewFunctionVO -> {
                prdSystemNewFunctionVO.setChecked(dao.queryByRoleFunction(query, prdSystemNewFunctionVO));
            });
            next.setApp(app);
            List<PrdSystemNewFunctionVO> pc = dao.queryByNewFunction(next.getId(), "PC");
            pc.forEach(prdSystemNewFunctionVO -> {
                prdSystemNewFunctionVO.setChecked(dao.queryByRoleFunction(query, prdSystemNewFunctionVO));
            });
            next.setPc(pc);
        }
        pagingVO.setRecords(records);
        return pagingVO;
    }

    /**
     * 角色下 字段列表 模糊分页
     *
     * @param query
     * @return
     */
    @Override
    public PagingVO<PrdSystemPermissionFieldObjRoleFunctionVO> pagingField(PrdSystemPermissionFieldObjRoleFunctionQuery query) {
        //检查查询参数
        checkPagingField(query);
        //查找业务对象分页
        PagingVO<PrdSystemPermissionFieldObjRoleFunctionVO> objectPagingVO = dao.queryObjectByRoleId(query);
        //查询该角色拥有的功能
        List<PrdSystemPermissionFieldObjRoleFunctionVO> functionList = dao.queryFunctionByRoleId(query);
        //查询拥有功能对象的功能
        List<PrdSystemPermissionFieldObjRoleFunctionVO> functionObjectList = dao.queryFunctionObjectByFunctionIds(functionList.stream().map(PrdSystemPermissionFieldObjRoleFunctionVO::getFunctionId).collect(Collectors.toList()));
        //查询功能对象对应字段
        List<PrdSystemPermissionFieldObjRoleFunctionVO> functionObjectFieldList = dao.queryFunctionObjectFieldByFunctionObjectIds(functionObjectList.stream().map(PrdSystemPermissionFieldObjRoleFunctionVO::getFunctionObjectId).collect(Collectors.toList()));
        //查询角色下已经拥有的字段权限
        List<PrdSystemPermissionFieldObjRoleFunctionVO> fieldRuleList = dao.queryFieldRuleByRoleId(query);

        List<PrdSystemPermissionFieldObjRoleFunctionVO> records = objectPagingVO.getRecords();
        //组装数据
        for (PrdSystemPermissionFieldObjRoleFunctionVO record : records) {
            List<PrdSystemPermissionFieldObjRoleFunctionVO> pc = new ArrayList<>();
            List<PrdSystemPermissionFieldObjRoleFunctionVO> app = new ArrayList<>();

            //编辑功能对象列表
            for (PrdSystemPermissionFieldObjRoleFunctionVO functionObjectVO : functionObjectList) {
                //属于业务对象的功能对象（该功能对象通过功能查询出来）
                if (record.getObjectId().equals(functionObjectVO.getObjectId())) {
                    //区分PC和APP
                    if ("PC".equals(functionObjectVO.getClientType())) {
                        //构建功能对象下的字段
                        assemblyData(functionObjectFieldList, fieldRuleList, functionObjectVO);
                        pc.add(functionObjectVO);
                    } else {
                        //构建功能对象下的字段
                        assemblyData(functionObjectFieldList, fieldRuleList, functionObjectVO);
                        app.add(functionObjectVO);
                    }
                    functionObjectVO.setUuId(UUID.randomUUID().toString().trim().replaceAll(REPLACE_STR, REPLACE_MENT));
                }
            }
            record.setUuId(UUID.randomUUID().toString().trim().replaceAll(REPLACE_STR, REPLACE_MENT));
            record.setApp(app);
            record.setPc(pc);
        }

        return objectPagingVO;
    }

    /**
     * 构建数据
     *
     * @param functionObjectFieldList
     * @param fieldRuleList
     * @param functionObjectVO
     */
    private void assemblyData(List<PrdSystemPermissionFieldObjRoleFunctionVO> functionObjectFieldList, List<PrdSystemPermissionFieldObjRoleFunctionVO> fieldRuleList, PrdSystemPermissionFieldObjRoleFunctionVO functionObjectVO) {
        List<PrdSystemPermissionFieldObjRoleFunctionVO> field = new ArrayList<>();
        for (PrdSystemPermissionFieldObjRoleFunctionVO fieldVO : functionObjectFieldList) {
            //判断该字段是否属于功能对象
            if (fieldVO.getFunctionObjectId().equals(functionObjectVO.getFunctionObjectId())) {
                //判断该字段是否已经存在规则
                int size = field.size();
                for (PrdSystemPermissionFieldObjRoleFunctionVO fieldRuleVO : fieldRuleList) {
                    //判断该规则是否已经存在
                    if (fieldRuleVO.getFieldId().equals(fieldVO.getFieldId())) {
                        //存在则直接复用
                        fieldVO.setRoleObjFunctionFieldId(fieldRuleVO.getRoleObjFunctionFieldId());
                        fieldVO.setIsVisible(fieldRuleVO.getIsVisible());
                        fieldVO.setIsEdit(fieldRuleVO.getIsEdit());
                        field.add(fieldVO);
                        break;
                    }
                }
                //长度等 说明规则不存在初始化
                if (size == field.size()) {
                    //默认初始化
                    fieldVO.setIsEdit(1);
                    fieldVO.setIsVisible(0);
                    field.add(fieldVO);
                }
                fieldVO.setUuId(UUID.randomUUID().toString().trim().replaceAll(REPLACE_STR, REPLACE_MENT));
            }
        }
        functionObjectVO.setField(field);
    }

    /**
     * 角色下 字段列表 字段属性值更改
     *
     * @param payloads
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateField(List<PrdSystemPermissionFieldObjRoleFunctionPayload> payloads) {
        Set<Long> functionObjectSet = new HashSet<>();
        Set<Long> objectSet = new HashSet<>();
        List<PrdSystemPermissionFieldObjRoleFunctionDO> saveAll = new ArrayList<>();
        for (PrdSystemPermissionFieldObjRoleFunctionPayload payload : payloads) {
            PrdSystemPermissionFieldObjRoleFunctionDO entity = ObjectUtils.isEmpty(payload.getId()) ? insertEntity(payload) : updateEntity(payload);
            if (!functionObjectSet.contains(entity.getFunctionObjectId())) {
                functionObjectSet.add(entity.getFunctionObjectId());
            }
            saveAll.add(entity);
        }
        fieldObjRoleFunctionRepo.saveAll(saveAll);
        //清除缓存
        List<PrdSystemPermissionFunctionObjectDO> allById = functionObjectRepo.findAllById(functionObjectSet);
        for (PrdSystemPermissionFunctionObjectDO functionObjectDO : allById) {
            if (!objectSet.contains(functionObjectDO.getObjectId())) {
                PrdSystemBusinessObjectDO objectDO = businessObjectRepo.findById(functionObjectDO.getObjectId()).orElseGet(PrdSystemBusinessObjectDO::new);
                removeFieldRuleCache(objectDO.getObjectCode());
                objectSet.add(functionObjectDO.getObjectId());
            }
        }
    }

    /**
     * 构造插入实体类
     *
     * @param payload
     * @return
     */
    private PrdSystemPermissionFieldObjRoleFunctionDO insertEntity(PrdSystemPermissionFieldObjRoleFunctionPayload payload) {
        //检查插入实体类
        checkInsertEntity(payload);
        PrdSystemPermissionFieldObjRoleFunctionDO entityDO = PrdSystemPermissionFieldObjRoleFunctionConvert.INSTANCE.toDo(payload);
        return entityDO;
    }

    /**
     * 检查插入实体类
     *
     * @param payload
     */
    private void checkInsertEntity(PrdSystemPermissionFieldObjRoleFunctionPayload payload) {
        if (ObjectUtils.isEmpty(payload.getRoleId())) {
            throw TwException.error("", "roleId不能为空");
        }
        if (ObjectUtils.isEmpty(payload.getFieldId())) {
            throw TwException.error("", "field不能为空");
        }
        if (ObjectUtils.isEmpty(payload.getFunctionObjectId())) {
            throw TwException.error("", "functionObjectId不能为空");
        }
    }

    /**
     * 构造修改实体类
     *
     * @param payload
     * @return
     */
    private PrdSystemPermissionFieldObjRoleFunctionDO updateEntity(PrdSystemPermissionFieldObjRoleFunctionPayload payload) {
        PrdSystemPermissionFieldObjRoleFunctionDO entity = fieldObjRoleFunctionRepo.findById(payload.getId()).orElseGet(PrdSystemPermissionFieldObjRoleFunctionDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdSystemPermissionFieldObjRoleFunctionDO entityDO = PrdSystemPermissionFieldObjRoleFunctionConvert.INSTANCE.toDo(payload);
        entity.copy(entityDO);
        return entity;
    }

    /**
     * 业务/管理角色列表查询
     *
     * @param query
     * @return
     */
    @Override
    public List<PrdSystemRoleVO> differentList(PrdSystemRoleQuery query) {
        return dao.differentList(query);
    }

    /**
     * 检查属性查询参数
     *
     * @param query
     */
    private void checkPagingField(PrdSystemPermissionFieldObjRoleFunctionQuery query) {
        if (ObjectUtils.isEmpty(query.getRoleId())) {
            throw TwException.error("", "roleId不能为空");
        }
    }

    /**
     * 校验角色下功能列表的参数
     *
     * @param query
     */
    private void checkPagingFunctionList(PrdSystemRoleFunctionQuery query) {
        if (query.getRoleId() == null) {
            throw TwException.error("", "roleId不能为空");
        }
    }

    /**
     * 校验角色下的用户列表的参数
     *
     * @param query
     */
    private void checkPagingUserList(PrdSystemRoleFunctionQuery query) {
        if (query.getRoleId() == null) {
            throw TwException.error("", "roleId不能为空");
        }
    }

    /**
     * 清除字段权限缓存
     *
     * @param objectCode
     */
    private void removeFieldRuleCache(String objectCode) {
        String redisKey = FIELD_RULE_CACHE_PREFIX + objectCode;
        if (redisUtils.hasKey(redisKey)) {
            redisUtils.del(redisKey);
        }
    }

    /**
     * 如果配置了功能，但没有字段映射，需要初始化字段
     *
     * @param payload
     */
    private void initialField(PrdSystemRolePayload payload) {
        //查询含有功能对象的功能
        List<PrdSystemPermissionFunctionObjectVO> functionObjectDOS = functionObjectService.queryByFunctionId(payload.getFunctionIds());
        //获取功能对象ID
        Set<Long> functionObjectIds = functionObjectDOS.stream().map(BaseViewModel::getId).collect(Collectors.toSet());
        //根据功能ID集合查询字段
        List<PrdSystemPermissionFieldVO> fieldVOS = fieldService.queryByFunctionObjectIds(functionObjectIds);

        if (CollectionUtils.isEmpty(fieldVOS)) {
            return;
        }

        //将字段放进map中
        Map<String, List<PrdSystemPermissionFieldVO>> fieldMap = new HashMap<>();
        List<PrdSystemPermissionFieldVO> tempFieldList;
        for (PrdSystemPermissionFieldVO fieldVO : fieldVOS) {
            String functionObjectId = String.valueOf(fieldVO.getFunctionObjectId());
            if (!fieldMap.containsKey(functionObjectId)) {
                tempFieldList = new ArrayList<>();
                tempFieldList.add(fieldVO);
                fieldMap.put(functionObjectId, tempFieldList);
            } else {
                tempFieldList = fieldMap.get(functionObjectId);
                tempFieldList.add(fieldVO);
            }
        }
        //根据角色ID和功能对象ID查询 字段-功能对象-角色关联表
        List<Long> fieldList = fieldObjRoleFunctionService.queryByRoleIdAndFunctionIds(payload.getId(), functionObjectIds);
        Set<Long> fieldSet = new HashSet<>(fieldList);

        //根据 功能对象ID、角色ID 查询 字段-功能对象-角色关联表
        List<PrdSystemPermissionFieldObjRoleFunctionDO> fieldObjRoleFunctionDOList = new ArrayList<>();
        //创建字段
        for (PrdSystemPermissionFunctionObjectVO functionObjectDO : functionObjectDOS) {
            Long id = functionObjectDO.getId();
            //说明 字段-功能对象-角色关联表 中 该角色、该功能没有初始化字段，需要初始化字段，关联表插入数据
            tempFieldList = fieldMap.get(String.valueOf(id));
            if (CollectionUtils.isEmpty(tempFieldList)) {
                continue;
            }

            for (PrdSystemPermissionFieldVO fieldVO : tempFieldList) {
                //能添加到set集合，说明字段-功能对象-角色关联表没配置字段
                if (fieldSet.add(fieldVO.getId())) {
                    PrdSystemPermissionFieldObjRoleFunctionDO fieldObjRoleFunctionDO = new PrdSystemPermissionFieldObjRoleFunctionDO();
                    fieldObjRoleFunctionDO.setFieldId(fieldVO.getId());
                    fieldObjRoleFunctionDO.setRoleId(payload.getId());
                    fieldObjRoleFunctionDO.setFunctionObjectId(id);
                    fieldObjRoleFunctionDO.setIsVisible(0);
                    fieldObjRoleFunctionDO.setIsEdit(1);

                    fieldObjRoleFunctionDOList.add(fieldObjRoleFunctionDO);
                }

            }
        }
        fieldObjRoleFunctionRepo.saveAll(fieldObjRoleFunctionDOList);
    }


    @Override
    public Map<String, List<Long>> queryUserIdMapByRoleCodes(List<String> roleCodes) {
        return dao.queryUserIdMapByRoleCodes(roleCodes);
    }

    @Override
    public List<Long> queryUserIdByRoleCodes(List<String> roleCodeList) {
        return dao.queryUserIdByRoleCodes(roleCodeList);
    }

    @Override
    public void addUserMenu(List<Long> userList, String roleCode) {
        // 查询当前编号的角色
        PrdSystemRoleVO prdSystemRoleVO = dao.queryByCode(roleCode);
        List<PrdOrgEmployeeRefVO> userDatas = dao.queryUsers(prdSystemRoleVO.getId());
        List<Long> oldUsers = userDatas.stream().map(e -> e.getUserId()).collect(Collectors.toList());
        List<Long> mergedList = Stream.concat(oldUsers.stream(), userList.stream())
                .distinct()
                .collect(Collectors.toList());

        if (!CollectionUtils.isEmpty(mergedList)) {
            List<PrdSystemUserRoleDO> userDOS = new ArrayList<>();
            for (Long userId : mergedList) {
                PrdSystemUserRoleDO userDO = new PrdSystemUserRoleDO();
                userDO.setUserId(userId);
                userDO.setRoleId(prdSystemRoleVO.getId());
                userDOS.add(userDO);
            }
            dao.deleteRolesByUserId(prdSystemRoleVO.getId());
            dao.saveUserRoleAll(userDOS);
        } else {
            dao.deleteRolesByUserId(prdSystemRoleVO.getId());
        }
    }
}
