package com.elitesland.tw.tw5.server.prd.system.service;


import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSitePayload;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSiteRefPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSiteQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSiteRefService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSiteService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSiteVO;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemSiteConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemSiteDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemSitePurDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemSiteDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemSiteRepo;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 公共地点表
 *
 * @author zoey
 * @date 2024-04-22
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemSiteServiceImpl extends BaseServiceImpl implements PrdSystemSiteService {

    private final PrdSystemSiteRepo prdSystemSiteRepo;
    private final PrdSystemSiteDAO prdSystemSiteDAO;
    private final PrdSystemSitePurDAO prdSystemSitePurDAO;
    private final PrdSystemSiteRefService prdSystemSiteRefService;

    @Override
    public PagingVO<PrdSystemSiteVO> queryPaging(PrdSystemSiteQuery query){
        return prdSystemSiteDAO.queryPaging(query);
    }

    @Override
    public PagingVO<PrdSystemSiteVO> queryPurPaging(PrdSystemSiteQuery query){
        return prdSystemSitePurDAO.queryPaging(query);
    }

    @Override
    public List<PrdSystemSiteVO> queryListDynamic(PrdSystemSiteQuery query){
        return prdSystemSiteDAO.queryListDynamic(query);
    }

    @Override
    public PrdSystemSiteVO queryByKey(Long key) {
        PrdSystemSiteDO entity = prdSystemSiteRepo.findById(key).orElseGet(PrdSystemSiteDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdSystemSiteVO vo = PrdSystemSiteConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdSystemSiteVO insert(PrdSystemSitePayload payload) {
        PrdSystemSiteVO prdSystemSiteVO = new PrdSystemSiteVO();
        Long siteId = payload.getSiteId();
        if(payload.getSiteId()==null){
            PrdSystemSiteDO entityDo = PrdSystemSiteConvert.INSTANCE.toDo(payload);
            prdSystemSiteVO = PrdSystemSiteConvert.INSTANCE.toVo(prdSystemSiteRepo.save(entityDo));
            siteId = prdSystemSiteVO.getId();
        }
        // 保存关系表
        String docType = payload.getDocType();
        Long docId = payload.getDocId();
        PrdSystemSiteRefPayload prdSystemSiteRefPayload = new PrdSystemSiteRefPayload();
        prdSystemSiteRefPayload.setSiteId(siteId);
        prdSystemSiteRefPayload.setDocType(docType);
        prdSystemSiteRefPayload.setDocId(docId);//项目id，打卡配置id
        prdSystemSiteRefService.insert(prdSystemSiteRefPayload);
        return prdSystemSiteVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdSystemSiteVO update(PrdSystemSitePayload payload) {
        PrdSystemSiteVO prdSystemSiteVO = new PrdSystemSiteVO();
        Long siteId = payload.getSiteId();
        if(payload.getSiteId()==null){
            PrdSystemSiteDO entityDo = PrdSystemSiteConvert.INSTANCE.toDo(payload);
            prdSystemSiteVO = PrdSystemSiteConvert.INSTANCE.toVo(prdSystemSiteRepo.save(entityDo));
            siteId = prdSystemSiteVO.getId();
        }
        // 保存关系表
        String docType = payload.getDocType();
        Long docId = payload.getDocId();
        PrdSystemSiteRefPayload prdSystemSiteRefPayload = new PrdSystemSiteRefPayload();
        prdSystemSiteRefPayload.setSiteId(siteId);
        prdSystemSiteRefPayload.setDocType(docType);
        prdSystemSiteRefPayload.setDocId(docId);//项目id，打卡配置id
        prdSystemSiteRefPayload.setId(payload.getRefId());
        prdSystemSiteRefService.updateByKeyDynamic(prdSystemSiteRefPayload);
        return prdSystemSiteVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PrdSystemSitePayload payload) {
        PrdSystemSiteDO entity = prdSystemSiteRepo.findById(payload.getId()).orElseGet(PrdSystemSiteDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = prdSystemSiteDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            prdSystemSiteDAO.deleteSoft(keys);
        }
    }

}
