/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.app.service;

import com.el.coordinator.boot.fsm.config.FileConfigProperties;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.app.payload.AppVersionPayload;
import com.elitesland.tw.tw5.api.prd.app.query.AppVersionQuery;
import com.elitesland.tw.tw5.api.prd.app.service.AppVersionService;
import com.elitesland.tw.tw5.api.prd.app.vo.AppVersionVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.app.convert.AppVersionConvert;
import com.elitesland.tw.tw5.server.prd.app.entity.AppVersionDO;
import com.elitesland.tw.tw5.server.prd.app.repo.AppVersionRepo;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AppVersionServiceImpl
implements AppVersionService {
    private static final Logger log = LoggerFactory.getLogger(AppVersionServiceImpl.class);
    private final AppVersionRepo appVersionRepo;
    private final FileUtil fileUtil;
    private static final String SUBSTRING_SUFFIX = "_common";
    private final FileConfigProperties fileConfigProperties;

    public PagingVO<AppVersionVO> paging(AppVersionQuery query) {
        FileConfigProperties.StorageRemote configProperties = this.fileConfigProperties.getRemote();
        String projectFlag = configProperties.getProjectFlag();
        String SUBSTRING = projectFlag + SUBSTRING_SUFFIX;
        Page page = this.appVersionRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(appVersionDO -> {
            String oriFilePath;
            List newFileData;
            AppVersionVO appVersionVO = AppVersionConvert.INSTANCE.toVo((AppVersionDO)appVersionDO);
            appVersionVO.setFileData(this.fileUtil.getFileDatas(appVersionVO.getFileCode()));
            Object fileData = this.fileUtil.getFileDatas(appVersionVO.getFileCode());
            if (!StringUtils.hasText((String)appVersionVO.getExt1()) && !ObjectUtils.isEmpty((Object)(newFileData = (List)fileData)) && StringUtils.hasText((String)(oriFilePath = ((FileObjRespVO)newFileData.get(0)).getFilePath()))) {
                int startIndex = oriFilePath.indexOf(SUBSTRING) + SUBSTRING.length();
                String newFilePath = "";
                if (startIndex >= 0) {
                    newFilePath = oriFilePath.substring(startIndex);
                    log.info("\u5f53\u524d\u6587\u4ef6code\u7684\u76f8\u5bf9\u8def\u5f84 is {}", (Object)appVersionVO.getFileCode());
                } else {
                    log.error("\u5f53\u524d\u6587\u4ef6code\u662f [{}] \u672a\u627e\u5230\u8be5\u622a\u53d6\u5b57\u7b26\u4e32'server5_common'", (Object)appVersionVO.getFileCode());
                }
                appVersionVO.setExt1(newFilePath);
            }
            return appVersionVO;
        }));
    }

    public List<AppVersionVO> queryList(AppVersionQuery query) {
        return AppVersionConvert.INSTANCE.toVoList(this.appVersionRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public AppVersionVO queryByKey(Long key) {
        AppVersionDO entity = this.appVersionRepo.findById(key).orElseGet(AppVersionDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AppVersionVO vo = AppVersionConvert.INSTANCE.toVo(entity);
        vo.setFileData(this.fileUtil.getFileDatas(vo.getFileCode()));
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public AppVersionVO insert(AppVersionPayload payload) {
        this.dataProcess(payload);
        AppVersionDO entityDo = AppVersionConvert.INSTANCE.toDo(payload);
        return AppVersionConvert.INSTANCE.toVo((AppVersionDO)this.appVersionRepo.save(entityDo));
    }

    private void dataProcess(AppVersionPayload payload) {
        String fileRelativePath;
        String fileCode;
        if (null == payload.getShowFlag()) {
            payload.setShowFlag(Integer.valueOf(0));
        }
        if (StringUtils.hasText((String)(fileCode = payload.getFileCode()))) {
            payload.setDownloadUrl("/com/file/v1/" + fileCode + "/download");
        }
        if (StringUtils.hasText((String)(fileRelativePath = payload.getExt1()))) {
            FileConfigProperties.StorageRemote configProperties = this.fileConfigProperties.getRemote();
            String projectFlag = configProperties.getProjectFlag();
            String SUBSTRING = projectFlag + SUBSTRING_SUFFIX;
            int startIndex = fileRelativePath.indexOf(SUBSTRING) + SUBSTRING.length();
            String newFilePath = "";
            if (startIndex >= 0) {
                newFilePath = fileRelativePath.substring(startIndex);
                log.info("\u5f53\u524d\u6587\u4ef6code [{}]\u7684\u76f8\u5bf9\u8def\u5f84 is {}", (Object)payload.getFileCode(), (Object)newFilePath);
            } else {
                log.error("\u5f53\u524d\u6587\u4ef6code\u662f [{}] \u672a\u627e\u5230\u8be5\u622a\u53d6\u5b57\u7b26\u4e32'server5_common'", (Object)payload.getFileCode());
            }
            payload.setExt1(newFilePath);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public AppVersionVO update(AppVersionPayload payload) {
        AppVersionDO entity = this.appVersionRepo.findById(payload.getId()).orElseGet(AppVersionDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        this.dataProcess(payload);
        AppVersionDO entityDo = AppVersionConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AppVersionConvert.INSTANCE.toVo((AppVersionDO)this.appVersionRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.appVersionRepo.deleteSoft(keys);
        }
    }

    public AppVersionVO getCurrentVersion() {
        List records;
        AppVersionQuery query = new AppVersionQuery();
        query.setShowFlag(Integer.valueOf(1));
        ArrayList<OrderItem> orderItemList = new ArrayList<OrderItem>();
        OrderItem orderItem = OrderItem.desc((String)"version");
        OrderItem orderItem2 = OrderItem.desc((String)"createTime");
        orderItemList.add(orderItem);
        orderItemList.add(orderItem2);
        query.setOrders(orderItemList);
        query.setSize(Integer.valueOf(1));
        PagingVO<AppVersionVO> paging = this.paging(query);
        if (paging != null && !CollectionUtils.isEmpty((Collection)(records = paging.getRecords()))) {
            return (AppVersionVO)records.get(0);
        }
        return null;
    }

    public AppVersionServiceImpl(AppVersionRepo appVersionRepo, FileUtil fileUtil, FileConfigProperties fileConfigProperties) {
        this.appVersionRepo = appVersionRepo;
        this.fileUtil = fileUtil;
        this.fileConfigProperties = fileConfigProperties;
    }
}

