/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.inv.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvItemCatPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvItemCatQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvItemCatService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvItemCatVO;
import com.elitesland.tw.tw5.server.prd.inv.convert.InvItemCatConvert;
import com.elitesland.tw.tw5.server.prd.inv.dao.InvItemCatDAO;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvItemCatDO;
import com.elitesland.tw.tw5.server.prd.inv.repo.InvItemCatRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class InvItemCatServiceImpl
extends BaseServiceImpl
implements InvItemCatService {
    private static final Logger log = LoggerFactory.getLogger(InvItemCatServiceImpl.class);
    private final InvItemCatRepo invItemCatRepo;
    private final InvItemCatDAO invItemCatDAO;

    public PagingVO<InvItemCatVO> queryPaging(InvItemCatQuery query) {
        return this.invItemCatDAO.queryPaging(query);
    }

    public List<InvItemCatVO> queryListDynamic(InvItemCatQuery query) {
        return this.invItemCatDAO.queryListDynamic(query);
    }

    public InvItemCatVO queryByKey(Long key) {
        InvItemCatDO entity = this.invItemCatRepo.findById(key).orElseGet(InvItemCatDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        InvItemCatVO vo = InvItemCatConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public InvItemCatVO insert(InvItemCatPayload payload) {
        InvItemCatDO entityDo = InvItemCatConvert.INSTANCE.toDo(payload);
        return InvItemCatConvert.INSTANCE.toVo((InvItemCatDO)this.invItemCatRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public InvItemCatVO update(InvItemCatPayload payload) {
        InvItemCatDO entity = this.invItemCatRepo.findById(payload.getId()).orElseGet(InvItemCatDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        InvItemCatDO entityDo = InvItemCatConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return InvItemCatConvert.INSTANCE.toVo((InvItemCatDO)this.invItemCatRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(InvItemCatPayload payload) {
        InvItemCatDO entity = this.invItemCatRepo.findById(payload.getId()).orElseGet(InvItemCatDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.invItemCatDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.invItemCatDAO.deleteSoft(keys);
        }
    }

    public InvItemCatServiceImpl(InvItemCatRepo invItemCatRepo, InvItemCatDAO invItemCatDAO) {
        this.invItemCatRepo = invItemCatRepo;
        this.invItemCatDAO = invItemCatDAO;
    }
}

