/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceRecordPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceRecordQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceRecordVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QTAttendanceRecordDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TAttendanceRecordDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TAttendanceRecordRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class TAttendanceRecordDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final TAttendanceRecordRepo repo;
    private final QTAttendanceRecordDO qdo = QTAttendanceRecordDO.tAttendanceRecordDO;

    private JPAQuery<TAttendanceRecordVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(TAttendanceRecordVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.attendanceResId, this.qdo.attendanceDate, this.qdo.attendanceRuleId, this.qdo.attendanceTimeStart, this.qdo.attendanceTimeEnd, this.qdo.attendanceResult, this.qdo.attendanceResultDetail, this.qdo.specialReason, this.qdo.attendanceDevice})).from((EntityPath)this.qdo);
    }

    private JPAQuery<TAttendanceRecordVO> getJpaQueryWhere(TAttendanceRecordQuery query) {
        JPAQuery<TAttendanceRecordVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(TAttendanceRecordQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(TAttendanceRecordQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAttendanceResId())) {
            list.add(this.qdo.attendanceResId.eq((Object)query.getAttendanceResId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAttendanceDate())) {
            list.add(this.qdo.attendanceDate.eq((Object)query.getAttendanceDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAttendanceRuleId())) {
            list.add(this.qdo.attendanceRuleId.eq((Object)query.getAttendanceRuleId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAttendanceTimeStart())) {
            list.add(this.qdo.attendanceTimeStart.eq((Object)query.getAttendanceTimeStart()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAttendanceTimeEnd())) {
            list.add(this.qdo.attendanceTimeEnd.eq((Object)query.getAttendanceTimeEnd()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAttendanceResult())) {
            list.add(this.qdo.attendanceResult.eq((Object)query.getAttendanceResult()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAttendanceResultDetail())) {
            list.add(this.qdo.attendanceResultDetail.eq((Object)query.getAttendanceResultDetail()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSpecialReason())) {
            list.add(this.qdo.specialReason.eq((Object)query.getSpecialReason()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAttendanceDevice())) {
            list.add(this.qdo.attendanceDevice.eq((Object)query.getAttendanceDevice()));
        }
        return ExpressionUtils.allOf(list);
    }

    public TAttendanceRecordVO queryByKey(Long id) {
        JPAQuery<TAttendanceRecordVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (TAttendanceRecordVO)jpaQuery.fetchFirst();
    }

    public List<TAttendanceRecordVO> queryListDynamic(TAttendanceRecordQuery query) {
        JPAQuery<TAttendanceRecordVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<TAttendanceRecordVO> queryPaging(TAttendanceRecordQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<TAttendanceRecordVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public TAttendanceRecordDO save(TAttendanceRecordDO ado) {
        return (TAttendanceRecordDO)((Object)this.repo.save((Object)ado));
    }

    public List<TAttendanceRecordDO> saveAll(List<TAttendanceRecordDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(TAttendanceRecordPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getAttendanceResId() != null) {
            update.set(this.qdo.attendanceResId, (Object)payload.getAttendanceResId());
        }
        if (payload.getAttendanceDate() != null) {
            update.set(this.qdo.attendanceDate, (Object)payload.getAttendanceDate());
        }
        if (payload.getAttendanceRuleId() != null) {
            update.set(this.qdo.attendanceRuleId, (Object)payload.getAttendanceRuleId());
        }
        if (payload.getAttendanceTimeStart() != null) {
            update.set((Path)this.qdo.attendanceTimeStart, (Object)payload.getAttendanceTimeStart());
        }
        if (payload.getAttendanceTimeEnd() != null) {
            update.set((Path)this.qdo.attendanceTimeEnd, (Object)payload.getAttendanceTimeEnd());
        }
        if (payload.getAttendanceResult() != null) {
            update.set((Path)this.qdo.attendanceResult, (Object)payload.getAttendanceResult());
        }
        if (payload.getAttendanceResultDetail() != null) {
            update.set((Path)this.qdo.attendanceResultDetail, (Object)payload.getAttendanceResultDetail());
        }
        if (payload.getSpecialReason() != null) {
            update.set((Path)this.qdo.specialReason, (Object)payload.getSpecialReason());
        }
        if (payload.getAttendanceDevice() != null) {
            update.set((Path)this.qdo.attendanceDevice, (Object)payload.getAttendanceDevice());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("attendanceResId")) {
                update.setNull(this.qdo.attendanceResId);
            }
            if (nullFields.contains("attendanceDate")) {
                update.setNull(this.qdo.attendanceDate);
            }
            if (nullFields.contains("attendanceRuleId")) {
                update.setNull(this.qdo.attendanceRuleId);
            }
            if (nullFields.contains("attendanceTimeStart")) {
                update.setNull((Path)this.qdo.attendanceTimeStart);
            }
            if (nullFields.contains("attendanceTimeEnd")) {
                update.setNull((Path)this.qdo.attendanceTimeEnd);
            }
            if (nullFields.contains("attendanceResult")) {
                update.setNull((Path)this.qdo.attendanceResult);
            }
            if (nullFields.contains("attendanceResultDetail")) {
                update.setNull((Path)this.qdo.attendanceResultDetail);
            }
            if (nullFields.contains("specialReason")) {
                update.setNull((Path)this.qdo.specialReason);
            }
            if (nullFields.contains("attendanceDevice")) {
                update.setNull((Path)this.qdo.attendanceDevice);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public List<Long> findResAttendanceLog(Long resId, LocalDate attendanceDate) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qdo.id).from((EntityPath)this.qdo)).where((Predicate)this.qdo.attendanceResId.eq((Object)resId).and((Predicate)this.qdo.attendanceDate.eq((Object)attendanceDate)))).fetch();
    }

    public String findStartTime(Long id) {
        return (String)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.attendanceTimeStart).from((EntityPath)this.qdo)).where((Predicate)this.qdo.id.eq((Object)id))).fetchOne();
    }

    public String findResAttendanceStatus(Long id) {
        return (String)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.attendanceResultDetail).from((EntityPath)this.qdo)).where((Predicate)this.qdo.id.eq((Object)id))).fetchOne();
    }

    public String findResAttendanceResult(Long id) {
        return (String)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.attendanceResult).from((EntityPath)this.qdo)).where((Predicate)this.qdo.id.eq((Object)id))).fetchOne();
    }

    public TAttendanceRecordDAO(JPAQueryFactory jpaQueryFactory, TAttendanceRecordRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

