/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.personplan.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdAbilityLevelQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdAbilityLevelService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdAbilityLevelVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityVO;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanDtlPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanDtlQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanDtlService;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.DayJsonVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanDtlVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ProjectPersonPlanVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.personplan.constants.PersonPlanUomEnum;
import com.elitesland.tw.tw5.server.prd.personplan.convert.PersonPlanDtlConvert;
import com.elitesland.tw.tw5.server.prd.personplan.dao.PersonPlanDtlDao;
import com.elitesland.tw.tw5.server.prd.personplan.dao.PersonPlanTmpDAO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.PersonPlanDtlDO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.PersonPlanTmpDO;
import com.elitesland.tw.tw5.server.prd.personplan.repo.PersonPlanDtlRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PersonPlanDtlServiceImpl
implements PersonPlanDtlService {
    private static final Logger log = LoggerFactory.getLogger(PersonPlanDtlServiceImpl.class);
    private final PersonPlanDtlDao personPlanDtlDao;
    private final PersonPlanDtlRepo personPlanDtlRepo;
    private final ExcelUtil excelUtil;
    @Autowired
    @Lazy
    private PersonPlanService personPlanService;
    private final UdcUtil udcUtil;
    private final CacheUtil cacheUtil;
    private final VacationService vacationService;
    private final PrdAbilityLevelService prdAbilityLevelService;
    private final PrdCompositeAbilityService prdCompositeAbilityService;
    private final PrdSystemSelectionService selectionService;
    private static final BigDecimal hours = new BigDecimal(8);
    private static final BigDecimal jsonDay = BigDecimal.ONE;
    private static final int startDynamicColumn = 4;
    private final PersonPlanTmpDAO planTmpDAO;
    private final PrdOrgSyncLogDAO logDAO;
    private final PmsProjectService pmsProjectService;

    @Transactional(rollbackFor={Exception.class})
    public PersonPlanDtlVO save(PersonPlanDtlPayload personPlanDtlPayload) {
        this.checkData(personPlanDtlPayload);
        PersonPlanDtlDO personPlanDtlDO = PersonPlanDtlConvert.INSTANCE.p2d(personPlanDtlPayload);
        PersonPlanDtlDO res = (PersonPlanDtlDO)((Object)this.personPlanDtlRepo.save((Object)personPlanDtlDO));
        return PersonPlanDtlConvert.INSTANCE.d2v(res);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<PersonPlanDtlVO> saveAll(List<PersonPlanDtlPayload> personPlanDtlPayloadList, Long planId) {
        ArrayList<PersonPlanDtlDO> res = new ArrayList<PersonPlanDtlDO>();
        for (PersonPlanDtlPayload personPlanDtlPayload : personPlanDtlPayloadList) {
            this.checkData(personPlanDtlPayload);
            PersonPlanDtlDO personPlanDtlDO = PersonPlanDtlConvert.INSTANCE.p2d(personPlanDtlPayload);
            res.add(personPlanDtlDO);
        }
        this.personPlanDtlRepo.saveAll(res);
        PersonPlanDtlQuery personPlanDtlQuery = new PersonPlanDtlQuery();
        personPlanDtlQuery.setPlanId(planId);
        List<PersonPlanDtlVO> personPlanDtlList = this.getList(personPlanDtlQuery);
        if (!CollectionUtils.isEmpty(personPlanDtlList)) {
            this.checkRepeatedUser(personPlanDtlList);
            this.translateSystemSelection(personPlanDtlList);
        }
        return personPlanDtlList;
    }

    @Transactional
    public void delByNotInIdList(List<Long> idNotInList) {
        this.personPlanDtlDao.delByNotInIdList(idNotInList);
    }

    private void checkRepeatedUser(List<PersonPlanDtlVO> personPlanDtlList) {
        HashSet set = new HashSet();
        HashSet repeatedUser = new HashSet();
        personPlanDtlList.forEach(x -> {
            if (x.getResId() != null) {
                if (set.contains(x.getResId())) {
                    String userName = this.cacheUtil.getUserName(x.getResId());
                    repeatedUser.add(userName);
                } else {
                    set.add(x.getResId());
                }
            }
        });
        if (!CollectionUtils.isEmpty(repeatedUser)) {
            StringBuilder stringBuilder = new StringBuilder();
            repeatedUser.stream().forEach(e -> stringBuilder.append(e + ","));
            String substring = stringBuilder.substring(0, stringBuilder.length() - 1);
            throw TwException.error("", "\u4eba\u5458\u89c4\u5212\u660e\u7ec6\u4e2d" + substring + "\u5b58\u5728\u91cd\u590d\u7684\u5458\u5de5\uff0c\u8bf7\u68c0\u67e5");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public PersonPlanDtlVO updateAll(PersonPlanDtlPayload personPlanDtlPayload) {
        Assert.notNull((Object)personPlanDtlPayload.getId(), (String)"id is null", (Object[])new Object[0]);
        PersonPlanDtlVO res = this.save(personPlanDtlPayload);
        return res;
    }

    public PersonPlanDtlVO get(Long id) {
        if (null == id) {
            return null;
        }
        PersonPlanDtlVO res = this.personPlanDtlDao.get(id);
        if (res != null) {
            this.translateSystemSelection(Collections.singletonList(res));
        }
        return res;
    }

    public PagingVO<PersonPlanDtlVO> page(PersonPlanDtlQuery personPlanDtlQuery) {
        PagingVO<PersonPlanDtlVO> res = this.personPlanDtlDao.page(personPlanDtlQuery);
        if (!CollectionUtils.isEmpty((Collection)res.getRecords())) {
            this.translateSystemSelection(res.getRecords());
        }
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.personPlanDtlDao.del(ids);
        return res;
    }

    public List<PersonPlanDtlVO> getList(PersonPlanDtlQuery personPlanDtlQuery) {
        List<PersonPlanDtlVO> res = this.personPlanDtlDao.getList(personPlanDtlQuery);
        if (!CollectionUtils.isEmpty(res)) {
            this.translateSystemSelection(res);
        }
        return res;
    }

    private void translateSystemSelection(List<PersonPlanDtlVO> personPlanDtlVOS) {
        List capasetLevelIds = personPlanDtlVOS.stream().filter(e -> !ObjectUtils.isEmpty((Object)e.getCapasetLevelId())).map(p -> p.getCapasetLevelId()).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(capasetLevelIds)) {
            PrdAbilityLevelQuery abilityLevelQuery = new PrdAbilityLevelQuery();
            abilityLevelQuery.setIds(capasetLevelIds);
            List abilityLevelVOS = this.prdAbilityLevelService.getList(abilityLevelQuery);
            HashMap<Long, String> levelMap = new HashMap<Long, String>();
            HashMap<Long, Long> abilityMap = new HashMap<Long, Long>();
            for (PrdAbilityLevelVO levelVO : abilityLevelVOS) {
                levelMap.put(levelVO.getId(), levelVO.getLevelDtlName());
                abilityMap.put(levelVO.getId(), levelVO.getAbilityId());
            }
            List abilityIds = abilityLevelVOS.stream().map(e -> e.getAbilityId()).collect(Collectors.toList());
            PrdCompositeAbilityQuery prdCompositeAbilityQuery = new PrdCompositeAbilityQuery();
            prdCompositeAbilityQuery.setIds(abilityIds);
            List levelVOS = this.prdCompositeAbilityService.getList(prdCompositeAbilityQuery);
            HashMap<Long, String> compositeAbilityMap = new HashMap<Long, String>();
            for (PrdCompositeAbilityVO compositeAbilityVO : levelVOS) {
                compositeAbilityMap.put(compositeAbilityVO.getId(), compositeAbilityVO.getName());
            }
            personPlanDtlVOS.forEach(v -> {
                Long capasetLevelId = v.getCapasetLevelId();
                if (!ObjectUtils.isEmpty((Object)capasetLevelId)) {
                    String levelDesc = (String)levelMap.get(capasetLevelId);
                    Long compositeAbilityId = (Long)abilityMap.get(capasetLevelId);
                    if (compositeAbilityId != null) {
                        String compositeAbilityName = (String)compositeAbilityMap.get(compositeAbilityId);
                        v.setCapasetLevelIdDesc(compositeAbilityName + "-" + levelDesc);
                    }
                }
            });
        }
    }

    private void checkData(PersonPlanDtlPayload personPlanDtlPayload) {
    }

    @Transactional(rollbackFor={Exception.class})
    public Long update(PersonPlanDtlPayload personPlanDtlPayload) {
        Assert.notNull((Object)personPlanDtlPayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.personPlanDtlDao.update(personPlanDtlPayload);
        return res;
    }

    @Transactional
    public void deleteByPlanIds(List<Long> planIds) {
        this.personPlanDtlDao.deleteByPlanIds(planIds);
    }

    public void tmpDownload(HttpServletResponse response, Long planId) {
        Workbook workbook = this.getVol(planId);
        String fileName = "\u5546\u673a\u8d44\u6e90\u89c4\u5212\u6a21\u677f-" + LocalDate.now();
        ExcelUtil.writeResponse(response, fileName, workbook);
    }

    @Transactional
    public String batchImport(MultipartFile file, Long planId) {
        ArrayList<String> resNameList;
        List<String> repeatedName;
        if (file == null) {
            throw TwException.error("", "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Sheet sheet = workbook.getSheet("\u5bfc\u5165\u6a21\u677f");
        if (sheet == null) {
            throw TwException.error("", "\u5bfc\u5165\u6a21\u677fsheet\u9875\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f");
        }
        int dataStartRow = 1;
        PersonPlanVO personPlanVO = this.personPlanService.get(planId);
        if (personPlanVO == null) {
            throw TwException.error("", "\u8d44\u6e90\u89c4\u5212\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String uom = personPlanVO.getUom();
        Integer duration = (int)personPlanVO.getDuration();
        TemporalAdjuster adjuster = null;
        String title = "";
        if (PersonPlanUomEnum.week.getCode().equals(uom)) {
            adjuster = TemporalAdjusters.next(DayOfWeek.SUNDAY);
            title = "W";
        }
        if (PersonPlanUomEnum.month.getCode().equals(uom)) {
            adjuster = TemporalAdjusters.lastDayOfMonth();
            title = "M";
        }
        if (PersonPlanUomEnum.year.getCode().equals(uom)) {
            adjuster = TemporalAdjusters.lastDayOfYear();
            title = "Y";
        }
        if (adjuster == null) {
            throw TwException.error("", "\u5468\u671f\u5355\u4f4d\u9519\u8bef");
        }
        Row firstRow = sheet.getRow(0);
        String cellFormatValue = ExcelUtil.getCellFormatValue(firstRow.getCell(4));
        if (!StringUtils.hasText((String)cellFormatValue) || !title.equals(cellFormatValue.substring(0, 1))) {
            throw TwException.error("", "\u6a21\u7248\u683c\u5f0f\u4e0e\u8d44\u6e90\u89c4\u5212\u5468\u671f\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u5bfc\u51fa\u6a21\u677f");
        }
        HashMap<Integer, String> columnMap = new HashMap<Integer, String>();
        for (int j = 4; j < 4 + duration; ++j) {
            String columnName = ExcelUtil.getCellFormatValue(firstRow.getCell(j));
            columnMap.put(j, columnName);
        }
        List workLocalDay = this.vacationService.findWorkLocalDay(personPlanVO.getStartDate(), personPlanVO.getEndDate());
        HashSet<LocalDate> set = new HashSet<LocalDate>(workLocalDay);
        List<Map<String, String>> dataRangeList = this.dataRange(personPlanVO.getStartDate(), personPlanVO.getEndDate(), adjuster);
        ArrayList<PersonPlanDtlPayload> personPlanDtlPayloadList = new ArrayList<PersonPlanDtlPayload>();
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<String> resNameSet = new HashSet<String>();
        HashMap<String, String> roleMap = new HashMap<String, String>();
        PrdSystemSelectionVO systemSelection = this.cacheUtil.getSystemSelection(FunctionSelectionEnum.PMS_RESOURCE_PLAN_ROLE.getCode());
        if (systemSelection != null) {
            ArrayList<PrdSystemSelectionVO> children = new ArrayList<PrdSystemSelectionVO>();
            this.cacheUtil.getAllChildren(systemSelection, children);
            if (children != null && children.size() > 0) {
                for (PrdSystemSelectionVO selectionView : children) {
                    roleMap.put(selectionView.getSelectionName(), selectionView.getSelectionValue());
                }
            }
        }
        List compositeAbilityVOS = this.prdCompositeAbilityService.levelList(new PrdCompositeAbilityQuery());
        HashMap compositeAbilityMap = new HashMap();
        compositeAbilityVOS.stream().forEach(item -> {
            String abilityLevelName = item.getJobType1Desc() + "-" + item.getJobType2Desc() + "-" + item.getLevelDtlName();
            item.setAbilityLevelName(abilityLevelName);
            compositeAbilityMap.put(abilityLevelName, item.getAbilityLevelId());
        });
        ArrayList<Long> idList = new ArrayList<Long>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); ++i) {
            String compositeAbilityName;
            String roleName;
            Row row = sheet.getRow(i);
            PersonPlanDtlPayload personPlanDtlPayload = new PersonPlanDtlPayload();
            personPlanDtlPayload.setPlanId(planId);
            personPlanDtlPayloadList.add(personPlanDtlPayload);
            String id = ExcelUtil.getCellFormatValue(row.getCell(0));
            if (StringUtils.hasText((String)id)) {
                personPlanDtlPayload.setId(Long.valueOf(Long.parseLong(id)));
                idList.add(Long.valueOf(id));
            }
            if (StringUtils.hasText((String)(roleName = ExcelUtil.getCellFormatValue(row.getCell(1))))) {
                if (roleMap.containsKey(roleName)) {
                    personPlanDtlPayload.setRoleCode((String)roleMap.get(roleName));
                } else {
                    stringBuilder.append("\u7b2c" + (i + 1) + "\u884c\u7684\u89d2\u8272\u540d\u79f0\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u89d2\u8272 \n");
                }
            }
            String resName = ExcelUtil.getCellFormatValue(row.getCell(2));
            BigDecimal eqvaRatio = BigDecimal.ZERO;
            if (StringUtils.hasText((String)resName)) {
                Long userId = this.cacheUtil.getUserIdByName(resName);
                if (userId != null) {
                    PrdOrgEmployeeVO employee = this.cacheUtil.getEmployee(userId);
                    eqvaRatio = employee.getEqvaRatio() == null ? BigDecimal.ZERO : employee.getEqvaRatio();
                    resNameSet.add(resName);
                    personPlanDtlPayload.setDistributeRate(eqvaRatio);
                    personPlanDtlPayload.setResId(userId);
                } else {
                    stringBuilder.append("\u7b2c" + (i + 1) + "\u884c\u7684\u8d44\u6e90\u540d\u79f0\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5458\u5de5 \n");
                }
            }
            if (StringUtils.hasText((String)(compositeAbilityName = ExcelUtil.getCellFormatValue(row.getCell(3))))) {
                if (compositeAbilityMap.containsKey(compositeAbilityName)) {
                    personPlanDtlPayload.setCapasetLevelId((Long)compositeAbilityMap.get(compositeAbilityName));
                } else {
                    stringBuilder.append("\u7b2c" + (i + 1) + "\u884c\u7684\u590d\u5408\u80fd\u529b\u540d\u79f0\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u590d\u5408\u80fd\u529b \n");
                }
            }
            if (!StringUtils.hasText((String)compositeAbilityName) && !StringUtils.hasText((String)roleName)) {
                throw TwException.error("", "\u7b2c" + (i + 1) + "\u884c\u7684\u590d\u5408\u80fd\u529b\u540d\u79f0\u548c\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            String remark = ExcelUtil.getCellFormatValue(row.getCell(4));
            personPlanDtlPayload.setRemark(remark);
            ArrayList<DayJsonVO> dayJsonVOList = new ArrayList<DayJsonVO>();
            int index = 0;
            BigDecimal days = BigDecimal.ZERO;
            for (int j = 4; j < 4 + duration; ++j) {
                Map<String, String> stringStringMap = dataRangeList.get(index);
                String day = ExcelUtil.getCellFormatValue(row.getCell(j));
                if (StringUtils.hasText((String)day)) {
                    BigDecimal bigDecimal = BigDecimal.ZERO;
                    String columnName = (String)columnMap.get(j);
                    try {
                        bigDecimal = new BigDecimal(day);
                    }
                    catch (Exception e) {
                        stringBuilder.append("\u7b2c" + (i + 1) + "\u884c\u7684" + columnName + "\u5217\u6570\u636e\u683c\u5f0f\u6709\u8bef \n");
                        continue;
                    }
                    if (bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                        this.generateDaysJson(stringStringMap, bigDecimal, dayJsonVOList, set, i, stringBuilder, columnName);
                    } else if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                        stringBuilder.append("\u7b2c" + (i + 1) + "\u884c\u7684" + columnName + "\u5217\u6570\u636e\u683c\u5f0f\u6709\u8bef,\u8bf7\u52ff\u8f93\u5165\u8d1f\u6570 \n");
                        continue;
                    }
                    days = days.add(bigDecimal);
                }
                ++index;
            }
            personPlanDtlPayload.setDays(days);
            personPlanDtlPayload.setTotalEqva(eqvaRatio.multiply(days));
            personPlanDtlPayload.setDaysJson(JSONUtil.toJsonStr(dayJsonVOList));
        }
        StringBuilder stringBuilderResName = new StringBuilder();
        if (!CollectionUtils.isEmpty(resNameSet) && !CollectionUtils.isEmpty(repeatedName = this.cacheUtil.queryRepeatedNameByUserName(resNameList = new ArrayList<String>(resNameSet)))) {
            for (int i = 0; i < repeatedName.size(); ++i) {
                if (i == repeatedName.size() - 1) {
                    stringBuilderResName.append(repeatedName.get(i) + "\u8d44\u6e90\u540d\u79f0\u5b58\u5728\u91cd\u540d,\u5982\u9700\u4fee\u6539\u8bf7\u624b\u52a8\u5728\u9875\u9762\u8c03\u6574");
                    continue;
                }
                stringBuilderResName.append(repeatedName.get(i) + "\n");
            }
        }
        if (StringUtils.hasText((CharSequence)stringBuilder)) {
            throw TwException.error("", "\u5bfc\u5165\u7ed3\u679c\u6709\u8bef:{" + stringBuilder + "}");
        }
        if (!CollectionUtil.isEmpty(personPlanDtlPayloadList)) {
            this.saveAll(personPlanDtlPayloadList, planId);
        }
        return stringBuilderResName.toString();
    }

    private Workbook getVol(Long planId) {
        ClassPathResource classPathResource = new ClassPathResource("template/oppoResourcePlanBatch.xlsx");
        PersonPlanVO personPlanVO = this.personPlanService.get(planId);
        LocalDate startDate = personPlanVO.getStartDate();
        LocalDate endDate = personPlanVO.getEndDate();
        int duration = personPlanVO.getDuration();
        String uom = personPlanVO.getUom();
        TemporalAdjuster adjuster = null;
        List compositeAbilityVOS = this.prdCompositeAbilityService.levelList(new PrdCompositeAbilityQuery());
        String title = "";
        if (PersonPlanUomEnum.week.getCode().equals(uom)) {
            adjuster = TemporalAdjusters.next(DayOfWeek.SUNDAY);
            title = "W";
        }
        if (PersonPlanUomEnum.month.getCode().equals(uom)) {
            adjuster = TemporalAdjusters.lastDayOfMonth();
            title = "M";
        }
        if (PersonPlanUomEnum.year.getCode().equals(uom)) {
            adjuster = TemporalAdjusters.lastDayOfYear();
            title = "Y";
        }
        if (adjuster == null) {
            throw TwException.error("", "\u5468\u671f\u5355\u4f4d\u9519\u8bef");
        }
        List workLocalDay = this.vacationService.findWorkLocalDay(personPlanVO.getStartDate(), personPlanVO.getEndDate());
        HashSet workLocalDaySet = new HashSet(workLocalDay);
        List<Map<String, String>> dataRangeList = this.dataRange(startDate, endDate, adjuster);
        PersonPlanDtlQuery personPlanDtlQuery = new PersonPlanDtlQuery();
        personPlanDtlQuery.setPlanId(planId);
        List list = this.personPlanDtlDao.getList(personPlanDtlQuery);
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet dataSheet = (XSSFSheet)workbook.getSheet("\u5bfc\u5165\u6a21\u677f");
            Sheet compositeAbilitySheet = workbook.getSheet("\u590d\u5408\u80fd\u529b");
            Sheet roleSheet = workbook.getSheet("\u89d2\u8272\u5217\u8868");
            HashMap abilityLeveMap = new HashMap();
            compositeAbilityVOS.stream().forEach(item -> {
                String abilityLevelName = item.getJobType1Desc() + "-" + item.getJobType2Desc() + "-" + item.getLevelDtlName();
                item.setAbilityLevelName(abilityLevelName);
                abilityLeveMap.put(item.getAbilityLevelId(), abilityLevelName);
            });
            XSSFRow firstRow = dataSheet.getRow(0);
            int index = 0;
            for (int i = 4; i < 4 + duration; ++i) {
                DateTimeFormatter outputFormatter;
                Map<String, String> stringStringMap = dataRangeList.get(index);
                List collect = stringStringMap.keySet().stream().collect(Collectors.toList());
                String start = (String)collect.get(0);
                String end = stringStringMap.get(start);
                int workDayCount = this.getWorkDayCount(workLocalDaySet, LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd")), LocalDate.parse(end, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                if (PersonPlanUomEnum.month.getCode().equals(uom)) {
                    LocalDate monthDate = LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    outputFormatter = DateTimeFormatter.ofPattern("yy-MM");
                    start = monthDate.format(outputFormatter);
                }
                if (PersonPlanUomEnum.year.getCode().equals(uom)) {
                    LocalDate yearDate = LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    outputFormatter = DateTimeFormatter.ofPattern("yyyy");
                    start = yearDate.format(outputFormatter);
                }
                String columnName = title + (index + 1) + " " + start;
                this.excelUtil.setCellValueNew((Row)firstRow, i, columnName);
                ++index;
            }
            if (!CollectionUtil.isEmpty(list)) {
                list = this.udcUtil.translateList(list);
                int nextRow = 1;
                for (PersonPlanDtlVO personPlanDtlVO : list) {
                    XSSFRow row = dataSheet.createRow(nextRow);
                    this.excelUtil.setCellValueNew((Row)row, 0, personPlanDtlVO.getId());
                    this.excelUtil.setCellValueNew((Row)row, 1, personPlanDtlVO.getRoleName());
                    this.excelUtil.setCellValueNew((Row)row, 2, personPlanDtlVO.getResName());
                    this.excelUtil.setCellValueNew((Row)row, 3, abilityLeveMap.get(personPlanDtlVO.getCapasetLevelId()));
                    this.excelUtil.setCellValueNew((Row)row, 4, personPlanDtlVO.getRemark());
                    String daysJson = personPlanDtlVO.getDaysJson();
                    if (StringUtils.hasText((String)daysJson)) {
                        List dayJsonVOS = JSON.parseArray((String)daysJson, DayJsonVO.class);
                        index = 0;
                        for (int i = 4; i < 4 + duration; ++i) {
                            Map<String, String> stringStringMap = dataRangeList.get(index);
                            List collect = stringStringMap.keySet().stream().collect(Collectors.toList());
                            String start = (String)collect.get(0);
                            String end = stringStringMap.get(start);
                            LocalDate startDateOne = LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                            LocalDate endDateOne = LocalDate.parse(end, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                            BigDecimal days = BigDecimal.ZERO;
                            for (DayJsonVO dayJsonVO : dayJsonVOS) {
                                LocalDate date = LocalDate.parse(dayJsonVO.getDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                                if (!date.isEqual(startDateOne) && !date.isEqual(endDateOne) && (!date.isAfter(startDateOne) || !date.isBefore(endDateOne))) continue;
                                days = days.add(dayJsonVO.getHour().divide(hours, 2, RoundingMode.HALF_UP));
                            }
                            this.excelUtil.setCellValueNew((Row)row, i, days);
                            ++index;
                        }
                    }
                    ++nextRow;
                }
            }
            this.excelUtil.insertListData(compositeAbilitySheet, compositeAbilityVOS, "abilityLevelId", "abilityLevelName", 0);
            this.excelUtil.generateRangeList(dataSheet, 3, 1, "\u590d\u5408\u80fd\u529b", 2, "A");
            List roleVOS = this.selectionService.selectByCondition(FunctionSelectionEnum.PMS_RESOURCE_PLAN_ROLE.getCode());
            this.excelUtil.insertLOVdata(roleSheet, roleVOS, 0);
            this.excelUtil.generateRangeList(dataSheet, 1, 1, "\u89d2\u8272\u5217\u8868", 2, "A");
            return workbook;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<Map<String, String>> dataRange(LocalDate startDate, LocalDate endDate, TemporalAdjuster adjuster) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate sunDay = startDate.with(adjuster);
        if (sunDay.isAfter(endDate) || sunDay.isEqual(endDate)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(startDate.format(dateTimeFormatter), endDate.format(dateTimeFormatter));
            list.add(map);
            return list;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(startDate.format(dateTimeFormatter), sunDay.format(dateTimeFormatter));
        list.add(map);
        this.generateDateList(list, sunDay, endDate, dateTimeFormatter, adjuster);
        return list;
    }

    public void generateDateList(List<Map<String, String>> list, LocalDate sunDayDate, LocalDate endDate, DateTimeFormatter dateTimeFormatter, TemporalAdjuster adjuster) {
        HashMap<String, String> map = new HashMap<String, String>();
        LocalDate monDayDate = sunDayDate.plusDays(1L);
        LocalDate date = monDayDate.with(adjuster);
        if (endDate.isAfter(date)) {
            map.put(monDayDate.format(dateTimeFormatter), date.format(dateTimeFormatter));
            list.add(map);
            this.generateDateList(list, date, endDate, dateTimeFormatter, adjuster);
        } else {
            map.put(monDayDate.format(dateTimeFormatter), endDate.format(dateTimeFormatter));
            list.add(map);
        }
    }

    private void generateDaysJson(Map<String, String> stringStringMap, BigDecimal planDay, List<DayJsonVO> dayJsonVOList, Set<LocalDate> workDaySet, int row, StringBuilder stringBuilder, String columnName) {
        LocalDate endDate;
        List collect = stringStringMap.keySet().stream().collect(Collectors.toList());
        String start = (String)collect.get(0);
        String end = stringStringMap.get(start);
        LocalDate startDate = LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        BigDecimal days = new BigDecimal(ChronoUnit.DAYS.between(startDate, endDate = LocalDate.parse(end, DateTimeFormatter.ofPattern("yyyy-MM-dd")))).add(BigDecimal.ONE);
        if (planDay.compareTo(days) > 0) {
            stringBuilder.append("\u7b2c" + (row + 1) + "\u884c" + columnName + "\u5217\u7684\u65e5\u671f\u5929\u6570\u5927\u4e8e\u81ea\u7136\u65e5\u5929\u6570 \n");
            return;
        }
        BigDecimal workHours = planDay.multiply(hours);
        BigDecimal workDays = planDay;
        BigDecimal checkDate = BigDecimal.ONE;
        LocalDate dt = startDate;
        while (dt.isBefore(endDate) || dt.isEqual(endDate)) {
            DayJsonVO dayJsonVO = new DayJsonVO();
            dayJsonVO.setDate(dt.toString());
            if (workDays.compareTo(jsonDay) > 0) {
                dayJsonVO.setDay(jsonDay);
                workDays = workDays.subtract(jsonDay);
            } else {
                dayJsonVO.setDay(workDays);
            }
            if (workHours.compareTo(hours) > 0) {
                dayJsonVO.setHour(hours);
                workHours = workHours.subtract(hours);
            } else {
                dayJsonVO.setHour(workHours);
            }
            dayJsonVOList.add(dayJsonVO);
            if (checkDate.compareTo(planDay) >= 0) break;
            checkDate = checkDate.add(BigDecimal.ONE);
            dt = dt.plusDays(1L);
        }
    }

    private int getWorkDayCount(Set workDateSet, LocalDate startDate, LocalDate endDate) {
        return (int)workDateSet.stream().filter(date -> {
            LocalDate date1 = (LocalDate)date;
            return !(!date1.isAfter(startDate) && !date1.isEqual(startDate) || !date1.isBefore(endDate) && !date1.isEqual(endDate));
        }).count();
    }

    @Transactional
    public void insertPlanTmp() {
        String syncType = "person_plan_dtl";
        LocalDateTime localDateTime = this.logDAO.queryOrgSyncLog(syncType);
        localDateTime = localDateTime == null ? LocalDateTime.of(1970, 1, 1, 0, 0) : localDateTime.minusSeconds(180L);
        List<ProjectPersonPlanVO> projectPersonPlanVOS = this.personPlanDtlDao.queryPlanDtlList(localDateTime);
        for (ProjectPersonPlanVO projectPersonPlanVO : projectPersonPlanVOS) {
            PmsProjectVO pmsProjectVO = this.pmsProjectService.queryByContractId(projectPersonPlanVO.getProjectId());
            if (!ObjectUtils.isEmpty((Object)pmsProjectVO)) {
                projectPersonPlanVO.setProjectId(pmsProjectVO.getId());
                continue;
            }
            projectPersonPlanVO.setProjectId(null);
        }
        if (!ObjectUtils.isEmpty(projectPersonPlanVOS)) {
            for (ProjectPersonPlanVO pmsPersonPlanAndActualVO : projectPersonPlanVOS) {
                this.planTmpDAO.deleteAllByDtlId(pmsPersonPlanAndActualVO.getPlanDtlId());
                TemporalAdjuster adjuster = TemporalAdjusters.lastDayOfMonth();
                List<Map<String, String>> dataRangeList = this.dataRange(pmsPersonPlanAndActualVO.getStartDate(), pmsPersonPlanAndActualVO.getEndDate(), adjuster);
                Long resId = pmsPersonPlanAndActualVO.getResId();
                String daysJson = pmsPersonPlanAndActualVO.getDaysJson();
                List dayJsonVOS = JSON.parseArray((String)daysJson, DayJsonVO.class);
                for (Map<String, String> stringMap : dataRangeList) {
                    ProjectPersonPlanVO pmsPlanJsonVO = new ProjectPersonPlanVO();
                    pmsPlanJsonVO.setResId(resId);
                    List collect = stringMap.keySet().stream().toList();
                    String start = (String)collect.get(0);
                    String end = stringMap.get(start);
                    LocalDate startDateOne = LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    LocalDate endDateOne = LocalDate.parse(end, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    PersonPlanTmpDO projectPersonPlanDO = new PersonPlanTmpDO();
                    projectPersonPlanDO.setProjectId(pmsPersonPlanAndActualVO.getProjectId());
                    projectPersonPlanDO.setResId(pmsPersonPlanAndActualVO.getResId());
                    String userName = this.cacheUtil.getUserName(pmsPersonPlanAndActualVO.getResId());
                    projectPersonPlanDO.setResName(userName);
                    projectPersonPlanDO.setYear(startDateOne.getYear());
                    projectPersonPlanDO.setMonth(startDateOne.getMonthValue());
                    projectPersonPlanDO.setPlanDtlId(pmsPersonPlanAndActualVO.getPlanDtlId());
                    if (!CollectionUtils.isEmpty((Collection)dayJsonVOS)) {
                        BigDecimal days = BigDecimal.ZERO;
                        for (DayJsonVO dayJsonVO : dayJsonVOS) {
                            LocalDate date = LocalDate.parse(dayJsonVO.getDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                            if (!date.isEqual(startDateOne) && !date.isEqual(endDateOne) && (!date.isAfter(startDateOne) || !date.isBefore(endDateOne))) continue;
                            days = days.add(dayJsonVO.getDay()).setScale(2, RoundingMode.HALF_UP);
                        }
                        projectPersonPlanDO.setDays(days);
                    }
                    this.planTmpDAO.save(projectPersonPlanDO);
                }
            }
        }
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        this.logDAO.save(logDO);
    }

    public PersonPlanDtlServiceImpl(PersonPlanDtlDao personPlanDtlDao, PersonPlanDtlRepo personPlanDtlRepo, ExcelUtil excelUtil, UdcUtil udcUtil, CacheUtil cacheUtil, VacationService vacationService, PrdAbilityLevelService prdAbilityLevelService, PrdCompositeAbilityService prdCompositeAbilityService, PrdSystemSelectionService selectionService, PersonPlanTmpDAO planTmpDAO, PrdOrgSyncLogDAO logDAO, PmsProjectService pmsProjectService) {
        this.personPlanDtlDao = personPlanDtlDao;
        this.personPlanDtlRepo = personPlanDtlRepo;
        this.excelUtil = excelUtil;
        this.udcUtil = udcUtil;
        this.cacheUtil = cacheUtil;
        this.vacationService = vacationService;
        this.prdAbilityLevelService = prdAbilityLevelService;
        this.prdCompositeAbilityService = prdCompositeAbilityService;
        this.selectionService = selectionService;
        this.planTmpDAO = planTmpDAO;
        this.logDAO = logDAO;
        this.pmsProjectService = pmsProjectService;
    }
}

