/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsInspectionItemConfigPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsInspectionItemConfigQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsInspectionItemConfigService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsInspectionItemConfigVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsInspectionItemConfigConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsInspectionItemConfigDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsInspectionItemConfigDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsInspectionItemConfigRepo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PmsInspectionItemConfigServiceImpl
extends BaseServiceImpl
implements PmsInspectionItemConfigService {
    private static final Logger log = LoggerFactory.getLogger(PmsInspectionItemConfigServiceImpl.class);
    private final PmsInspectionItemConfigRepo pmsInspectionItemConfigRepo;
    private final PmsInspectionItemConfigDAO pmsInspectionItemConfigDAO;

    public void batchSave(List<PmsInspectionItemConfigPayload> payloads) {
        if (!ObjectUtils.isEmpty(payloads)) {
            long count = payloads.stream().map(v -> v.getCheckItem()).distinct().count();
            if (count != (long)payloads.size()) {
                throw TwException.error("", "\u4e0d\u80fd\u6709\u91cd\u590d\u7684\u68c0\u67e5\u4e8b\u9879");
            }
            count = payloads.stream().filter(v -> ObjectUtils.isEmpty((Object)v.getSortNo())).count();
            if (count > 0L) {
                throw TwException.error("", "\u6392\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            count = payloads.stream().map(v -> v.getSortNo()).distinct().count();
            if (count != (long)payloads.size()) {
                throw TwException.error("", "\u4e0d\u80fd\u6709\u91cd\u590d\u7684\u6392\u5e8f\u53f7");
            }
            ArrayList<PmsInspectionItemConfigDO> list = new ArrayList<PmsInspectionItemConfigDO>();
            for (PmsInspectionItemConfigPayload payload : payloads) {
                PmsInspectionItemConfigDO entityDo = PmsInspectionItemConfigConvert.INSTANCE.toDo(payload);
                list.add(entityDo);
            }
            this.pmsInspectionItemConfigRepo.saveAll(list);
        }
    }

    public PagingVO<PmsInspectionItemConfigVO> queryPaging(PmsInspectionItemConfigQuery query) {
        return this.pmsInspectionItemConfigDAO.queryPaging(query);
    }

    public List<PmsInspectionItemConfigVO> queryListDynamic(PmsInspectionItemConfigQuery query) {
        return this.pmsInspectionItemConfigDAO.queryListDynamic(query);
    }

    public PmsInspectionItemConfigVO queryByKey(Long key) {
        PmsInspectionItemConfigDO entity = this.pmsInspectionItemConfigRepo.findById(key).orElseGet(PmsInspectionItemConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsInspectionItemConfigVO vo = PmsInspectionItemConfigConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsInspectionItemConfigDAO.deleteSoft(keys);
        }
    }

    public List<PmsInspectionItemConfigVO> getListByWorkTypeAndApprovalNode(String workType, String approvalNode) {
        PmsInspectionItemConfigQuery query = new PmsInspectionItemConfigQuery();
        query.setWorkTypeCodes(workType);
        query.setApprovalNodes(approvalNode);
        return this.pmsInspectionItemConfigDAO.queryListDynamic(query);
    }

    public PmsInspectionItemConfigServiceImpl(PmsInspectionItemConfigRepo pmsInspectionItemConfigRepo, PmsInspectionItemConfigDAO pmsInspectionItemConfigDAO) {
        this.pmsInspectionItemConfigRepo = pmsInspectionItemConfigRepo;
        this.pmsInspectionItemConfigDAO = pmsInspectionItemConfigDAO;
    }
}

