/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.prj.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.prj.payload.PrjProjectMemberPayload;
import com.elitesland.tw.tw5.api.prd.prj.payload.PrjProjectPayload;
import com.elitesland.tw.tw5.api.prd.prj.query.PrjProjectQuery;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectMemberDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectMemberDO;
import com.elitesland.tw.tw5.server.prd.prj.repo.PrjProjectMemberRepo;
import com.elitesland.tw.tw5.server.prd.prj.repo.PrjProjectRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PrjProjectDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrjProjectRepo repo;
    private final PrjProjectMemberRepo repoMember;
    private final QPrjProjectDO qdo = QPrjProjectDO.prjProjectDO;
    private final QPrjProjectMemberDO qdoMember = QPrjProjectMemberDO.prjProjectMemberDO;

    public PrjProjectDO save(PrjProjectDO ado) {
        return (PrjProjectDO)((Object)this.repo.save((Object)ado));
    }

    public PrjProjectMemberDO saveMember(PrjProjectMemberDO ado) {
        return (PrjProjectMemberDO)((Object)this.repoMember.save((Object)ado));
    }

    public List<PrjProjectMemberDO> saveMemberAll(List<PrjProjectMemberDO> ados) {
        return this.repoMember.saveAll(ados);
    }

    public List<PrjProjectDO> saveAll(List<PrjProjectDO> dos) {
        return this.repo.saveAll(dos);
    }

    public PrjProjectVO queryByKey(Long id) {
        JPAQuery<PrjProjectVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        return (PrjProjectVO)jpaQuery.fetchFirst();
    }

    public PrjProjectVO queryByNo(String projectNo) {
        JPAQuery<PrjProjectVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectNo.eq((Object)projectNo));
        return (PrjProjectVO)jpaQuery.fetchFirst();
    }

    private JPAQuery<PrjProjectVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrjProjectVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.projectName, this.qdo.projectNo, this.qdo.projectType})).from((EntityPath)this.qdo);
        return jpaQuery;
    }

    private JPAQuery<PrjProjectVO> getJpaQueryWhere(PrjProjectQuery query) {
        JPAQuery<PrjProjectVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getProjectName())) {
            jpaQuery.where((Predicate)this.qdo.projectName.eq((Object)query.getProjectName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectNo())) {
            jpaQuery.where((Predicate)this.qdo.projectNo.eq((Object)query.getProjectNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectType())) {
            jpaQuery.where((Predicate)this.qdo.projectType.like(SqlUtil.toSqlLikeString(query.getProjectType())));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public List<PrjProjectVO> queryListDynamic(PrjProjectQuery query) {
        OrderItem orderItem = OrderItem.asc((String)"createTime");
        query.setOrders(Arrays.asList(orderItem));
        JPAQuery<PrjProjectVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PrjProjectVO> queryPaging(PrjProjectQuery query) {
        JPAQuery<PrjProjectVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        System.out.println(result.getTotal());
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public long updateByKeyDynamic(PrjProjectPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getProjectName() != null) {
            update.set((Path)this.qdo.projectName, (Object)payload.getProjectName());
        }
        if (payload.getProjectNo() != null) {
            update.set((Path)this.qdo.projectNo, (Object)payload.getProjectNo());
        }
        if (payload.getProjectType() != null) {
            update.set((Path)this.qdo.projectType, (Object)payload.getProjectType());
        }
        if ((nullFields = payload.getNullFields()) == null || nullFields.size() > 0) {
            // empty if block
        }
        return update.execute();
    }

    public long updateMemberByKeyDynamic(PrjProjectMemberPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoMember).where(new Predicate[]{this.qdoMember.id.eq((Object)payload.getId())});
        if (payload.getProjectId() != null) {
            update.set(this.qdoMember.projectId, (Object)payload.getProjectId());
        }
        if (payload.getUserId() != null) {
            update.set(this.qdoMember.userId, (Object)payload.getUserId());
        }
        if ((nullFields = payload.getNullFields()) == null || nullFields.size() > 0) {
            // empty if block
        }
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public long updateProjectManger(Long key, Long userId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.manageUserId, (Object)userId).where(new Predicate[]{this.qdo.id.eq((Object)key)});
        return update.execute();
    }

    public long deleteMemberSoft(List<Long> keys, List<Long> userIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoMember).set(this.qdoMember.deleteFlag, (Object)1).where(new Predicate[]{this.qdoMember.id.in(keys)}).where(new Predicate[]{this.qdoMember.userId.notIn(userIds)});
        return update.execute();
    }

    public List<Long> getUserIds(List<Long> keys) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qdoMember.userId).from((EntityPath)this.qdoMember)).where((Predicate)this.qdoMember.id.in(keys))).where((Predicate)this.qdoMember.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public long deleteMemberByUserId(Long key, List<Long> userIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoMember).set(this.qdoMember.deleteFlag, (Object)1).where(new Predicate[]{this.qdoMember.projectId.eq((Object)key)}).where(new Predicate[]{this.qdoMember.userId.in(userIds)});
        return update.execute();
    }

    public PrjProjectDAO(JPAQueryFactory jpaQueryFactory, PrjProjectRepo repo, PrjProjectMemberRepo repoMember) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
        this.repoMember = repoMember;
    }
}

