/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.product.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.product.payload.PrdProductPayload;
import com.elitesland.tw.tw5.api.prd.product.query.PrdProductQuery;
import com.elitesland.tw.tw5.api.prd.product.service.PrdProductService;
import com.elitesland.tw.tw5.api.prd.product.vo.PrdProductVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.product.convert.PrdProductConvert;
import com.elitesland.tw.tw5.server.prd.product.dao.PrdProductDAO;
import com.elitesland.tw.tw5.server.prd.product.entity.PrdProductDO;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductRepo;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class PrdProductServiceImpl
extends BaseServiceImpl
implements PrdProductService {
    private static final Logger log = LoggerFactory.getLogger(PrdProductServiceImpl.class);
    private final PrdProductRepo productRepo;
    private final PrdProductDAO productDAO;
    private final FileUtil fileUtil;

    public PagingVO<PrdProductVO> queryPaging(PrdProductQuery query) {
        return this.productDAO.queryPaging(query);
    }

    public List<PrdProductVO> queryListDynamic(PrdProductQuery query) {
        return this.productDAO.queryListDynamic(query);
    }

    public PrdProductVO queryByKey(Long key) {
        PrdProductDO entity = this.productRepo.findById(key).orElseGet(PrdProductDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdProductVO vo = PrdProductConvert.INSTANCE.toVo(entity);
        this.setFileData(vo);
        return vo;
    }

    public List<PrdProductVO> queryByKeys(List<Long> keys) {
        List PrdProductDOList = this.productRepo.findAllById(keys);
        if (CollectionUtils.isEmpty((Collection)PrdProductDOList)) {
            throw TwException.error("", "\u91c7\u8d2d\u660e\u7ec6\u5173\u8054\u7684\u4ea7\u54c1\u4e0d\u5b58\u5728");
        }
        return PrdProductConvert.INSTANCE.toVoList(PrdProductDOList);
    }

    private void setFileData(PrdProductVO vo) {
        if (ObjectUtils.isEmpty((Object)vo)) {
            return;
        }
        vo.setLogoFileData(this.fileUtil.getFileDatas(vo.getLogoPath()));
        vo.setVideoFileData(this.fileUtil.getFileDatas(vo.getVideoPath()));
        vo.setCopyrightFileData(this.fileUtil.getFileDatas(vo.getCopyrightFileCodes()));
        vo.setReportFileData(this.fileUtil.getFileDatas(vo.getReportFileCodes()));
        vo.setSprcFileData(this.fileUtil.getFileDatas(vo.getSprcFileCodes()));
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdProductVO insert(PrdProductPayload payload) {
        String prodNo = this.generateSeqNum("PRODUCT_NO", new String[0]);
        payload.setProdNo(prodNo);
        PrdProductDO entityDo = PrdProductConvert.INSTANCE.toDo(payload);
        return PrdProductConvert.INSTANCE.toVo((PrdProductDO)this.productRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdProductVO update(PrdProductPayload payload) {
        PrdProductDO entity = this.productRepo.findById(payload.getId()).orElseGet(PrdProductDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdProductDO entityDo = PrdProductConvert.INSTANCE.toDo(payload);
        return PrdProductConvert.INSTANCE.toVo((PrdProductDO)this.productRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.productDAO.deleteSoft(keys);
        }
    }

    public PrdProductServiceImpl(PrdProductRepo productRepo, PrdProductDAO productDAO, FileUtil fileUtil) {
        this.productRepo = productRepo;
        this.productDAO = productDAO;
        this.fileUtil = fileUtil;
    }
}

