/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PaymentSlipPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PaymentSlipQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PaymentSlipService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PaymentSlipVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PrintPaySerialNumVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PaymentSlipConvert;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4ed8\u6b3e\u5355\u8bb0\u5f55"})
@RestController
@RequestMapping(value={"/api/crm/paymentSlip"})
public class PaymentSlipController {
    private static final Logger log = LoggerFactory.getLogger(PaymentSlipController.class);
    private final PaymentSlipService paymentSlipService;
    private final UdcUtil udcUtil;

    @GetMapping(value={"/paging"})
    @UdcNameClass
    @ApiOperation(value="\u4ed8\u6b3e\u5355\u8bb0\u5f55-\u5206\u9875")
    public TwOutputUtil<PagingVO<PaymentSlipVO>> paging(PaymentSlipQuery query) {
        return TwOutputUtil.ok(this.paymentSlipService.queryPaging(query));
    }

    @GetMapping(value={"/paymentCommitPaging"})
    @UdcNameClass
    @ApiOperation(value="\u4ed8\u6b3e\u5355\u63d0\u4ea4\u8bb0\u5f55-\u5206\u9875")
    public TwOutputUtil<PagingVO<PaymentSlipVO>> paymentCommitPaging(PaymentSlipQuery query) {
        query.setStateList(Arrays.asList(PurchasePaymentEnum.PaymentSlipStatus.READY.getCode(), PurchasePaymentEnum.PaymentSlipStatus.FINANCE_REJECTED.getCode(), PurchasePaymentEnum.PaymentSlipStatus.CASHIER_TO_SUBMIT.getCode()));
        return TwOutputUtil.ok(this.paymentSlipService.queryPaging(query));
    }

    @GetMapping(value={"/paymentCommitList"})
    @UdcNameClass
    @ApiOperation(value="\u4ed8\u6b3e\u5355\u63d0\u4ea4\u8bb0\u5f55-\u5217\u8868")
    public TwOutputUtil<List<PaymentSlipVO>> paymentCommitList(PaymentSlipQuery query) {
        query.setStateList(Arrays.asList(PurchasePaymentEnum.PaymentSlipStatus.READY.getCode(), PurchasePaymentEnum.PaymentSlipStatus.FINANCE_REJECTED.getCode(), PurchasePaymentEnum.PaymentSlipStatus.CASHIER_TO_SUBMIT.getCode()));
        return TwOutputUtil.ok(this.paymentSlipService.queryListDynamic(query));
    }

    @GetMapping(value={"/paymentApprovePaging"})
    @UdcNameClass
    @ApiOperation(value="\u4ed8\u6b3e\u5355\u6279\u51c6\u8bb0\u5f55-\u5206\u9875")
    public TwOutputUtil<PagingVO<PaymentSlipVO>> paymentApprovePaging(PaymentSlipQuery query) {
        query.setStateList(Arrays.asList(PurchasePaymentEnum.PaymentSlipStatus.FINANCE_MANAGER_APPR.getCode(), PurchasePaymentEnum.PaymentSlipStatus.CASHIER_TO_FINANCE.getCode()));
        return TwOutputUtil.ok(this.paymentSlipService.queryPaging(query));
    }

    @GetMapping(value={"/paymentApproveGroupPaging"})
    @UdcNameClass
    @ApiOperation(value="\u4ed8\u6b3e\u5355\u6279\u51c6\u5206\u7ec4\u8bb0\u5f55-\u5206\u9875")
    public TwOutputUtil<PagingVO<PaymentSlipVO>> paymentApproveGroupPaging(PaymentSlipQuery query) {
        query.setStateList(Arrays.asList(PurchasePaymentEnum.PaymentSlipStatus.FINANCE_MANAGER_APPR.getCode(), PurchasePaymentEnum.PaymentSlipStatus.CASHIER_TO_FINANCE.getCode()));
        return TwOutputUtil.ok(this.paymentSlipService.paymentApproveGroupPaging(query));
    }

    @GetMapping(value={"/paymentCfoPaging"})
    @UdcNameClass
    @ApiOperation(value="\u4ed8\u6b3e\u5355CFO\u8bb0\u5f55-\u5206\u9875")
    public TwOutputUtil<PagingVO<PaymentSlipVO>> paymentCfoPaging(PaymentSlipQuery query) {
        query.setStateList(Arrays.asList(PurchasePaymentEnum.PaymentSlipStatus.CFO_APPR.getCode()));
        return TwOutputUtil.ok(this.paymentSlipService.queryPaging(query));
    }

    @GetMapping(value={"/paymentCfoApproveGroupPaging"})
    @UdcNameClass
    @ApiOperation(value="\u4ed8\u6b3e\u5355CFO\u5ba1\u6279\u5206\u7ec4\u8bb0\u5f55-\u5206\u9875")
    public TwOutputUtil<PagingVO<PaymentSlipVO>> paymentCfoApproveGroupPaging(PaymentSlipQuery query) {
        query.setStateList(Arrays.asList(PurchasePaymentEnum.PaymentSlipStatus.CFO_APPR.getCode()));
        return TwOutputUtil.ok(this.paymentSlipService.paymentApproveGroupPaging(query));
    }

    @GetMapping(value={"/paymentConfirmPaging"})
    @UdcNameClass
    @ApiOperation(value="\u4ed8\u6b3e\u5355\u786e\u8ba4\u8bb0\u5f55-\u5206\u9875")
    public TwOutputUtil<PagingVO<PaymentSlipVO>> paymentConfirmPaging(PaymentSlipQuery query) {
        query.setStateList(Arrays.asList(PurchasePaymentEnum.PaymentSlipStatus.CASHIER_APPR.getCode()));
        return TwOutputUtil.ok(this.paymentSlipService.queryPaging(query));
    }

    @GetMapping(value={"/paymentConfirmAccountPaging"})
    @UdcNameClass
    @ApiOperation(value="\u4ed8\u6b3e\u5355\u4ed8\u6b3e\u5f85\u8bb0\u8d26\u786e\u8ba4\u8bb0\u5f55-\u5206\u9875")
    public TwOutputUtil<PagingVO<PaymentSlipVO>> paymentConfirmAccountPaging(PaymentSlipQuery query) {
        query.setStateList(Arrays.asList(query.getState()));
        return TwOutputUtil.ok(this.paymentSlipService.queryPaging(query));
    }

    @PutMapping
    @UdcNameClass
    @ApiOperation(value="\u4ed8\u6b3e\u5355\u8bb0\u5f55-\u66f4\u65b0")
    public TwOutputUtil update(@RequestBody PaymentSlipPayload payload) {
        this.paymentSlipService.update(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/passOrReject"})
    @UdcNameClass
    @ApiOperation(value="\u4ed8\u6b3e\u5355\u8bb0\u5f55-\u901a\u8fc7\u9a73\u56de")
    public TwOutputUtil passOrReject(@RequestBody List<PaymentSlipPayload> payloadList) {
        this.paymentSlipService.passOrReject(payloadList);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/paymentCommit"})
    @UdcNameClass
    @ApiOperation(value="\u4ed8\u6b3e\u5355\u8bb0\u5f55-\u63d0\u4ea4")
    public TwOutputUtil paymentCommit(@RequestBody List<PaymentSlipPayload> payloadList) {
        this.paymentSlipService.paymentCommit(payloadList);
        return TwOutputUtil.ok();
    }

    @PutMapping(value={"/update"})
    @UdcNameClass
    @ApiOperation(value="\u6839\u636e\u7533\u8bf7\u5355Id\u4fee\u6539\u4ed8\u6b3e\u7533\u8bf7\u5355\u8bb0\u5f55\u72b6\u6001")
    public TwOutputUtil updateStatusByPaymentApplyId(Long paymentApplyId, String state) {
        this.paymentSlipService.updateStatusByPaymentApplyId(paymentApplyId, state);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/dealPaymentData"})
    @UdcNameClass
    @ApiOperation(value="\u5904\u7406\u662f\u5426\u9700\u8981\u5173\u95ed\u5408\u540c")
    public TwOutputUtil dealPaymentData(Long id) {
        this.paymentSlipService.dealPaymentData(Arrays.asList(id));
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/confirmOfflinePayment"})
    @UdcNameClass
    @ApiOperation(value="\u786e\u8ba4\u7ebf\u4e0b\u4ed8\u6b3e")
    public TwOutputUtil confirmOfflinePayment(@RequestBody List<PaymentSlipPayload> payloadList) {
        if (CollectionUtils.isEmpty(payloadList)) {
            throw TwException.error("", "\u8bf7\u9009\u62e9\u6570\u636e");
        }
        this.paymentSlipService.confirmOfflinePayment(payloadList);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/commitOnlinePayment"})
    @UdcNameClass
    @ApiOperation(value="\u63d0\u4ea4\u7f51\u94f6\u652f\u4ed8")
    public TwOutputUtil commitOnlinePayment(@RequestBody List<PaymentSlipPayload> payloadList) {
        if (CollectionUtils.isEmpty(payloadList)) {
            throw TwException.error("", "\u8bf7\u9009\u62e9\u6570\u636e");
        }
        this.paymentSlipService.commitOnlinePayment(payloadList);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/createPaySerialNum"})
    @UdcNameClass
    @ApiOperation(value="\u751f\u6210\u6d41\u6c34\u53f7")
    public TwOutputUtil createPaySerialNum(@RequestBody List<PaymentSlipPayload> payloadList) {
        this.paymentSlipService.createPaySerialNum(payloadList);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/queryPaySerialNum"})
    @UdcNameClass
    @ApiOperation(value="\u4ed8\u6b3e\u5355\u63d0\u4ea4\u8bb0\u5f55-\u67e5\u8be2\u6d41\u6c34\u53f7")
    public TwOutputUtil<List<String>> queryPaySerialNum() {
        return TwOutputUtil.ok(this.paymentSlipService.queryPaySerialNum());
    }

    @GetMapping(value={"/updatePayPurpose"})
    @UdcNameClass
    @ApiOperation(value="\u4fee\u6539\u7f51\u94f6\u7528\u9014")
    public TwOutputUtil<String> updatePayPurpose(Long id, String payPurpose, String paymentApplyNo) {
        this.paymentSlipService.updatePayPurpose(id, payPurpose, paymentApplyNo);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/updateReceiveAccount"})
    @UdcNameClass
    @ApiOperation(value="\u4fee\u6539\u6536\u6b3e\u8d26\u53f7")
    public TwOutputUtil<String> updateReceiveAccount(Long id, String receivingBank, String receivingAccount, String paymentApplyNo) {
        this.paymentSlipService.updateReceiveAccount(id, receivingBank, receivingAccount, paymentApplyNo);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/excelExport"})
    @ApiOperation(value="\u4ed8\u6b3e\u5355\u8bb0\u5f55-\u5bfc\u51fa")
    public void excelExport(PaymentSlipQuery query, HttpServletResponse response) throws IOException {
        List vos = query.getIds() != null && query.getIds().size() > 0 ? this.paymentSlipService.queryListByIds(query.getIds()) : this.paymentSlipService.queryListDynamic(query);
        if (!CollectionUtils.isEmpty((Collection)vos)) {
            vos = this.udcUtil.translateList(vos);
            String sheetName = "\u4ed8\u6b3e\u8bb0\u5f55\u5bfc\u51fa";
            String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), PaymentSlipVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
            ExcelUtil.excelHelper(sheet, PaymentSlipVO.class, null);
            sheet.doWrite(vos);
        }
    }

    @GetMapping(value={"/printPaySerialNum"})
    @UdcNameClass
    @ApiOperation(value="\u6253\u5370\u6d41\u6c34\u53f7")
    public void printPaySerialNum(PaymentSlipQuery query, HttpServletResponse response) throws IOException {
        List vos = query.getIds() != null && query.getIds().size() > 0 ? this.paymentSlipService.queryListByIds(query.getIds()) : this.paymentSlipService.queryListDynamic(query);
        if (!CollectionUtils.isEmpty((Collection)vos)) {
            vos = this.udcUtil.translateList(vos);
            List<PrintPaySerialNumVO> printPaySerialNumVOS = PaymentSlipConvert.INSTANCE.voListVoExcelExport(vos);
            String sheetName = "\u6253\u5370\u6d41\u6c34\u53f7\u5217\u8868";
            String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), PrintPaySerialNumVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
            ExcelUtil.excelHelper(sheet, PrintPaySerialNumVO.class, null);
            sheet.doWrite(printPaySerialNumVOS);
        }
    }

    @GetMapping(value={"/queryReceiveAccountInfo"})
    @UdcNameClass
    @ApiOperation(value="\u4ed8\u6b3e\u5355\u63d0\u4ea4\u8bb0\u5f55-\u67e5\u8be2\u6536\u6b3e\u8d26\u53f7\u4fe1\u606f")
    public TwOutputUtil<BookAccountVO> queryReceiveAccountInfo(Long id) {
        return TwOutputUtil.ok(this.paymentSlipService.queryReceiveAccountInfo(id));
    }

    public PaymentSlipController(PaymentSlipService paymentSlipService, UdcUtil udcUtil) {
        this.paymentSlipService = paymentSlipService;
        this.udcUtil = udcUtil;
    }
}

