/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.ResSetRatePayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.ResSetRateQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.ResSetRateService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.ResSetRateVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.purchase.convert.ResSetRateConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.ResSetRateDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.ResSetRateDO;
import com.elitesland.tw.tw5.server.prd.purchase.repo.ResSetRateRepo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ResSetRateServiceImpl
extends BaseServiceImpl
implements ResSetRateService {
    private static final Logger log = LoggerFactory.getLogger(ResSetRateServiceImpl.class);
    private final ResSetRateRepo resSetRateRepo;
    private final ResSetRateDAO resSetRateDAO;

    public PagingVO<ResSetRateVO> queryPaging(ResSetRateQuery query) {
        return this.resSetRateDAO.queryPaging(query);
    }

    public List<ResSetRateVO> queryListDynamic(ResSetRateQuery query) {
        return this.resSetRateDAO.queryListDynamic(query);
    }

    public ResSetRateVO queryByKey(Long key) {
        ResSetRateDO entity = this.resSetRateRepo.findById(key).orElseGet(ResSetRateDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ResSetRateVO vo = ResSetRateConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResSetRateVO insert(ResSetRatePayload payload) {
        this.checkResSetRateNew(payload);
        ResSetRateDO entityDo = ResSetRateConvert.INSTANCE.toDo(payload);
        return ResSetRateConvert.INSTANCE.toVo((ResSetRateDO)this.resSetRateRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ResSetRateVO update(ResSetRatePayload payload) {
        ResSetRateDO entity = this.resSetRateRepo.findById(payload.getId()).orElseGet(ResSetRateDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        this.checkResSetRateNew(payload);
        ResSetRateDO entityDo = ResSetRateConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ResSetRateConvert.INSTANCE.toVo((ResSetRateDO)this.resSetRateRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(ResSetRatePayload payload) {
        ResSetRateDO entity = this.resSetRateRepo.findById(payload.getId()).orElseGet(ResSetRateDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.resSetRateDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.resSetRateDAO.deleteSoft(keys);
        }
    }

    public void deleteSoftByDocumentIdList(List<Long> documentIdList) {
        this.resSetRateDAO.deleteSoftByDocumentIdList(documentIdList);
    }

    public List<ResSetRateVO> findByAgreementId(Long agreementId) {
        return this.resSetRateDAO.findByAgreementId(agreementId);
    }

    private boolean checkResSetRate(List<ResSetRatePayload> payloadList) {
        boolean checkResStartAndEnd = false;
        boolean flag = true;
        block0: for (int i = 0; i < payloadList.size() && flag; ++i) {
            for (int j = i + 1; j < payloadList.size(); ++j) {
                BigDecimal iEndAtm;
                BigDecimal iStartAtm = payloadList.get(i).getStartAtm() == null ? BigDecimal.ZERO : payloadList.get(i).getStartAtm();
                BigDecimal jEndAtm = payloadList.get(j).getEndAtm() == null ? BigDecimal.ZERO : payloadList.get(j).getEndAtm();
                BigDecimal jStartAtm = payloadList.get(j).getStartAtm() == null ? BigDecimal.ZERO : payloadList.get(j).getStartAtm();
                BigDecimal bigDecimal = iEndAtm = payloadList.get(i).getEndAtm() == null ? BigDecimal.ZERO : payloadList.get(i).getEndAtm();
                if (iStartAtm.compareTo(jEndAtm) != -1 || jStartAtm.compareTo(iEndAtm) != -1) continue;
                checkResStartAndEnd = true;
                flag = false;
                continue block0;
            }
        }
        return checkResStartAndEnd;
    }

    private void checkResSetRateNew(ResSetRatePayload resSetRatePayload) {
        BigDecimal endAtm;
        BigDecimal startAtm = resSetRatePayload.getStartAtm();
        if (startAtm.compareTo(endAtm = resSetRatePayload.getEndAtm()) >= 0) {
            throw TwException.error("", "\u5f00\u59cb\u91d1\u989d\u9700\u5c0f\u4e8e\u7ed3\u675f\u91d1\u989d");
        }
        List<ResSetRateVO> resSetRateVOS = this.findByAgreementId(resSetRatePayload.getDocumentId());
        if (!CollectionUtils.isEmpty(resSetRateVOS)) {
            ArrayList<BigDecimal[]> amtInterval = new ArrayList<BigDecimal[]>();
            amtInterval.add(new BigDecimal[]{startAtm, endAtm});
            resSetRateVOS.forEach(resSetRateVO -> {
                if (!resSetRateVO.getId().equals(resSetRatePayload.getId())) {
                    amtInterval.add(new BigDecimal[]{resSetRateVO.getStartAtm(), resSetRateVO.getEndAtm()});
                }
            });
            if (!CollectionUtils.isEmpty(amtInterval)) {
                amtInterval.sort(Comparator.comparing(a -> a[0]));
                for (int i = 0; i < amtInterval.size() - 1; ++i) {
                    BigDecimal[] interval2;
                    BigDecimal[] interval1 = (BigDecimal[])amtInterval.get(i);
                    if (interval1[0].compareTo((interval2 = (BigDecimal[])amtInterval.get(i + 1))[1]) > 0 || interval2[0].compareTo(interval1[1]) > 0) continue;
                    throw TwException.error("", "\u4eba\u529b\u8d44\u6e90\u7ed3\u7b97\u8d39\u7387\u7684\u91d1\u989d\u671f\u95f4\u4e0d\u5141\u8bb8\u6709\u4ea4\u53c9");
                }
            }
        }
    }

    public ResSetRateServiceImpl(ResSetRateRepo resSetRateRepo, ResSetRateDAO resSetRateDAO) {
        this.resSetRateRepo = resSetRateRepo;
        this.resSetRateDAO = resSetRateDAO;
    }
}

