/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractManagerVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.SaleConContractPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9500\u552e\u5408\u540c"})
@RestController
@RequestMapping(value={"/api/contract/sale"})
@PermissionDomain(domain=PermissionDomainEnum.SALE_CON_CONTRACT)
public class SaleConContractController {
    private static final Logger log = LoggerFactory.getLogger(SaleConContractController.class);
    private final SaleConContractService saleConContractService;

    @PostMapping
    @ApiOperation(value="\u65b0\u589e")
    public TwOutputUtil insert(@RequestBody SaleConContractPayload payload) {
        return TwOutputUtil.ok(this.saleConContractService.insert(payload));
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u65b0")
    public TwOutputUtil update(@RequestBody SaleConContractPayload payload) {
        return TwOutputUtil.ok(this.saleConContractService.update(payload));
    }

    @PutMapping(value={"updateByKeyDynamic"})
    @ApiOperation(value="\u66f4\u65b0")
    public TwOutputUtil updateByKeyDynamic(@RequestBody SaleConContractPayload payload) {
        return TwOutputUtil.ok(this.saleConContractService.updateByKeyDynamic(payload));
    }

    @PutMapping(value={"updateInfoByKey"})
    @ApiOperation(value="\u66f4\u65b0\u4fe1\u606f\uff08\u989d\u5b9a\u5f53\u91cf\u3001\u989d\u5b9a\u8d39\u7528\u7b49\uff0c\u65e0\u72b6\u6001\u6821\u9a8c\uff09")
    public TwOutputUtil updateInfoByKeyDynamic(@RequestBody SaleConContractPayload payload) {
        return TwOutputUtil.ok(this.saleConContractService.updateInfoByKeyDynamic(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.saleConContractService.queryByKey(key, new Boolean[]{true}));
    }

    @PostMapping(value={"/paging"})
    @UdcNameClass
    @ApiOperation(value="\u5206\u9875")
    @PermissionFunction(functions={@FunctionDetail(functionCode=FunctionCodeEnum.SALE_CON_CONTRACT_PAGE, type=FunctionTypeEnum.TAB)}, fieldPermission=true, permissionType=PermissionTypeEnum.DATA_PERMISSION)
    public TwOutputUtil<PagingVO<SaleConContractVO>> paging(@RequestBody SaleConContractQuery query) {
        log.info("\u9500\u552e\u5408\u540c\u5206\u9875api\u5c42\u5165\u53c2\u5408\u540c\u540d\u79f0 is {},\u5408\u540c\u72b6\u6001 is {}", (Object)query.getName(), (Object)query.getStatusList());
        return TwOutputUtil.ok(this.saleConContractService.paging(query));
    }

    @PostMapping(value={"/downloadSaleCon"})
    public void downloadSaleCon(HttpServletResponse response, @RequestBody SaleConContractQuery query) {
        this.saleConContractService.downloadSaleCon(response, query);
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil queryList(SaleConContractQuery query) {
        return TwOutputUtil.ok(this.saleConContractService.queryListDynamic(query));
    }

    @GetMapping(value={"/list/{parentId}"})
    @UdcNameClass
    @ApiOperation(value="\u6839\u636e\u7236ID\u67e5\u8be2\u5b50\u5408\u540c\u5217\u8868")
    public TwOutputUtil queryListByConId(@PathVariable Long parentId) {
        List voList = this.saleConContractService.queryListByConId(parentId);
        return TwOutputUtil.ok(voList);
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.saleConContractService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PatchMapping(value={"/active"})
    @ApiOperation(value="\u6fc0\u6d3b")
    public TwOutputUtil active(Long[] keys) {
        this.saleConContractService.active(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PatchMapping(value={"/pending"})
    @ApiOperation(value="\u6682\u6302")
    public TwOutputUtil pending(Long[] keys) {
        this.saleConContractService.pending(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PatchMapping(value={"/closeWithWorkFlow"})
    @ApiOperation(value="\u5173\u95ed")
    public TwOutputUtil closeWithWorkFlow(@RequestParam Long[] keys, @RequestParam(required=false) String closeCacheKey, @RequestParam(required=false) String authToken) {
        this.saleConContractService.closeWithWorkFlow(Arrays.asList(keys), closeCacheKey, authToken);
        return TwOutputUtil.ok();
    }

    @PatchMapping(value={"/close"})
    @ApiOperation(value="\u5173\u95ed")
    public TwOutputUtil close(@RequestParam Long[] keys, @RequestParam(required=false) String closeCacheKey, @RequestParam(required=false) String authToken) {
        this.saleConContractService.close(Arrays.asList(keys), closeCacheKey, authToken);
        return TwOutputUtil.ok();
    }

    @PatchMapping(value={"/invalidWithWorkFlow"})
    @ApiOperation(value="\u4f5c\u5e9f\u5e26\u6d41\u7a0b")
    public TwOutputUtil invalidWithWorkFlow(Long[] keys) {
        this.saleConContractService.invalidWithWorkFlow(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PatchMapping(value={"/invalid"})
    @ApiOperation(value="\u4f5c\u5e9f")
    public TwOutputUtil invalid(Long[] keys) {
        this.saleConContractService.invalid(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/change"})
    @ApiOperation(value="\u5b50\u5408\u540c\u53d8\u66f4")
    public TwOutputUtil change(@RequestBody SaleConContractPayload payload) {
        this.saleConContractService.change(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/updateChange"})
    @ApiOperation(value="\u5b50\u5408\u540c\u53d8\u66f4-\u66f4\u65b0")
    public TwOutputUtil updateChange(@RequestBody SaleConContractPayload payload) {
        this.saleConContractService.updateChange(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/queryChangeDetail"})
    @ApiOperation(value="\u5b50\u5408\u540c\u53d8\u66f4-\u67e5\u8be2\u8be6\u60c5")
    public TwOutputUtil queryChangeDetail(Long businessKey) {
        return TwOutputUtil.ok(this.saleConContractService.queryChangeDetail(businessKey));
    }

    @GetMapping(value={"/log/list/{key}"})
    @ApiOperation(value="\u64cd\u4f5c\u8bb0\u5f55\u65e5\u5fd7\u5217\u8868")
    public TwOutputUtil logList(@PathVariable Long key) {
        List prdSystemLogVOS = this.saleConContractService.queryLogList(key);
        return TwOutputUtil.ok(prdSystemLogVOS);
    }

    @GetMapping(value={"/subCode/{parentId}"})
    @ApiOperation(value="\u751f\u6210\u5b50\u5408\u540c\u7684\u9ed8\u8ba4\u540d\u79f0")
    public TwOutputUtil subCode(@PathVariable Long parentId) {
        String subCode = this.saleConContractService.subCode(parentId);
        return TwOutputUtil.ok(subCode);
    }

    @PatchMapping(value={"/conFiling"})
    @ApiOperation(value="\u5f52\u6863")
    public TwOutputUtil conFiling(Long[] keys) {
        this.saleConContractService.conFiling(keys);
        return TwOutputUtil.ok();
    }

    @PatchMapping(value={"/fictitiousConSubmit"})
    @ApiOperation(value="\u63d0\u4ea4\u865a\u62df\u5408\u540c")
    public TwOutputUtil fictitiousConSubmit(@RequestParam Long[] keys) {
        this.saleConContractService.fictitiousConSubmit(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/purchase/con/{saleconId}"})
    @UdcNameClass
    @ApiOperation(value="\u67e5\u8be2\u91c7\u8d2d\u5408\u540c\u5217\u8868")
    public TwOutputUtil<List<PurchaseContractManagerVO>> queryPurchConList(@PathVariable Long saleconId) {
        return TwOutputUtil.ok(this.saleConContractService.queryPurchConList(saleconId));
    }

    public SaleConContractController(SaleConContractService saleConContractService) {
        this.saleConContractService = saleConContractService;
    }
}

