/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConEpibolyCostConDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConEpibolyCostConDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConEpibolyCostConDService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConEpibolyCostConService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConEpibolyCostConDVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConEpibolyCostConVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConEpibolyCostConDConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConEpibolyCostConDDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConEpibolyCostConDDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConEpibolyCostConDRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConEpibolyCostConRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ConEpibolyCostConDServiceImpl
extends BaseServiceImpl
implements ConEpibolyCostConDService {
    private static final Logger log = LoggerFactory.getLogger(ConEpibolyCostConDServiceImpl.class);
    private final ConEpibolyCostConDRepo conEpibolyCostConDRepo;
    private final ConEpibolyCostConRepo conEpibolyCostConRepo;
    private final ConEpibolyCostConDDAO conEpibolyCostConDDAO;
    @Autowired
    private SaleConContractService saleConContractService;
    @Autowired
    private final ConEpibolyCostConService costConService;
    private final WorkflowUtil workflowUtil;
    private final PrdOrgOrganizationService orgService;
    private final TransactionUtilService transactionUtilService;
    private final CacheUtil cacheUtil;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;

    public PagingVO<ConEpibolyCostConDVO> queryPaging(ConEpibolyCostConDQuery query) {
        this.getPermissionParams(query);
        PagingVO<ConEpibolyCostConDVO> pagingVO = this.conEpibolyCostConDDAO.queryPaging(query);
        List records = pagingVO.getRecords();
        List<Long> patentIds = records.stream().map(BaseViewModel::getId).collect(Collectors.toList());
        Map<Long, List<ConEpibolyCostConDVO>> childrenMap = this.queryByParentIdIn(patentIds).stream().collect(Collectors.groupingBy(ConEpibolyCostConDVO::getParentId));
        records.forEach(conEpibolyCostConDVO -> conEpibolyCostConDVO.setChildrenList((List)childrenMap.get(conEpibolyCostConDVO.getId())));
        return pagingVO;
    }

    private List<ConEpibolyCostConDVO> queryByParentIdIn(List<Long> patentIds) {
        return this.conEpibolyCostConDDAO.queryByParentIdIn(patentIds);
    }

    private void getPermissionParams(ConEpibolyCostConDQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        List<String> userSystemRoleCodes = this.cacheUtil.getSystemRoleCodes(loginUserId);
        List<String> roles = Arrays.asList("SYS", "PLAT_FIN_PIC", "OPERATION_PRESIDENT");
        if (!CollectionUtils.isEmpty(userSystemRoleCodes) && CollectionUtils.containsAny(userSystemRoleCodes, roles)) {
            query.setAuthAll(Boolean.valueOf(true));
            return;
        }
        PrdOrgOrganizationQuery orgQuery = new PrdOrgOrganizationQuery();
        orgQuery.setManageId(loginUserId);
        orgQuery.setSize(Integer.valueOf(Integer.MAX_VALUE));
        PagingVO paging = this.orgService.paging(orgQuery);
        List records = paging.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            List orgIds = records.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            query.setInchargeSignBus(orgIds);
        } else {
            query.setInchargeSignBus(new ArrayList());
        }
    }

    public List<ConEpibolyCostConDVO> queryListDynamic(ConEpibolyCostConDQuery query) {
        List<ConEpibolyCostConDVO> conEpibolyCostConDVOS = this.conEpibolyCostConDDAO.queryListDynamic(query);
        for (ConEpibolyCostConDVO conEpibolyCostConDVO : conEpibolyCostConDVOS) {
            List<ConEpibolyCostConDVO> childrenList = this.queryByParentId(conEpibolyCostConDVO.getId());
            conEpibolyCostConDVO.setChildrenList(childrenList);
        }
        return conEpibolyCostConDVOS;
    }

    public ConEpibolyCostConDVO queryByKey(Long key) {
        ConEpibolyCostConDVO epibolyCostConDVO = this.conEpibolyCostConDDAO.queryByKey(key);
        return epibolyCostConDVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public ConEpibolyCostConDVO insert(ConEpibolyCostConDPayload payload) {
        ConEpibolyCostConDDO entityDo = ConEpibolyCostConDConvert.INSTANCE.toDo(payload);
        BigDecimal taxCost = payload.getAmt().multiply(payload.getTaxRate());
        entityDo.setTaxCost(taxCost);
        entityDo.setDetailedStatus("CREATE");
        if (payload.getParentId() == null) {
            ConEpibolyCostConVO conEpibolyCostConVO = this.costConService.queryByKey(payload.getEpibolyCostConId());
            SaleConContractVO saleConContractVO = this.saleConContractService.queryByKey(conEpibolyCostConVO.getContractId(), new Boolean[0]);
            BigDecimal effectiveAmt = saleConContractVO.getEffectiveAmt();
            BigDecimal ExtraAmt = payload.getAmt();
            BigDecimal newEffectiveAmt = effectiveAmt.subtract(ExtraAmt);
            this.conEpibolyCostConDDAO.updateSubConEffectiveAmt(newEffectiveAmt, conEpibolyCostConVO.getContractId());
        }
        this.conEpibolyCostConRepo.updateRemark(entityDo.getEpibolyCostConId());
        return ConEpibolyCostConDConvert.INSTANCE.toVo((ConEpibolyCostConDDO)this.conEpibolyCostConDRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ConEpibolyCostConDVO update(ConEpibolyCostConDPayload payload) {
        ConEpibolyCostConDDO entity = this.conEpibolyCostConDRepo.findById(payload.getId()).orElseGet(ConEpibolyCostConDDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConEpibolyCostConDDO entityDo = ConEpibolyCostConDConvert.INSTANCE.toDo(payload);
        BigDecimal taxCost = payload.getAmt().multiply(payload.getTaxRate());
        entityDo.setTaxCost(taxCost);
        if (payload.getParentId() == null) {
            ConEpibolyCostConVO conEpibolyCostConVO = this.costConService.queryByKey(payload.getEpibolyCostConId());
            SaleConContractVO saleConContractVO = this.saleConContractService.queryByKey(conEpibolyCostConVO.getContractId(), new Boolean[0]);
            BigDecimal effectiveAmt = saleConContractVO.getEffectiveAmt();
            BigDecimal newExtraAmt = payload.getAmt();
            BigDecimal oldExtraAmt = entity.getAmt();
            BigDecimal newEffectiveAmt = effectiveAmt.subtract(newExtraAmt).add(oldExtraAmt);
            this.conEpibolyCostConDDAO.updateSubConEffectiveAmt(newEffectiveAmt, conEpibolyCostConVO.getContractId());
        }
        entity.copy(entityDo);
        this.conEpibolyCostConRepo.updateRemark(entity.getEpibolyCostConId());
        return ConEpibolyCostConDConvert.INSTANCE.toVo((ConEpibolyCostConDDO)this.conEpibolyCostConDRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateByKeyDynamic(ConEpibolyCostConDPayload payload) {
        return this.conEpibolyCostConDDAO.updateByKeyDynamic(payload);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                ConEpibolyCostConDDO entity;
                Optional optional = this.conEpibolyCostConDRepo.findById(id);
                if (!optional.isEmpty() && (entity = (ConEpibolyCostConDDO)optional.get()).getParentId() == null) {
                    ConEpibolyCostConVO conEpibolyCostConVO = this.costConService.queryByKey(entity.getEpibolyCostConId());
                    SaleConContractVO saleConContractVO = this.saleConContractService.queryByKey(conEpibolyCostConVO.getContractId(), new Boolean[0]);
                    BigDecimal effectiveAmt = saleConContractVO.getEffectiveAmt();
                    BigDecimal newEffectiveAmt = effectiveAmt.add(entity.getAmt());
                    this.conEpibolyCostConDDAO.updateSubConEffectiveAmt(newEffectiveAmt, conEpibolyCostConVO.getContractId());
                }
            });
            this.conEpibolyCostConDDAO.deleteSoft(keys);
        }
    }

    @Transactional
    public void submission(Long contractId, Long dId) {
        SaleConContractVO saleConContractVO = this.saleConContractService.queryByKey(contractId, new Boolean[0]);
        if (!"active".equalsIgnoreCase(saleConContractVO.getStatus())) {
            throw TwException.error("", "\u5b50\u5408\u540c\u5c1a\u672a\u6fc0\u6d3b\uff0c\u4e0d\u80fd\u63d0\u4ea4\uff01");
        }
        ConEpibolyCostConDVO dvo = this.queryByKey(dId);
        if (!ObjectUtils.isEmpty((Object)dvo.getParentId())) {
            throw TwException.error("", "\u53ea\u6709\u5916\u5305\u4e3b\u660e\u7ec6\u624d\u53ef\u4ee5\u63d0\u4ea4\uff01");
        }
        if (!WorkFlowStatusEnum.CREATE_WORK.getCode().equals(dvo.getDetailedStatus())) {
            throw TwException.error("", "\u53ea\u6709\u65b0\u5efa\u7684\u5916\u5305\u660e\u7ec6\u624d\u53ef\u4ee5\u63d0\u4ea4\uff01");
        }
        this.submitProc(dvo);
    }

    @Transactional(rollbackFor={Exception.class})
    public ConEpibolyCostConDVO splitMoney(BigDecimal amt, Long parentId) {
        ConEpibolyCostConDVO dvo = this.conEpibolyCostConDDAO.queryByKey(parentId);
        if (!StringUtils.hasText((String)dvo.getDetailedStatus()) || "CREATE".equalsIgnoreCase(dvo.getDetailedStatus())) {
            throw TwException.error("", "\u660e\u7ec6\u5c1a\u672a\u63d0\u4ea4\uff0c\u4e0d\u80fd\u6309\u91d1\u989d\u62c6");
        }
        List<ConEpibolyCostConDVO> subDVOS = this.conEpibolyCostConDDAO.queryByParentId(parentId);
        BigDecimal subAmtSum = BigDecimal.ZERO;
        for (ConEpibolyCostConDVO subDVO : subDVOS) {
            if (subDVO.getAmt() == null) continue;
            subAmtSum = subAmtSum.add(subDVO.getAmt());
        }
        if (dvo.getAmt().subtract(subAmtSum).compareTo(amt) == -1) {
            throw TwException.error("", "\u5b50\u660e\u7ec6\u603b\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u4e3b\u660e\u7ec6\u91d1\u989d\uff01");
        }
        ConEpibolyCostConDPayload subPayload = ConEpibolyCostConDConvert.INSTANCE.toPayload(dvo);
        subPayload.setId(null);
        subPayload.setParentId(parentId);
        subPayload.setAmt(amt);
        BigDecimal subTaxCost = amt.multiply(subPayload.getTaxRate());
        subPayload.setTaxCost(subTaxCost);
        subPayload.setNetPay(amt.add(subTaxCost));
        ConEpibolyCostConDDO save = (ConEpibolyCostConDDO)this.conEpibolyCostConDRepo.save(ConEpibolyCostConDConvert.INSTANCE.toDo(subPayload));
        this.conEpibolyCostConRepo.updateRemark(dvo.getEpibolyCostConId());
        return ConEpibolyCostConDConvert.INSTANCE.toVo(save);
    }

    public List<ConEpibolyCostConDVO> queryByParentId(Long parentId) {
        return this.conEpibolyCostConDDAO.queryByParentId(parentId);
    }

    private void submitProc(ConEpibolyCostConDVO costConDVO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap variables = new HashMap();
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.SALE_CON_EC.name(), (String)(costConDVO.getSaleConName() + "-\u9500\u552e\u5408\u540c\u5916\u5305\u8d39\u7528\u5ba1\u6279\u6d41\u7a0b"), (String)("" + costConDVO.getId()), variables), new Long[0]);
        }
        ConEpibolyCostConDPayload payload = new ConEpibolyCostConDPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(costConDVO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setDetailedStatus(status);
        this.transactionUtilService.executeWithRunnable(() -> this.conEpibolyCostConDDAO.updateByKeyDynamic(payload));
    }

    public ConEpibolyCostConDServiceImpl(ConEpibolyCostConDRepo conEpibolyCostConDRepo, ConEpibolyCostConRepo conEpibolyCostConRepo, ConEpibolyCostConDDAO conEpibolyCostConDDAO, ConEpibolyCostConService costConService, WorkflowUtil workflowUtil, PrdOrgOrganizationService orgService, TransactionUtilService transactionUtilService, CacheUtil cacheUtil) {
        this.conEpibolyCostConDRepo = conEpibolyCostConDRepo;
        this.conEpibolyCostConRepo = conEpibolyCostConRepo;
        this.conEpibolyCostConDDAO = conEpibolyCostConDDAO;
        this.costConService = costConService;
        this.workflowUtil = workflowUtil;
        this.orgService = orgService;
        this.transactionUtilService = transactionUtilService;
        this.cacheUtil = cacheUtil;
    }
}

