/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.service;

import cn.hutool.core.collection.CollUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractManagerService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractManagerVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.SaleConContractPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConEpibolyCostConService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConPurchaseDemandDService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConPurchaseDemandService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConEpibolyCostConDVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConEpibolyCostConVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConPurchaseDemandDVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConPurchaseDemandVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractListVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.constants.PurchaseDemandTypeEnum;
import com.elitesland.tw.tw5.server.common.constants.SaleConContractPaperStatusEnum;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.common.util.TwAssert;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.log.service.ApiRequestLogService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.constant.CustomerOperationNoticeEnum;
import com.elitesland.tw.tw5.server.prd.crm.constant.CustomerOperationTypeEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.SaleConContractConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivablePlanDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.SaleConContractDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivablePlanRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConContractRepo;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5.server.yeedoc.config.YeedocProperties;
import com.elitesland.tw.tw5.server.yeedoc.service.YeedocService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class SaleConContractServiceImpl
extends BaseServiceImpl
implements SaleConContractService {
    private static final Logger log = LoggerFactory.getLogger(SaleConContractServiceImpl.class);
    private final SaleConContractRepo repo;
    private final SaleConContractDAO dao;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final ConReceivablePlanService conReceivablePlanService;
    private final CacheUtil cacheUtil;
    private final PrdSystemLogService logService;
    private final PrdSystemRoleDAO systemRoleDAO;
    @Autowired
    private ConEpibolyCostConService costConService;
    @Autowired
    private ConPurchaseDemandService demandService;
    @Autowired
    private ConPurchaseDemandDService demandDService;
    @Autowired
    private CrmOpportunityService opportunityService;
    private final TransactionUtilService transactionUtilService;
    private final FileUtil fileUtil;
    private final UdcUtil udcUtil;
    private final WorkflowUtil workflowUtil;
    private final PrdOrgOrganizationDAO daoOrg;
    private final PrdOrgOrganizationService orgService;
    private final PrdOrgSyncLogDAO daoLog;
    private final ConReceivablePlanRepo conReceivablePlanRepo;
    private final BusinessPartnerService businessPartnerService;
    @Autowired
    private PurchaseContractManagerService purchaseContractManagerService;
    private final PrdSystemRoleService roleService;
    @Autowired
    @Lazy
    private PmsProjectService pmsProjectService;
    @Value(value="${tw4.sale.contract}")
    private String saleContract;
    @Value(value="${tw4.sale.contractHistory}")
    private String saleContractHistory;
    @Value(value="${tw4.sale.contractSyncFlag}")
    private String contractSyncFlag;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    @Value(value="${tw5.jde.syncJdeContractUrl}")
    private String syncJdeContractUrl;
    @Value(value="${tw5.jde.count:3}")
    private Integer count;
    private final YeedocProperties yeedocProperties;
    private final YeedocService yeedocService;
    private final CrmCustomerOperationService crmCustomerOperationService;
    private final ApiRequestLogService apiRequestLogService;
    private final ComChangeService changeService;
    private BeanSearcher beanSearcher;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.SALE_CON_CONTRACT);
    }

    public PagingVO<SaleConContractVO> paging(SaleConContractQuery query) {
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = this.beanSearcher.searchCount(SaleConContractVO.class, mapBuilder.build());
        long total = (Long)totalNum;
        if (total == 0L) {
            return PagingVO.empty();
        }
        List saleConContractVOS = this.beanSearcher.searchList(SaleConContractVO.class, mapBuilder.build());
        this.computeAmount(saleConContractVOS);
        return PagingVO.builder().records(saleConContractVOS).total(total).build();
    }

    private MapBuilder pageWhereBuilder(SaleConContractQuery query) {
        MapBuilder builder = MapUtils.builder();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getId, new Object[]{query.getId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty((Collection)query.getIds())) {
            ((MapBuilder)builder.field(SaleConContractVO::getId, (Collection)query.getIds())).op((FieldOp)FieldOps.InList);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCode())) {
            ((MapBuilder)builder.field(SaleConContractVO::getCode, new Object[]{query.getCode()})).op((FieldOp)FieldOps.Contain);
        }
        if (!ObjectUtils.isEmpty((Object)query.getName())) {
            ((MapBuilder)builder.field(SaleConContractVO::getName, new Object[]{query.getName()})).op((FieldOp)FieldOps.Contain);
        }
        if (!ObjectUtils.isEmpty((Object)query.getEqName())) {
            ((MapBuilder)builder.field(SaleConContractVO::getName, new Object[]{query.getEqName()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getStatus())) {
            ((MapBuilder)builder.field(SaleConContractVO::getStatus, new Object[]{query.getStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty((Collection)query.getStatusList()) && query.getStatusList().size() == 2) {
            log.info("query getStatusList is {}", (Object)query.getStatusList());
            if ("0".equals(query.getStatusList().get(0))) {
                ((MapBuilder)builder.field(SaleConContractVO::getStatus, new Object[]{query.getStatusList().get(1)})).op((FieldOp)FieldOps.Equal);
            } else if ("1".equals(query.getStatusList().get(0))) {
                ((MapBuilder)builder.field(SaleConContractVO::getStatus, new Object[]{query.getStatusList().get(1)})).op((FieldOp)FieldOps.NotEqual);
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getOuBookId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getOuBookId, new Object[]{query.getOuBookId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getReferCode())) {
            ((MapBuilder)builder.field(SaleConContractVO::getReferCode, new Object[]{query.getReferCode()})).op((FieldOp)FieldOps.Contain);
        }
        if (!ObjectUtils.isEmpty((Object)query.getOppoId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getOppoId, new Object[]{query.getOppoId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getCustId, new Object[]{query.getCustId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty((Collection)query.getCustIdList())) {
            ((MapBuilder)builder.field(SaleConContractVO::getCustId, (Collection)query.getCustIdList())).op((FieldOp)FieldOps.InList);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustName())) {
            ((MapBuilder)builder.field(SaleConContractVO::getCustName, new Object[]{query.getCustName()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelatedContractId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getRelatedContractId, new Object[]{query.getRelatedContractId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustFlag())) {
            ((MapBuilder)builder.field(SaleConContractVO::getCustFlag, new Object[]{query.getCustFlag()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSignDate())) {
            ((MapBuilder)builder.field(SaleConContractVO::getSignDate, new Object[]{query.getSignDate()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSignDateStart()) && !ObjectUtils.isEmpty((Object)query.getSignDateEnd())) {
            ((MapBuilder)builder.field(SaleConContractVO::getSignDate, new Object[]{query.getSignDateStart(), query.getSignDateEnd()})).op((FieldOp)FieldOps.Between);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSignYear())) {
            ((MapBuilder)builder.field(SaleConContractVO::getSignDate, new FieldFns.FieldFn[0])).sql("year( $1 ) = ?", new Object[]{query.getSignYear().intValue()});
        }
        if (!ObjectUtils.isEmpty((Object)query.getSpecialConcerned())) {
            ((MapBuilder)builder.field(SaleConContractVO::getSpecialConcerned, new Object[]{query.getSpecialConcerned()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCurrCode())) {
            ((MapBuilder)builder.field(SaleConContractVO::getCurrCode, new Object[]{query.getCurrCode()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCloseReason())) {
            ((MapBuilder)builder.field(SaleConContractVO::getCloseReason, new Object[]{query.getCloseReason()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustProj())) {
            ((MapBuilder)builder.field(SaleConContractVO::getCustProj, new Object[]{query.getCustProj()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSaleContent())) {
            ((MapBuilder)builder.field(SaleConContractVO::getSaleContent, new Object[]{query.getSaleContent()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getProductClass())) {
            ((MapBuilder)builder.field(SaleConContractVO::getProductClass, new Object[]{query.getProductClass()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getProductSubClass())) {
            ((MapBuilder)builder.field(SaleConContractVO::getProductSubClass, new Object[]{query.getProductSubClass()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliveryAddress())) {
            ((MapBuilder)builder.field(SaleConContractVO::getDeliveryAddress, new Object[]{query.getDeliveryAddress()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getFinPeriodId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getFinPeriodId, new Object[]{query.getFinPeriodId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getAmt())) {
            ((MapBuilder)builder.field(SaleConContractVO::getAmt, new Object[]{query.getAmt()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtraAmt())) {
            ((MapBuilder)builder.field(SaleConContractVO::getExtraAmt, new Object[]{query.getExtraAmt()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getEffectiveAmt())) {
            ((MapBuilder)builder.field(SaleConContractVO::getEffectiveAmt, new Object[]{query.getEffectiveAmt()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getGrossProfit())) {
            ((MapBuilder)builder.field(SaleConContractVO::getGrossProfit, new Object[]{query.getGrossProfit()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getRegionBuId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getRegionBuId, new Object[]{query.getRegionBuId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getRegionUserId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getRegionUserId, new Object[]{query.getRegionUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSignBuId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getSignBuId, new Object[]{query.getSignBuId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSaleManUserId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getSaleManUserId, new Object[]{query.getSaleManUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCoSignBuId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getCoSignBuId, new Object[]{query.getCoSignBuId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCoSignUserId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getCoSignUserId, new Object[]{query.getCoSignUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliBuId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getDeliBuId, new Object[]{query.getDeliBuId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliUserId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getDeliUserId, new Object[]{query.getDeliUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCodeliBuId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getCodeliBuId, new Object[]{query.getCodeliBuId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCodeliUserId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getCodeliUserId, new Object[]{query.getCodeliUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlatType())) {
            ((MapBuilder)builder.field(SaleConContractVO::getPlatType, new Object[]{query.getPlatType()})).op((FieldOp)FieldOps.Equal);
        } else {
            ((MapBuilder)builder.field(SaleConContractVO::getPlatType, new Object[]{SaleConEnum.FICTITIOUS.getCode()})).op((FieldOp)FieldOps.NotEqual);
        }
        if (!ObjectUtils.isEmpty((Object)query.getMainType())) {
            ((MapBuilder)builder.field(SaleConContractVO::getMainType, new Object[]{query.getMainType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPmoUserId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getPmoUserId, new Object[]{query.getPmoUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceType())) {
            ((MapBuilder)builder.field(SaleConContractVO::getSourceType, new Object[]{query.getSourceType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getExternalIden())) {
            ((MapBuilder)builder.field(SaleConContractVO::getExternalIden, new Object[]{query.getExternalIden()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getExternalName())) {
            ((MapBuilder)builder.field(SaleConContractVO::getExternalName, new Object[]{query.getExternalName()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getExternalPhone())) {
            ((MapBuilder)builder.field(SaleConContractVO::getExternalPhone, new Object[]{query.getExternalPhone()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getInternalBuId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getInternalBuId, new Object[]{query.getInternalBuId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getProfitDesc())) {
            ((MapBuilder)builder.field(SaleConContractVO::getProfitDesc, new Object[]{query.getProfitDesc()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaxRate())) {
            ((MapBuilder)builder.field(SaleConContractVO::getTaxRate, new Object[]{query.getTaxRate()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getInternalUserId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getInternalUserId, new Object[]{query.getInternalUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getStartDate())) {
            ((MapBuilder)builder.field(SaleConContractVO::getStartDate, new Object[]{query.getStartDate()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getEndDate())) {
            ((MapBuilder)builder.field(SaleConContractVO::getEndDate, new Object[]{query.getEndDate()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaperDesc())) {
            ((MapBuilder)builder.field(SaleConContractVO::getPaperDesc, new Object[]{query.getPaperDesc()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaperStatus())) {
            ((MapBuilder)builder.field(SaleConContractVO::getPaperStatus, new Object[]{query.getPaperStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getAcitveDate())) {
            ((MapBuilder)builder.field(SaleConContractVO::getAcitveDate, new Object[]{query.getAcitveDate()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getProduct())) {
            ((MapBuilder)builder.field(SaleConContractVO::getProduct, new Object[]{query.getProduct()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getBriefDesc())) {
            ((MapBuilder)builder.field(SaleConContractVO::getBriefDesc, new Object[]{query.getBriefDesc()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkType())) {
            ((MapBuilder)builder.field(SaleConContractVO::getWorkType, new Object[]{query.getWorkType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPromotionType())) {
            ((MapBuilder)builder.field(SaleConContractVO::getPromotionType, new Object[]{query.getPromotionType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getRangeProp())) {
            ((MapBuilder)builder.field(SaleConContractVO::getRangeProp, new Object[]{query.getRangeProp()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getHalfOpenDesc())) {
            ((MapBuilder)builder.field(SaleConContractVO::getHalfOpenDesc, new Object[]{query.getHalfOpenDesc()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSupplierType())) {
            ((MapBuilder)builder.field(SaleConContractVO::getSupplierType, new Object[]{query.getSupplierType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCommissionType())) {
            ((MapBuilder)builder.field(SaleConContractVO::getCommissionType, new Object[]{query.getCommissionType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getTransactionMethod())) {
            ((MapBuilder)builder.field(SaleConContractVO::getTransactionMethod, new Object[]{query.getTransactionMethod()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getTransactionNature())) {
            ((MapBuilder)builder.field(SaleConContractVO::getTransactionNature, new Object[]{query.getTransactionNature()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getDemandType())) {
            ((MapBuilder)builder.field(SaleConContractVO::getDemandType, new Object[]{query.getDemandType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSaleClass())) {
            ((MapBuilder)builder.field(SaleConContractVO::getSaleClass, new Object[]{query.getSaleClass()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustBarExpense())) {
            ((MapBuilder)builder.field(SaleConContractVO::getCustBarExpense, new Object[]{query.getCustBarExpense()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getReimbursementDesc())) {
            ((MapBuilder)builder.field(SaleConContractVO::getReimbursementDesc, new Object[]{query.getReimbursementDesc()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getRatedEqva())) {
            ((MapBuilder)builder.field(SaleConContractVO::getRatedEqva, new Object[]{query.getRatedEqva()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getRatedExpense())) {
            ((MapBuilder)builder.field(SaleConContractVO::getRatedExpense, new Object[]{query.getRatedExpense()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getContractPrinter())) {
            ((MapBuilder)builder.field(SaleConContractVO::getContractPrinter, new Object[]{query.getContractPrinter()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPrintCount())) {
            ((MapBuilder)builder.field(SaleConContractVO::getPrintCount, new Object[]{query.getPrintCount()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSealType())) {
            ((MapBuilder)builder.field(SaleConContractVO::getSealType, new Object[]{query.getSealType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSendWithInvoiceFlag())) {
            ((MapBuilder)builder.field(SaleConContractVO::getSendWithInvoiceFlag, new Object[]{query.getSendWithInvoiceFlag()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getMailingAddress())) {
            ((MapBuilder)builder.field(SaleConContractVO::getMailingAddress, new Object[]{SqlUtil.toSqlLikeString(query.getMailingAddress())})).op((FieldOp)FieldOps.Contain);
        }
        if (!ObjectUtils.isEmpty((Object)query.getParentId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getParentId, new Object[]{query.getParentId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCloseDate())) {
            ((MapBuilder)builder.field(SaleConContractVO::getCloseDate, new Object[]{query.getCloseDate()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreSaleBuId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getPreSaleBuId, new Object[]{query.getPreSaleBuId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreSaleUserId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getPreSaleUserId, new Object[]{query.getPreSaleUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getAmtScope())) {
            ((MapBuilder)builder.field(SaleConContractVO::getAmt, new Object[]{query.getAmtScope().get(0), query.getAmtScope().get(1)})).op((FieldOp)FieldOps.Between);
        }
        if ("handled".equals(query.getAchieveStatus())) {
            ((MapBuilder)builder.field(SaleConContractVO::getCaId, new FieldFns.FieldFn[0])).sql("$1 is not null");
        }
        if ("unhandled".equals(query.getAchieveStatus())) {
            ((MapBuilder)builder.field(SaleConContractVO::getCaId, new FieldFns.FieldFn[0])).sql("$1 is  null");
        }
        if (!ObjectUtils.isEmpty((Object)query.getAchieveBuId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getAchieveBuId, new FieldFns.FieldFn[0])).sql("$1 =? ", new Object[]{query.getAchieveBuId()});
        }
        if (!ObjectUtils.isEmpty((Object)query.getValueRole())) {
            ((MapBuilder)builder.field(SaleConContractVO::getValueRole, new FieldFns.FieldFn[0])).sql("$1  =? ", new Object[]{query.getValueRole()});
        }
        if (!ObjectUtils.isEmpty((Object)query.getChargeResId())) {
            ((MapBuilder)builder.field(SaleConContractVO::getChargeResId, new FieldFns.FieldFn[0])).sql("$1 =? ", new Object[]{query.getChargeResId()});
        }
        if (!ObjectUtils.isEmpty((Object)query.getFilingFlag())) {
            ((MapBuilder)builder.field(SaleConContractVO::getFilingFlag, new Object[]{query.getFilingFlag()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getIsProjectCreate())) {
            if (Integer.valueOf(0).compareTo(query.getIsProjectCreate()) == 0) {
                ((MapBuilder)builder.field(SaleConContractVO::getProjCode, new FieldFns.FieldFn[0])).sql("$1 is null");
            } else if (Integer.valueOf(1).compareTo(query.getIsProjectCreate()) == 0) {
                ((MapBuilder)builder.field(SaleConContractVO::getProjCode, new FieldFns.FieldFn[0])).sql("$1 is not null");
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getConConditionFlag())) {
            if (0 == query.getConConditionFlag()) {
                ((MapBuilder)builder.field(SaleConContractVO::getScecContractId, new FieldFns.FieldFn[0])).sql("$1 is  null");
            } else {
                ((MapBuilder)builder.field(SaleConContractVO::getScecContractId, new FieldFns.FieldFn[0])).sql("$1 is not null");
            }
        }
        SqlUtil.handleBS(builder, (TwQueryParam)query);
        return builder;
    }

    public PagingVO<SaleConContractVO> queryPaging(SaleConContractQuery query) {
        this.getPermissionParams(query);
        log.info("\u9500\u552e\u5408\u540c\u5206\u9875service\u5c42\u5165\u53c2\u5408\u540c\u540d\u79f0 is {},\u5408\u540c\u72b6\u6001 is {}", (Object)query.getName(), (Object)query.getStatusList());
        PagingVO<SaleConContractVO> saleConContractVOPagingVO = this.dao.queryPaging(query);
        this.computeAmount(saleConContractVOPagingVO.getRecords());
        return saleConContractVOPagingVO;
    }

    public Long count(SaleConContractQuery query) {
        this.getPermissionParams(query);
        return this.dao.count(query);
    }

    private void computeAmount(List<SaleConContractVO> saleConContractVOS) {
        List<SaleConContractVO> mainConVOList = saleConContractVOS.stream().filter(vo -> Objects.equals(vo.getMainType(), SaleConEnum.MAIN.getCode())).toList();
        List<SaleConContractVO> subConVOList = saleConContractVOS.stream().filter(vo -> Objects.equals(vo.getMainType(), SaleConEnum.SUB.getCode())).toList();
        List<Long> subConListIds = subConVOList.stream().map(SaleConContractVO::getId).toList();
        List<Long> mainConListIds = mainConVOList.stream().map(SaleConContractVO::getId).toList();
        List<SaleConContractDO> subConDOSByMainConList = this.repo.findByDeleteFlagAndParentIdIn(0, mainConListIds);
        List<Long> subConIdsByMainCon = subConDOSByMainConList.stream().map(BaseModel::getId).toList();
        ArrayList<Long> allSubConIds = new ArrayList<Long>();
        allSubConIds.addAll(subConListIds);
        allSubConIds.addAll(subConIdsByMainCon);
        List<ConReceivablePlanDO> conReceivablePlanDOS = this.conReceivablePlanRepo.findAllByDeleteFlagAndSaleConIdIn(0, allSubConIds);
        HashMap<Long, BigDecimal> receivableAmountMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> invoicingAmountMap = new HashMap<Long, BigDecimal>();
        for (ConReceivablePlanDO conReceivablePlanDO : conReceivablePlanDOS) {
            Long saleConId = conReceivablePlanDO.getSaleConId();
            BigDecimal alreadyReceAmt = conReceivablePlanDO.getActualRecvAmt() != null ? conReceivablePlanDO.getActualRecvAmt() : BigDecimal.ZERO;
            BigDecimal alreadyInvAmt = conReceivablePlanDO.getAlreadyInvAmt() != null ? conReceivablePlanDO.getAlreadyInvAmt() : BigDecimal.ZERO;
            BigDecimal collectedAmount = receivableAmountMap.getOrDefault(saleConId, BigDecimal.ZERO);
            collectedAmount = collectedAmount.add(alreadyReceAmt);
            receivableAmountMap.put(saleConId, collectedAmount);
            BigDecimal invoicedAmount = invoicingAmountMap.getOrDefault(saleConId, BigDecimal.ZERO);
            invoicedAmount = invoicedAmount.add(alreadyInvAmt);
            invoicingAmountMap.put(saleConId, invoicedAmount);
        }
        for (SaleConContractVO saleConContractVO : saleConContractVOS) {
            BigDecimal invoicingAmount = BigDecimal.ZERO;
            BigDecimal amountCollected = BigDecimal.ZERO;
            if (!SaleConEnum.MAIN.getCode().equalsIgnoreCase(saleConContractVO.getMainType())) {
                invoicingAmount = invoicingAmountMap.getOrDefault(saleConContractVO.getId(), invoicingAmount);
                amountCollected = receivableAmountMap.getOrDefault(saleConContractVO.getId(), amountCollected);
            } else {
                for (SaleConContractDO subCon : subConDOSByMainConList) {
                    if (!subCon.getParentId().equals(saleConContractVO.getId())) continue;
                    invoicingAmount = invoicingAmount.add(invoicingAmountMap.getOrDefault(subCon.getId(), BigDecimal.ZERO));
                    amountCollected = amountCollected.add(receivableAmountMap.getOrDefault(subCon.getId(), BigDecimal.ZERO));
                }
            }
            saleConContractVO.setAmountCollected(amountCollected);
            saleConContractVO.setInvoicingAmount(invoicingAmount);
            this.transfer(saleConContractVO);
        }
    }

    public void getPermissionParams(SaleConContractQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        List<String> userSystemRoleCodes = this.cacheUtil.getSystemRoleCodes(loginUserId);
        List<String> roles = Arrays.asList("SALES_VP", "SALES_CONTRACT_ADMIN", "SYS", "FIN_PIC", "BUSINESS_MANAGER", "CONTRACT_FILING", "PLAT_FIN_PIC", "OPERATION_PRESIDENT", "FIN_CHECK_PIC", "PLAT_FINANCIAL_PERFORMANCE_STATISTICS");
        if (!CollectionUtils.isEmpty(userSystemRoleCodes) && CollectionUtils.containsAny(userSystemRoleCodes, roles)) {
            return;
        }
        PrdOrgOrganizationQuery orgQuery = new PrdOrgOrganizationQuery();
        orgQuery.setManageId(loginUserId);
        orgQuery.setSize(Integer.valueOf(Integer.MAX_VALUE));
        PagingVO paging = this.orgService.paging(orgQuery);
        List records = paging.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            List orgIds = records.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            query.setOrgIdsByPermission(orgIds);
        } else {
            query.setOrgIdsByPermission(new ArrayList());
        }
        query.setUserIdsByPermission(Collections.singletonList(loginUserId));
    }

    public List<SaleConContractVO> queryList(SaleConContractQuery query) {
        List<SaleConContractVO> saleConContractVOS = SaleConContractConvert.INSTANCE.toVoList(this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest().getSort()));
        saleConContractVOS.stream().forEach(e -> this.transfer((SaleConContractVO)e));
        return saleConContractVOS;
    }

    public List<SaleConContractVO> queryContractListDynamic(SaleConContractQuery query) {
        List<SaleConContractVO> saleConContractVOS = this.dao.queryContractListDynamic(query);
        return saleConContractVOS;
    }

    public List<SaleConContractListVO> queryListDynamic(SaleConContractQuery query) {
        List<SaleConContractListVO> saleConContractVOS = this.dao.queryListDynamic(query);
        return saleConContractVOS;
    }

    public SaleConContractVO queryByKey(Long key, Boolean ... auth) {
        SaleConContractVO vo = this.dao.queryByKey(key);
        Assert.notNull((Object)vo.getId(), (String)"\u4e0d\u5b58\u5728");
        BigDecimal amt = vo.getAmt() == null ? BigDecimal.ZERO : vo.getAmt();
        BigDecimal taxRate = vo.getTaxRate() == null ? BigDecimal.ZERO : vo.getTaxRate();
        BigDecimal notTaxAmt = amt.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
        vo.setNotTaxAmt(notTaxAmt);
        SaleConContractPayload saleConContractPayload = this.subAmtCount(SaleConContractConvert.INSTANCE.toPayload(vo));
        if (saleConContractPayload.getExtraAmt() != null) {
            vo.setExtraAmt(saleConContractPayload.getExtraAmt().setScale(2, 4));
        }
        if (saleConContractPayload.getEffectiveAmt() != null) {
            vo.setEffectiveAmt(saleConContractPayload.getEffectiveAmt().setScale(2, 4));
        }
        if (saleConContractPayload.getDemandTotalAmt() != null) {
            vo.setDemandTotalAmt(saleConContractPayload.getDemandTotalAmt().setScale(2, 4));
        }
        SaleConContractPayload payload = new SaleConContractPayload();
        payload.setId(saleConContractPayload.getId());
        payload.setEffectiveAmt(saleConContractPayload.getEffectiveAmt());
        payload.setExtraAmt(saleConContractPayload.getExtraAmt());
        this.dao.updateByKeyDynamic(payload);
        vo.setFileDatas(this.fileUtil.getFileDatas(vo.getFileCodes()));
        vo.setSowDatas(this.fileUtil.getFileDatas(vo.getSowFileCodes()));
        vo.setAssessDatas(this.fileUtil.getFileDatas(vo.getAssessFileCodes()));
        vo.setCloseDatas(this.fileUtil.getFileDatas(vo.getCloseFileCodes()));
        this.computeAmount(Collections.singletonList(vo));
        Boolean saleBudgetAuthFlag = false;
        if (auth == null || auth.length == 0 || !ObjectUtils.isEmpty((Object[])auth) && !auth[0].booleanValue()) {
            return vo;
        }
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (loginUserId != null) {
            PrdOrgOrganizationVO org;
            Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.PLAT_RESOURCE_DIRECTOR.getCode(), RoleEnum.PLAT_CFO.getCode(), RoleEnum.PLAT_FIN_PIC.getCode(), RoleEnum.SALE_CONTRACT_BUDGET_MANAGER.getCode(), RoleEnum.SYS.getCode()));
            if (rolePermission.booleanValue()) {
                saleBudgetAuthFlag = true;
            }
            if (vo.getDeliBuId() != null && (org = this.cacheUtil.getOrg(vo.getDeliBuId())) != null && loginUserId.equals(org.getManageId())) {
                saleBudgetAuthFlag = true;
            }
            vo.setSaleBudgetAuthFlag(saleBudgetAuthFlag);
        }
        if (null != vo.getCustId()) {
            BusinessPartnerVO businessPartnerVO = this.businessPartnerService.queryCustomerByBookId(vo.getCustId());
            vo.setCustStatus(businessPartnerVO.getCustomerStatus());
            vo.setPartnerId(businessPartnerVO.getId());
        }
        return vo;
    }

    @Transactional
    public SaleConContractVO insert(SaleConContractPayload payload) {
        if (payload.getProductClass() == null) {
            throw TwException.error("", "\u9500\u552e\u5927\u7c7b\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        String name = payload.getName();
        if (org.springframework.util.StringUtils.hasText((String)name)) {
            SaleConContractQuery query = new SaleConContractQuery();
            query.setName(name);
            PagingVO<SaleConContractVO> queryPaging = this.dao.queryPaging(query);
            if (!CollectionUtils.isEmpty((Collection)queryPaging.getRecords())) {
                throw TwException.warn("", "\u5408\u540c\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\uff01");
            }
        }
        SaleConContractDO entityDo = SaleConContractConvert.INSTANCE.toDo(payload);
        String itemId = "";
        ArrayList<String> pathArry = new ArrayList<String>();
        entityDo.setFilingFlag(0);
        if ("MAIN".equalsIgnoreCase(payload.getMainType())) {
            String code = this.generateSeqNum("SALE_CON_NO", new String[0]);
            entityDo.setCode(code);
            Long oppoId = payload.getOppoId();
            if (!ObjectUtils.isEmpty((Object)oppoId)) {
                this.opportunityService.closeOpportunity(oppoId, "01", null, null, Boolean.valueOf(false));
            }
            pathArry.add("/" + code + " " + name);
        } else {
            SaleConContractVO mainCon = this.dao.queryByKey(payload.getParentId());
            if (!"ACTIVE".equalsIgnoreCase(mainCon.getStatus())) {
                throw TwException.warn("", "\u4e3b\u5408\u540c\u662f\u6fc0\u6d3b\u72b6\u6001\u624d\u53ef\u4ee5\u521b\u5efa\u5b50\u5408\u540c");
            }
            List<SaleConContractDO> subCons = this.repo.findByParentId(payload.getParentId());
            Object subCode = mainCon.getCode();
            subCode = subCons.size() < 9 ? (String)subCode + "0" + (subCons.size() + 1) : (String)subCode + (subCons.size() + 1);
            entityDo.setCode((String)subCode);
            if (!SaleConEnum.FICTITIOUS.getCode().equalsIgnoreCase(entityDo.getPlatType())) {
                entityDo.setStatus("CREATE");
            }
            itemId = mainCon.getFolderId();
            pathArry.add("/" + (String)subCode + " " + name);
            entityDo.setPercentage(BigDecimal.ZERO);
            if (org.springframework.util.StringUtils.hasText((String)payload.getWorkType())) {
                PrdSystemSelectionVO prdSystemSelectionVO = this.cacheUtil.querySystemSelection("salecon:work_type", payload.getWorkType());
                String extString2 = prdSystemSelectionVO.getExtString2();
                if (!org.springframework.util.StringUtils.hasText((String)extString2)) {
                    log.error("\u5de5\u4f5c\u7c7b\u578b\uff1a" + prdSystemSelectionVO.getSelectionName() + "\u672a\u7ef4\u62a4\u6bd4\u4f8b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                try {
                    BigDecimal percentage = new BigDecimal(prdSystemSelectionVO.getExtString2());
                    entityDo.setPercentage(percentage);
                }
                catch (Exception e) {
                    log.error("\u5de5\u4f5c\u7c7b\u578b\uff1a" + prdSystemSelectionVO.getSelectionName() + "\u7ef4\u62a4\u6bd4\u4f8b\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
            }
        }
        Object changeLog = "";
        SaleConContractVO saleConContractVO = SaleConContractConvert.INSTANCE.toVo((SaleConContractDO)this.repo.save(entityDo));
        if ("MAIN".equalsIgnoreCase(payload.getMainType())) {
            changeLog = "\u65b0\u5efa\u4e3b\u5408\u540c";
        } else {
            changeLog = "\u65b0\u5efa\u5b50\u5408\u540c" + saleConContractVO.getName();
            this.logService.saveNewLog(saleConContractVO.getParentId(), PrdSystemObjectEnum.SaleConContract.getCode(), (String)changeLog);
            payload.setId(saleConContractVO.getId());
            this.subAmtCount(payload);
            entityDo.setEffectiveAmt(payload.getEffectiveAmt());
            this.repo.save(entityDo);
        }
        this.logService.saveNewLog(saleConContractVO.getId(), PrdSystemObjectEnum.SaleConContract.getCode(), (String)changeLog);
        if (payload.getFileFlag().booleanValue()) {
            String ydkFolderId = this.createYdkFolder(itemId, pathArry, payload.getAuthTokenByYdk());
            entityDo.setFolderId(ydkFolderId);
            HashSet<String> allCacheKeys = new HashSet<String>();
            List<Object> cacheKeys = new ArrayList();
            List<Object> assessCacheKeys = new ArrayList();
            List<Object> sowCacheKeys = new ArrayList();
            if (org.springframework.util.StringUtils.hasText((String)payload.getCacheKey())) {
                cacheKeys = Arrays.asList(payload.getCacheKey().split(","));
                allCacheKeys.addAll(cacheKeys);
            }
            if (org.springframework.util.StringUtils.hasText((String)payload.getAssessCacheKey())) {
                assessCacheKeys = Arrays.asList(payload.getAssessCacheKey().split(","));
                allCacheKeys.addAll(assessCacheKeys);
            }
            if (org.springframework.util.StringUtils.hasText((String)payload.getSowCacheKey())) {
                sowCacheKeys = Arrays.asList(payload.getSowCacheKey().split(","));
                allCacheKeys.addAll(sowCacheKeys);
            }
            if (!CollectionUtils.isEmpty(allCacheKeys)) {
                String str;
                Map<String, String> cacheMap = this.saveYdkFile(ydkFolderId, allCacheKeys, payload.getAuthTokenByYdk());
                if (org.springframework.util.StringUtils.hasText((String)payload.getCacheKey())) {
                    str = cacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
                    entityDo.setFileCodes(str);
                }
                if (org.springframework.util.StringUtils.hasText((String)payload.getAssessCacheKey())) {
                    str = assessCacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
                    entityDo.setAssessFileCodes(str);
                }
                if (org.springframework.util.StringUtils.hasText((String)payload.getSowCacheKey())) {
                    str = sowCacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
                    entityDo.setSowFileCodes(str);
                }
            }
        }
        return saleConContractVO;
    }

    private void initData(SaleConContractPayload payload) {
        if (payload.getAgentFlag() == null) {
            payload.setAgentFlag(Integer.valueOf(0));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public SaleConContractVO update(SaleConContractPayload payload) {
        if (payload.getProductClass() == null) {
            throw TwException.error("", "\u9500\u552e\u5927\u7c7b\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        String name = payload.getName();
        if (org.springframework.util.StringUtils.hasText((String)name)) {
            List collect;
            SaleConContractQuery query = new SaleConContractQuery();
            query.setName(name);
            PagingVO<SaleConContractVO> queryPaging = this.dao.queryPaging(query);
            List records = queryPaging.getRecords();
            if (!CollectionUtils.isEmpty((Collection)queryPaging.getRecords()) && CollectionUtils.isEmpty(collect = records.stream().filter(e -> !e.getId().equals(payload.getId())).collect(Collectors.toList()))) {
                throw TwException.warn("", "\u5408\u540c\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\uff01");
            }
        }
        SaleConContractDO entity = this.repo.findById(payload.getId()).orElseGet(SaleConContractDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("APPROVING");
        statusList.add("CLOSE");
        statusList.add("INVALID");
        if (statusList.contains(entity.getStatus())) {
            throw TwException.error("", "\u5ba1\u6279\u4e2d\u3001\u5173\u95ed\u3001\u4f5c\u5e9f\u7684\u5408\u540c\u4e0d\u53ef\u4ee5\u8fdb\u884c\u4fee\u6539");
        }
        if (entity.getAmt().compareTo(payload.getAmt()) != 0 || entity.getTaxRate().compareTo(payload.getTaxRate()) != 0) {
            this.subAmtCount(payload);
        }
        SaleConContractDO entityDo = SaleConContractConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        SaleConContractDO save = (SaleConContractDO)this.repo.save(entity);
        return SaleConContractConvert.INSTANCE.toVo(save);
    }

    @Transactional
    public Long updateByKeyDynamic(SaleConContractPayload payload) {
        String ydkFolderId;
        List<SaleConContractDO> subConDOSByMainConList;
        Field[] fields;
        SaleConContractDO entity = this.repo.findById(payload.getId()).orElseGet(SaleConContractDO::new);
        TwAssert.notNull(entity.getId(), "\u5408\u540c\u4fe1\u606f\u4e0d\u5b58\u5728");
        String name = payload.getName();
        if (org.springframework.util.StringUtils.hasText((String)name)) {
            List collect;
            SaleConContractQuery query = new SaleConContractQuery();
            query.setEqName(name);
            PagingVO<SaleConContractVO> queryPaging = this.dao.queryPaging(query);
            List records = queryPaging.getRecords();
            if (!CollectionUtils.isEmpty((Collection)queryPaging.getRecords()) && !CollectionUtils.isEmpty(collect = records.stream().filter(e -> !e.getId().equals(payload.getId())).collect(Collectors.toList()))) {
                throw TwException.warn("", "\u5408\u540c\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\uff01");
            }
        }
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("APPROVING");
        statusList.add("CLOSE");
        statusList.add("INVALID");
        if (statusList.contains(entity.getStatus())) {
            throw TwException.error("", "\u5ba1\u6279\u4e2d\u3001\u5173\u95ed\u3001\u4f5c\u5e9f\u7684\u5408\u540c\u4e0d\u53ef\u4ee5\u8fdb\u884c\u4fee\u6539");
        }
        SaleConContractDO oldEntity = new SaleConContractDO();
        Class<?> clazz = payload.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!"java.math.BigDecimal".equals(field.getType().getName())) continue;
            String fieldName = field.getName();
            String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            try {
                Method getMethod = clazz.getMethod(getMethodName, new Class[0]);
                BigDecimal value = (BigDecimal)getMethod.invoke((Object)payload, new Object[0]);
                if (value == null) continue;
                String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                Method setMethod = clazz.getDeclaredMethod(setMethodName, field.getType());
                setMethod.invoke((Object)payload, value.setScale(2));
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        SaleConContractDO newEntity = SaleConContractConvert.INSTANCE.toDo(payload);
        BeanUtils.copyProperties((Object)entity, (Object)oldEntity);
        newEntity.setRemark(null);
        oldEntity.setRemark(null);
        Object changeLog = this.changeFieldLogUtil.getFieldsUpdateLog(newEntity, oldEntity);
        if (!Objects.equals(oldEntity.getCustFlag(), newEntity.getCustFlag())) {
            changeLog = newEntity.getCustFlag() == 1L ? (String)changeLog + "\u65b0\u8001\u5ba2\u6237 \u7531 \u65b0\u5ba2\u6237 \u4fee\u6539\u4e3a \u8001\u5ba2\u6237" : (String)changeLog + "\u65b0\u8001\u5ba2\u6237 \u7531 \u8001\u5ba2\u6237 \u4fee\u6539\u4e3a \u65b0\u5ba2\u6237";
        }
        this.logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.SaleConContract.getCode(), (String)changeLog);
        if (!(!"MAIN".equals(newEntity.getMainType()) || ObjectUtils.isEmpty((Object)newEntity.getCodeliUserId()) && ObjectUtils.isEmpty((Object)newEntity.getCoSignUserId()) && ObjectUtils.isEmpty((Object)newEntity.getSignBuId()) && ObjectUtils.isEmpty((Object)newEntity.getSaleManUserId()) || CollectionUtils.isEmpty(subConDOSByMainConList = this.repo.findByDeleteFlagAndParentIdIn(0, List.of(newEntity.getId()))))) {
            subConDOSByMainConList.forEach(sub -> this.dao.updateSubContractInfoByMainContract(sub.getId(), newEntity));
        }
        if ("SUB".equals(newEntity.getMainType())) {
            BigDecimal newTax;
            BigDecimal oldAmt = oldEntity.getAmt() == null ? BigDecimal.ZERO : oldEntity.getAmt();
            BigDecimal newAmt = newEntity.getAmt() == null ? BigDecimal.ZERO : newEntity.getAmt();
            BigDecimal oldTax = oldEntity.getTaxRate() == null ? new BigDecimal("0.00") : oldEntity.getTaxRate();
            BigDecimal bigDecimal = newTax = newEntity.getTaxRate() == null ? new BigDecimal("0.00") : newEntity.getTaxRate();
            if (oldAmt.compareTo(newAmt) != 0 || oldTax.compareTo(newTax) != 0) {
                this.subAmtCount(payload);
            }
        }
        if (ObjectUtils.isEmpty((Object)newEntity.getProductClass()) || !newEntity.getProductClass().equals(oldEntity.getProductClass())) {
            List nullFields = payload.getNullFields();
            nullFields.add("productSubClassId");
            payload.setNullFields(nullFields);
        }
        if (!org.springframework.util.StringUtils.hasText((String)(ydkFolderId = entity.getFolderId()))) {
            SaleConContractVO mainCon;
            String itemId = "";
            ArrayList<String> pathArry = new ArrayList<String>();
            if ("SUB".equalsIgnoreCase(payload.getMainType()) && !org.springframework.util.StringUtils.hasText((String)(itemId = (mainCon = this.dao.queryByKey(payload.getParentId())).getFolderId()))) {
                ArrayList<String> mainPathArry = new ArrayList<String>();
                mainPathArry.add("/" + mainCon.getCode() + " " + mainCon.getName());
                itemId = this.createYdkFolder("", mainPathArry, payload.getAuthTokenByYdk());
                mainCon.setFolderId(itemId);
                SaleConContractPayload mainPaylod = SaleConContractConvert.INSTANCE.toPayload(mainCon);
                this.dao.updateByKeyDynamic(mainPaylod);
            }
            pathArry.add("/" + entity.getCode() + " " + name);
            ydkFolderId = this.createYdkFolder(itemId, pathArry, payload.getAuthTokenByYdk());
            payload.setFolderId(ydkFolderId);
        }
        if (payload.getFileFlag().booleanValue()) {
            if (!entity.getName().equals(payload.getName())) {
                ydkFolderId = this.reNameFolder(entity.getFolderId(), "/" + payload.getCode() + " " + name, payload.getAuthTokenByYdk());
                payload.setFolderId(ydkFolderId);
            }
            HashSet<String> allCacheKeys = new HashSet<String>();
            List<Object> cacheKeys = new ArrayList();
            List<Object> assessCacheKeys = new ArrayList();
            List<Object> sowCacheKeys = new ArrayList();
            if (org.springframework.util.StringUtils.hasText((String)payload.getCacheKey())) {
                cacheKeys = Arrays.asList(payload.getCacheKey().split(","));
                allCacheKeys.addAll(cacheKeys);
            }
            if (org.springframework.util.StringUtils.hasText((String)payload.getAssessCacheKey())) {
                assessCacheKeys = Arrays.asList(payload.getAssessCacheKey().split(","));
                allCacheKeys.addAll(assessCacheKeys);
            }
            if (org.springframework.util.StringUtils.hasText((String)payload.getSowCacheKey())) {
                sowCacheKeys = Arrays.asList(payload.getSowCacheKey().split(","));
                allCacheKeys.addAll(sowCacheKeys);
            }
            if (!CollectionUtils.isEmpty(allCacheKeys)) {
                String fileCodes;
                String newFileCodes;
                Map<String, String> cacheMap = this.saveYdkFile(ydkFolderId, allCacheKeys, payload.getAuthTokenByYdk());
                if (org.springframework.util.StringUtils.hasText((String)payload.getCacheKey())) {
                    newFileCodes = cacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
                    fileCodes = org.springframework.util.StringUtils.hasText((String)payload.getFileCodes()) ? payload.getFileCodes().concat(",").concat(newFileCodes) : newFileCodes;
                    payload.setFileCodes(fileCodes);
                }
                if (org.springframework.util.StringUtils.hasText((String)payload.getAssessCacheKey())) {
                    newFileCodes = assessCacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
                    fileCodes = org.springframework.util.StringUtils.hasText((String)payload.getAssessFileCodes()) ? payload.getAssessFileCodes().concat(",").concat(newFileCodes) : newFileCodes;
                    payload.setAssessFileCodes(fileCodes);
                }
                if (org.springframework.util.StringUtils.hasText((String)payload.getSowCacheKey())) {
                    newFileCodes = sowCacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
                    fileCodes = org.springframework.util.StringUtils.hasText((String)payload.getSowFileCodes()) ? payload.getSowFileCodes().concat(",").concat(newFileCodes) : newFileCodes;
                    payload.setSowFileCodes(fileCodes);
                }
            }
        }
        long count = this.dao.updateByKeyDynamic(payload);
        if ("SUB".equals(newEntity.getMainType())) {
            String oldPaperStatus = oldEntity.getPaperStatus();
            String newPaperStatus = newEntity.getPaperStatus();
            if (!org.springframework.util.StringUtils.hasText((String)oldPaperStatus) && org.springframework.util.StringUtils.hasText((String)newPaperStatus) || org.springframework.util.StringUtils.hasText((String)oldPaperStatus) && org.springframework.util.StringUtils.hasText((String)newPaperStatus) && !oldPaperStatus.equals(newPaperStatus)) {
                Long[] keys = new Long[]{payload.getId()};
                if (newPaperStatus.equals(SaleConContractPaperStatusEnum.BACK.getCode())) {
                    this.conFiling(keys);
                } else if (newPaperStatus.equals(SaleConContractPaperStatusEnum.UNBACK.getCode())) {
                    this.unConFiling(keys);
                }
            }
        }
        return count;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateInfoByKeyDynamic(SaleConContractPayload payload) {
        Field[] fields;
        SaleConContractDO entity = this.repo.findById(payload.getId()).orElseGet(SaleConContractDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        String name = payload.getName();
        if (org.springframework.util.StringUtils.hasText((String)name)) {
            List list;
            SaleConContractQuery query = new SaleConContractQuery();
            query.setEqName(name);
            PagingVO<SaleConContractVO> queryPaging = this.dao.queryPaging(query);
            List records = queryPaging.getRecords();
            if (!CollectionUtils.isEmpty((Collection)queryPaging.getRecords()) && !CollectionUtils.isEmpty(list = records.stream().filter(e -> !e.getId().equals(payload.getId())).collect(Collectors.toList()))) {
                throw TwException.warn("", "\u5408\u540c\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\uff01");
            }
        }
        SaleConContractDO oldEntity = new SaleConContractDO();
        Class<?> clazz = payload.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!"java.math.BigDecimal".equals(field.getType().getName())) continue;
            String fieldName = field.getName();
            String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            try {
                Method getMethod = clazz.getMethod(getMethodName, new Class[0]);
                BigDecimal value = (BigDecimal)getMethod.invoke((Object)payload, new Object[0]);
                if (value == null) continue;
                String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                Method setMethod = clazz.getDeclaredMethod(setMethodName, field.getType());
                setMethod.invoke((Object)payload, value.setScale(2));
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        SaleConContractDO saleConContractDO = SaleConContractConvert.INSTANCE.toDo(payload);
        BeanUtils.copyProperties((Object)entity, (Object)oldEntity);
        saleConContractDO.setRemark(null);
        oldEntity.setRemark(null);
        Object changeLog = this.changeFieldLogUtil.getFieldsUpdateLog(saleConContractDO, oldEntity);
        SaleConContractVO newSaleConContractVO = SaleConContractConvert.INSTANCE.toVo(saleConContractDO);
        this.udcUtil.translate(newSaleConContractVO);
        this.transfer(newSaleConContractVO);
        SaleConContractVO oldSaleConContractVO = SaleConContractConvert.INSTANCE.toVo(entity);
        this.udcUtil.translate(oldSaleConContractVO);
        this.transfer(oldSaleConContractVO);
        String saveChangeLog = this.saveChangeLog(newSaleConContractVO, oldSaleConContractVO);
        if (org.springframework.util.StringUtils.hasText((String)saveChangeLog)) {
            this.logService.saveNewLog(newSaleConContractVO.getId(), PrdSystemObjectEnum.SaleConContractChange.getCode(), saveChangeLog);
        }
        if (!Objects.equals(oldEntity.getCustFlag(), saleConContractDO.getCustFlag())) {
            changeLog = saleConContractDO.getCustFlag() == 1L ? (String)changeLog + "\u65b0\u8001\u5ba2\u6237 \u7531 \u65b0\u5ba2\u6237 \u4fee\u6539\u4e3a \u8001\u5ba2\u6237" : (String)changeLog + "\u65b0\u8001\u5ba2\u6237 \u7531 \u8001\u5ba2\u6237 \u4fee\u6539\u4e3a \u65b0\u5ba2\u6237";
        }
        this.logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.SaleConContract.getCode(), (String)changeLog);
        if ("SUB".equals(saleConContractDO.getMainType())) {
            BigDecimal newTax;
            BigDecimal oldAmt = oldEntity.getAmt() == null ? BigDecimal.ZERO : oldEntity.getAmt();
            BigDecimal newAmt = saleConContractDO.getAmt() == null ? BigDecimal.ZERO : saleConContractDO.getAmt();
            BigDecimal oldTax = oldEntity.getTaxRate() == null ? new BigDecimal("0.00") : oldEntity.getTaxRate();
            BigDecimal bigDecimal = newTax = saleConContractDO.getTaxRate() == null ? new BigDecimal("0.00") : saleConContractDO.getTaxRate();
            if (oldAmt.compareTo(newAmt) != 0 || oldTax.compareTo(newTax) != 0) {
                this.subAmtCount(payload);
            }
        }
        if (ObjectUtils.isEmpty((Object)saleConContractDO.getProductClass()) || !saleConContractDO.getProductClass().equals(oldEntity.getProductClass())) {
            List nullFields = payload.getNullFields();
            nullFields.add("productSubClassId");
            payload.setNullFields(nullFields);
        }
        String ydkFolderId = entity.getFolderId();
        if (!entity.getName().equals(payload.getName())) {
            ydkFolderId = this.reNameFolder(entity.getFolderId(), "/" + payload.getCode() + " " + name, payload.getAuthTokenByYdk());
            payload.setFolderId(ydkFolderId);
        }
        HashSet<String> allCacheKeys = new HashSet<String>();
        List<Object> cacheKeys = new ArrayList();
        List<Object> assessCacheKeys = new ArrayList();
        List<Object> sowCacheKeys = new ArrayList();
        if (org.springframework.util.StringUtils.hasText((String)payload.getCacheKey())) {
            cacheKeys = Arrays.asList(payload.getCacheKey().split(","));
            allCacheKeys.addAll(cacheKeys);
        }
        if (org.springframework.util.StringUtils.hasText((String)payload.getAssessCacheKey())) {
            assessCacheKeys = Arrays.asList(payload.getAssessCacheKey().split(","));
            allCacheKeys.addAll(assessCacheKeys);
        }
        if (org.springframework.util.StringUtils.hasText((String)payload.getSowCacheKey())) {
            sowCacheKeys = Arrays.asList(payload.getSowCacheKey().split(","));
            allCacheKeys.addAll(sowCacheKeys);
        }
        if (!CollectionUtils.isEmpty(allCacheKeys)) {
            String fileCodes;
            String newFileCodes;
            Map<String, String> cacheMap = this.saveYdkFile(ydkFolderId, allCacheKeys, payload.getAuthTokenByYdk());
            if (org.springframework.util.StringUtils.hasText((String)payload.getCacheKey())) {
                newFileCodes = cacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
                fileCodes = org.springframework.util.StringUtils.hasText((String)payload.getFileCodes()) ? payload.getFileCodes().concat(",").concat(newFileCodes) : newFileCodes;
                payload.setFileCodes(fileCodes);
            }
            if (org.springframework.util.StringUtils.hasText((String)payload.getAssessCacheKey())) {
                newFileCodes = assessCacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
                fileCodes = org.springframework.util.StringUtils.hasText((String)payload.getAssessFileCodes()) ? payload.getAssessFileCodes().concat(",").concat(newFileCodes) : newFileCodes;
                payload.setAssessFileCodes(fileCodes);
            }
            if (org.springframework.util.StringUtils.hasText((String)payload.getSowCacheKey())) {
                newFileCodes = sowCacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
                fileCodes = org.springframework.util.StringUtils.hasText((String)payload.getSowFileCodes()) ? payload.getSowFileCodes().concat(",").concat(newFileCodes) : newFileCodes;
                payload.setSowFileCodes(fileCodes);
            }
        }
        return this.dao.updateByKeyDynamic(payload);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.repo.findById(id);
                if (!optional.isEmpty()) {
                    SaleConContractDO entity = (SaleConContractDO)optional.get();
                    Long oppoId = entity.getOppoId();
                    if (org.springframework.util.StringUtils.hasText((String)entity.getMainType()) && "MAIN".equalsIgnoreCase(entity.getMainType()) && !ObjectUtils.isEmpty((Object)oppoId)) {
                        this.opportunityService.changeStatus(oppoId);
                    }
                    if (!"CREATE".equalsIgnoreCase(entity.getStatus())) {
                        throw TwException.error("", "\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u7684\u5408\u540c\u624d\u80fd\u5220\u9664");
                    }
                    Object changeLog = "";
                    if ("MAIN".equalsIgnoreCase(entity.getMainType())) {
                        changeLog = "\u5220\u9664\u4e3b\u5408\u540c";
                    } else {
                        changeLog = "\u5220\u9664\u5b50\u5408\u540c" + entity.getName();
                        this.logService.saveNewLog(entity.getParentId(), PrdSystemObjectEnum.SaleConContract.getCode(), (String)changeLog);
                    }
                    this.logService.saveNewLog(entity.getId(), PrdSystemObjectEnum.SaleConContract.getCode(), (String)changeLog);
                }
            });
            this.dao.deleteSoft(keys);
        }
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public Long active(List<Long> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return 0L;
        }
        if (keys.size() != 1) {
            throw TwException.error("", "\u5408\u540c\u8bf7\u4e00\u4e2a\u4e2a\u6fc0\u6d3b\uff01");
        }
        List conContractDOS = this.repo.findAllById(keys);
        for (SaleConContractDO conContractDO : conContractDOS) {
            String mainType = conContractDO.getMainType();
            String status = conContractDO.getStatus();
            String platType = conContractDO.getPlatType();
            if ("MAIN".equalsIgnoreCase(mainType)) {
                if ("CREATE".equalsIgnoreCase(status)) continue;
                throw TwException.error("", "\u53ea\u6709\u5904\u4e8e\u65b0\u5efa\u72b6\u6001\u7684\u4e3b\u5408\u540c\u624d\u53ef\u4ee5\u8fdb\u884c\u6fc0\u6d3b");
            }
            ArrayList<String> platTypeList = new ArrayList<String>();
            platTypeList.add("FICTITIOUS");
            platTypeList.add("NO_CONTRACT_VIRTUAL_CONTRACT");
            if (!platTypeList.contains(platType)) {
                if (!"CREATE".equalsIgnoreCase(status)) {
                    throw TwException.error("", "\u53ea\u6709\u5904\u4e8e\u65b0\u5efa\u72b6\u6001\u7684\u975e\u865a\u62df\u5b50\u5408\u540c\u624d\u53ef\u4ee5\u8fdb\u884c\u6fc0\u6d3b");
                }
            } else if (!"ACTIVE_WAITING".equalsIgnoreCase(status)) {
                throw TwException.error("", "\u53ea\u6709\u5904\u4e8e\u5f85\u6fc0\u6d3b\u72b6\u6001\u7684\u865a\u62df\u5b50\u5408\u540c\u624d\u53ef\u4ee5\u8fdb\u884c\u6fc0\u6d3b");
            }
            List conReceivablePlanVOS = this.conReceivablePlanService.queryBySaleConId(conContractDO.getId());
            if ("T&M".equals(conContractDO.getWorkType())) continue;
            if ("OPEN".equalsIgnoreCase(conContractDO.getRangeProp())) {
                if (conReceivablePlanVOS.size() > 0) continue;
                throw TwException.error("", "\u8be5\u5408\u540c\u7684\u6536\u6b3e\u8ba1\u5212\u4e3a\u7a7a");
            }
            BigDecimal planAmt = BigDecimal.ZERO;
            for (ConReceivablePlanVO conReceivablePlanVO : conReceivablePlanVOS) {
                planAmt = planAmt.add(conReceivablePlanVO.getReceAmt());
            }
            if (planAmt.compareTo(conContractDO.getAmt()) == 0) continue;
            throw TwException.error("", "\u6536\u6b3e\u8ba1\u5212\u603b\u91d1\u989d\u4e0d\u7b49\u4e8e\u5b50\u5408\u540c\u542b\u7a0e\u603b\u91d1\u989d");
        }
        SaleConContractDO conContractDO = (SaleConContractDO)conContractDOS.get(0);
        if ("MAIN".equalsIgnoreCase(conContractDO.getMainType())) {
            SaleConContractVO conContractVO = SaleConContractConvert.INSTANCE.toVo(conContractDO);
            CrmCustomerOperationPayload customerOperationPayload = this.buildCustOperationPayload(conContractVO);
            try {
                CrmCustomerOperationVO operationVO = this.crmCustomerOperationService.insert(customerOperationPayload, false);
                operationVO.setCustOperManagerName(this.cacheUtil.getUserName(operationVO.getCustOperManagerId()));
                operationVO.setSaleOperManagerName(this.cacheUtil.getUserName(operationVO.getSaleOperManagerId()));
                this.crmCustomerOperationService.fillQxbInfo(operationVO.getCustName(), operationVO.getId().longValue());
                this.crmCustomerOperationService.noticeOperManagers(operationVO, CustomerOperationNoticeEnum.COMPLETE.getCode());
            }
            catch (TwException e) {
                log.warn("\u9500\u552e\u5408\u540c\u521b\u5efa\u5ba2\u6237\u7ecf\u8425\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f is {}", e.getErrors());
            }
            return this.dao.updataStatusByIds(keys, "ACTIVE");
        }
        List conReceivablePlanVOS = this.conReceivablePlanService.queryBySaleConId(conContractDO.getId());
        if (!"T&M".equals(conContractDO.getWorkType()) && CollectionUtils.isEmpty((Collection)conReceivablePlanVOS)) {
            throw TwException.error("", "\u8bf7\u5148\u7ef4\u62a4\u6536\u6b3e\u8ba1\u5212\uff01");
        }
        this.activeProc(conContractDO);
        return 1L;
    }

    private CrmCustomerOperationPayload buildCustOperationPayload(SaleConContractVO conContractVO) {
        CrmCustomerOperationPayload payload = new CrmCustomerOperationPayload();
        BusinessPartnerVO businessPartnerVO = this.businessPartnerService.queryCustomerByBookId(conContractVO.getCustId());
        if (businessPartnerVO == null) {
            return payload;
        }
        payload.setCustType(CustomerOperationTypeEnum.ENTERPRISE.getCode());
        payload.setCustomerId(businessPartnerVO.getId());
        payload.setCustName(businessPartnerVO.getPartnerName());
        payload.setNoticeTime(LocalDateTime.now());
        payload.setSaleOperBu(conContractVO.getSaleManUserBuId());
        payload.setSaleOperManagerId(conContractVO.getSaleManUserId());
        payload.setCustOperBu(conContractVO.getDeliBuId());
        payload.setCustOperManagerId(conContractVO.getDeliUserId());
        return payload;
    }

    private void activeProc(SaleConContractDO conContract) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.INVALID.getCode();
        status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        this.dealVariables(conContract.getParentId(), conContract.getSignBuId(), conContract.getDeliUserId(), conContract.getDeliBuId(), variables);
        processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.SALE_CON_ACTIVE.name(), (String)(conContract.getName() + "-\u9500\u552e\u5b50\u5408\u540c\u6fc0\u6d3b\u5ba1\u6279\u6d41\u7a0b"), (String)("" + conContract.getId()), variables), new Long[0]);
        SaleConContractPayload payload = new SaleConContractPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(conContract.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setStatus(status);
        String closeFileCodes = conContract.getCloseFileCodes();
        if (org.springframework.util.StringUtils.hasText((String)closeFileCodes)) {
            payload.setCloseFileCodes(closeFileCodes);
        }
        this.transactionUtilService.executeWithRunnable(() -> this.dao.updateByKeyDynamic(payload));
    }

    private void dealVariables(Long parentId, Long signBuId, Long deliUserId, Long deliBuId, HashMap<String, Object> variables) {
        SaleConContractVO parentCon = this.dao.queryByKey(parentId);
        BigDecimal amt = ObjectUtils.isEmpty((Object)parentCon.getAmt()) ? BigDecimal.ZERO : parentCon.getAmt();
        Boolean amtValid = false;
        if (BigDecimal.valueOf(500000L).compareTo(amt) < 0) {
            amtValid = true;
        }
        variables.put("amtValid", amtValid);
        PrdOrgOrganizationVO orgVo = this.orgService.queryDetailSimpleByOrgId(signBuId);
        if (!ObjectUtils.isEmpty((Object)orgVo) && "BS".equals(orgVo.getOrganizationType())) {
            variables.put("isSaleBuType", true);
        } else {
            variables.put("isSaleBuType", false);
        }
        Long signBuManageUserId = this.daoOrg.queryManageIdById(signBuId);
        variables.put("Activity_17pzpxv", CollUtil.newArrayList((Object[])new Long[]{signBuManageUserId}));
        variables.put("Activity_1bffr1c", CollUtil.newArrayList((Object[])new Long[]{deliUserId}));
        Long deliBuManageUserId = this.daoOrg.queryManageIdById(deliBuId);
        variables.put("Activity_0fgh8bp", CollUtil.newArrayList((Object[])new Long[]{deliBuManageUserId}));
        List finCheckUserIds = this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_FIN_CHECK.getCode());
        variables.put("Activity_1l293u9", CollUtil.newArrayList((Collection)finCheckUserIds));
        List cfo = this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_CFO.getCode());
        variables.put("Activity_15291u6", cfo);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long pending(List<Long> keys) {
        List conContractDOS = this.repo.findAllById(keys);
        for (SaleConContractDO conContractDO : conContractDOS) {
            if ("ACTIVE".equalsIgnoreCase(conContractDO.getStatus())) continue;
            throw TwException.error("", "\u6fc0\u6d3b\u7684\u5408\u540c\u624d\u53ef\u4ee5\u8fdb\u884c\u6682\u6302");
        }
        return this.dao.updataStatusByIds(keys, "PENDING");
    }

    @Transactional(rollbackFor={Exception.class})
    public Long closeWithWorkFlow(List<Long> keys, String closeCacheKey, String anthToken) {
        if (CollectionUtils.isEmpty(keys)) {
            return 0L;
        }
        if (keys.size() != 1) {
            throw TwException.error("", "\u5408\u540c\u8bf7\u4e00\u4e2a\u4e2a\u5173\u95ed\uff01");
        }
        Long key = keys.get(0);
        SaleConContractVO saleConContractVO = this.queryByKey(key, new Boolean[0]);
        if (SaleConEnum.OPEN.getCode().equalsIgnoreCase(saleConContractVO.getRangeProp())) {
            SaleConContractPayload payload = new SaleConContractPayload();
            payload.setId(saleConContractVO.getId());
            payload.setStatus("CLOSE");
            payload.setCloseDate(LocalDate.now());
            payload.setCloseReason("\u6b63\u5e38\u5173\u95ed");
            this.dao.updateByKeyDynamic(payload);
            return 1L;
        }
        if (!"ACTIVE".equalsIgnoreCase(saleConContractVO.getStatus())) {
            throw TwException.error("", "\u6fc0\u6d3b\u7684\u5408\u540c\u624d\u53ef\u4ee5\u8fdb\u884c\u5173\u95ed");
        }
        if (ObjectUtils.isEmpty((Object)saleConContractVO.getParentId())) {
            List<SaleConContractVO> subSaleConContractVOS = this.queryListByConId(key);
            List<String> stringList = Arrays.asList("INVALID", "CLOSE");
            List collect = subSaleConContractVOS.stream().filter(e -> !stringList.contains(e.getStatus())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                throw TwException.error("", "\u8bf7\u5148\u5173\u95ed\u6240\u6709\u5b50\u5408\u540c\uff0c\u518d\u5173\u95ed\u4e3b\u5408\u540c\uff01");
            }
            SaleConContractPayload payload = new SaleConContractPayload();
            payload.setId(saleConContractVO.getId());
            payload.setStatus("CLOSE");
            payload.setCloseDate(LocalDate.now());
            payload.setCloseReason("normal");
            this.dao.updateByKeyDynamic(payload);
        } else {
            String closeFileCode = "";
            if (org.springframework.util.StringUtils.hasText((String)closeCacheKey)) {
                String folderId = saleConContractVO.getFolderId();
                if (!org.springframework.util.StringUtils.hasText((String)folderId)) {
                    throw TwException.error("", "\u6613\u9053\u58f3\u9644\u4ef6\u6ca1\u6709\u6587\u4ef6\u5939\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u521b\u5efa\u6587\u4ef6\u5939\uff01");
                }
                List<String> cacheKeys = Arrays.asList(closeCacheKey.split(","));
                Map<String, String> cacheMap = this.saveYdkFile(folderId, new HashSet<String>(cacheKeys), anthToken);
                closeFileCode = cacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
            }
            String paperStatus = saleConContractVO.getPaperStatus();
            BigDecimal AmountCollected = this.amountOfMoney(saleConContractVO.getId()).get("AmountCollected");
            if ("BACK".equalsIgnoreCase(paperStatus) && AmountCollected.compareTo(saleConContractVO.getAmt()) == 0) {
                SaleConContractPayload payload = new SaleConContractPayload();
                payload.setId(saleConContractVO.getId());
                payload.setStatus("CLOSE");
                payload.setCloseDate(LocalDate.now());
                payload.setCloseReason("normal");
                this.dao.updateByKeyDynamic(payload);
            } else {
                if (org.springframework.util.StringUtils.hasText((String)closeFileCode)) {
                    saleConContractVO.setCloseFileCodes(closeFileCode);
                }
                this.closeProc(saleConContractVO);
            }
        }
        return 1L;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long close(List<Long> keys, String closeCacheKey, String anthToken) {
        if (CollectionUtils.isEmpty(keys)) {
            return 0L;
        }
        if (keys.size() != 1) {
            throw TwException.error("", "\u5408\u540c\u8bf7\u4e00\u4e2a\u4e2a\u5173\u95ed\uff01");
        }
        Long key = keys.get(0);
        SaleConContractVO saleConContractVO = this.queryByKey(key, new Boolean[0]);
        if (SaleConEnum.OPEN.getCode().equalsIgnoreCase(saleConContractVO.getRangeProp())) {
            SaleConContractPayload payload = new SaleConContractPayload();
            payload.setId(saleConContractVO.getId());
            payload.setStatus("CLOSE");
            payload.setCloseDate(LocalDate.now());
            payload.setCloseReason("\u6b63\u5e38\u5173\u95ed");
            this.dao.updateByKeyDynamic(payload);
            return 1L;
        }
        if (!"ACTIVE".equalsIgnoreCase(saleConContractVO.getStatus())) {
            throw TwException.error("", "\u6fc0\u6d3b\u7684\u5408\u540c\u624d\u53ef\u4ee5\u8fdb\u884c\u5173\u95ed");
        }
        if (ObjectUtils.isEmpty((Object)saleConContractVO.getParentId())) {
            List<SaleConContractVO> subSaleConContractVOS = this.queryListByConId(key);
            List<String> stringList = Arrays.asList("INVALID", "CLOSE");
            List collect = subSaleConContractVOS.stream().filter(e -> !stringList.contains(e.getStatus())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                throw TwException.error("", "\u8bf7\u5148\u5173\u95ed\u6240\u6709\u5b50\u5408\u540c\uff0c\u518d\u5173\u95ed\u4e3b\u5408\u540c\uff01");
            }
            SaleConContractPayload payload = new SaleConContractPayload();
            payload.setId(saleConContractVO.getId());
            payload.setStatus("CLOSE");
            payload.setCloseDate(LocalDate.now());
            payload.setCloseReason("normal");
            this.dao.updateByKeyDynamic(payload);
        } else {
            String closeFileCode = "";
            if (org.springframework.util.StringUtils.hasText((String)closeCacheKey)) {
                String folderId = saleConContractVO.getFolderId();
                if (!org.springframework.util.StringUtils.hasText((String)folderId)) {
                    throw TwException.error("", "\u6613\u9053\u58f3\u9644\u4ef6\u6ca1\u6709\u6587\u4ef6\u5939\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u521b\u5efa\u6587\u4ef6\u5939\uff01");
                }
                List<String> cacheKeys = Arrays.asList(closeCacheKey.split(","));
                Map<String, String> cacheMap = this.saveYdkFile(folderId, new HashSet<String>(cacheKeys), anthToken);
                closeFileCode = cacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
            }
            String paperStatus = saleConContractVO.getPaperStatus();
            BigDecimal AmountCollected = this.amountOfMoney(saleConContractVO.getId()).get("AmountCollected");
            if ("BACK".equalsIgnoreCase(paperStatus) && AmountCollected.compareTo(saleConContractVO.getAmt()) == 0) {
                payload = new SaleConContractPayload();
                payload.setId(saleConContractVO.getId());
                payload.setStatus("CLOSE");
                payload.setCloseDate(LocalDate.now());
                payload.setCloseReason("normal");
                this.dao.updateByKeyDynamic(payload);
            } else {
                if (org.springframework.util.StringUtils.hasText((String)closeFileCode)) {
                    saleConContractVO.setCloseFileCodes(closeFileCode);
                }
                payload = new SaleConContractPayload();
                payload.setId(saleConContractVO.getId());
                payload.setStatus("CLOSE");
                payload.setCloseDate(LocalDate.now());
                payload.setCloseReason("abnormal");
                String closeFileCodes = saleConContractVO.getCloseFileCodes();
                if (org.springframework.util.StringUtils.hasText((String)closeFileCodes)) {
                    payload.setCloseFileCodes(closeFileCodes);
                }
                this.dao.updateByKeyDynamic(payload);
            }
        }
        return 1L;
    }

    private void closeProc(SaleConContractVO conContractVO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.INVALID.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
            Long loginUserId = GlobalUtil.getLoginUserId();
            boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
            if (isSystemAdmin) {
                variables.put("isFinPic", true);
            } else {
                List<Long> userIdsByRole1;
                List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), "FIN_PIC"));
                if (!CollectionUtils.isEmpty(userIdsByRole) && userIdsByRole.contains(loginUserId)) {
                    variables.put("isFinPic", true);
                }
                if (!CollectionUtils.isEmpty(userIdsByRole1 = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), "BUSINESS_MANAGER"))) && userIdsByRole1.contains(loginUserId)) {
                    variables.put("isFinPic", false);
                }
            }
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.SALE_CON_CLOSE.name(), (String)(conContractVO.getName() + "-\u9500\u552e\u5b50\u5408\u540c\u5173\u95ed\u5ba1\u6279\u6d41\u7a0b"), (String)("" + conContractVO.getId()), variables), new Long[0]);
        }
        SaleConContractPayload payload = new SaleConContractPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(conContractVO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setStatus(status);
        String closeFileCodes = conContractVO.getCloseFileCodes();
        if (org.springframework.util.StringUtils.hasText((String)closeFileCodes)) {
            payload.setCloseFileCodes(closeFileCodes);
        }
        this.transactionUtilService.executeWithRunnable(() -> this.dao.updateByKeyDynamic(payload));
    }

    @Transactional(rollbackFor={Exception.class})
    public void invalidWithWorkFlow(List<Long> keys) {
        List conContractDOS = this.repo.findAllById(keys);
        for (SaleConContractDO conContractDO : conContractDOS) {
            String status = conContractDO.getStatus();
            String mainType = conContractDO.getMainType();
            if ("MAIN".equalsIgnoreCase(mainType)) {
                if (!"ACTIVE".equalsIgnoreCase(status)) {
                    throw TwException.error("", "\u6fc0\u6d3b\u7684\u4e3b\u5408\u540c\u624d\u53ef\u4f5c\u5e9f\uff01");
                }
                List<SaleConContractVO> subList = this.queryListByConId(conContractDO.getId());
                for (SaleConContractVO subConVO : subList) {
                    if ("INVALID".equalsIgnoreCase(subConVO.getStatus())) continue;
                    throw TwException.error("", "\u6240\u6709\u4e3b\u5408\u540c\u7684\u5b50\u5408\u540c\u90fd\u4f5c\u5e9f\uff0c\u624d\u53ef\u4f5c\u5e9f\u4e3b\u5408\u540c\uff01");
                }
                this.dao.updataStatusByIds(Collections.singletonList(conContractDO.getId()), "INVALID");
                continue;
            }
            if (!"ACTIVE".equalsIgnoreCase(status)) {
                throw TwException.error("", "\u8be5\u5b50\u5408\u540c\u4e0d\u6ee1\u8db3\u4f5c\u5e9f\u6761\u4ef6\uff0c\u4e0d\u80fd\u4f5c\u5e9f\uff01");
            }
            this.invalidProc(conContractDO);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void invalid(List<Long> keys) {
        List conContractDOS = this.repo.findAllById(keys);
        for (SaleConContractDO conContractDO : conContractDOS) {
            String status = conContractDO.getStatus();
            String mainType = conContractDO.getMainType();
            if ("MAIN".equalsIgnoreCase(mainType)) {
                if (!"ACTIVE".equalsIgnoreCase(status)) {
                    throw TwException.error("", "\u6fc0\u6d3b\u7684\u4e3b\u5408\u540c\u624d\u53ef\u4f5c\u5e9f\uff01");
                }
                List<SaleConContractVO> subList = this.queryListByConId(conContractDO.getId());
                for (SaleConContractVO subConVO : subList) {
                    if ("INVALID".equalsIgnoreCase(subConVO.getStatus())) continue;
                    throw TwException.error("", "\u6240\u6709\u4e3b\u5408\u540c\u7684\u5b50\u5408\u540c\u90fd\u4f5c\u5e9f\uff0c\u624d\u53ef\u4f5c\u5e9f\u4e3b\u5408\u540c\uff01");
                }
                this.dao.updataStatusByIds(Collections.singletonList(conContractDO.getId()), "INVALID");
                continue;
            }
            if (!"ACTIVE".equalsIgnoreCase(status)) {
                throw TwException.error("", "\u8be5\u5b50\u5408\u540c\u4e0d\u6ee1\u8db3\u4f5c\u5e9f\u6761\u4ef6\uff0c\u4e0d\u80fd\u4f5c\u5e9f\uff01");
            }
            this.dao.updataStatusByIds(Collections.singletonList(conContractDO.getId()), WorkFlowStatusEnum.INVALID.getCode());
        }
    }

    public void change(SaleConContractPayload payload) {
        SaleConContractVO saleConContractVO = this.queryByKey(payload.getId(), new Boolean[0]);
        if (saleConContractVO.getChangeFlag() != null && saleConContractVO.getChangeFlag() == 1) {
            throw TwException.error("", "\u53d8\u66f4\u4e2d\u7684\u5b50\u5408\u540c\u4e0d\u80fd\u518d\u6b21\u53d1\u8d77\u53d8\u66f4");
        }
        if ("MAIN".equalsIgnoreCase(saleConContractVO.getMainType())) {
            throw TwException.error("", "\u53ea\u6709\u5b50\u5408\u540c\u624d\u80fd\u8fdb\u884c\u53d8\u66f4");
        }
        if (!"ACTIVE".equalsIgnoreCase(saleConContractVO.getStatus())) {
            throw TwException.error("", "\u6fc0\u6d3b\u7684\u5b50\u5408\u540c\u624d\u53ef\u53d8\u66f4\uff01");
        }
        saleConContractVO = (SaleConContractVO)this.udcUtil.translate(saleConContractVO);
        SaleConContractVO newSaleConContractVO = new SaleConContractVO();
        BeanCopyUtil.beanCopy((Object)saleConContractVO, (Object)newSaleConContractVO);
        this.buildNewContract(newSaleConContractVO, payload);
        newSaleConContractVO = (SaleConContractVO)this.udcUtil.translate(newSaleConContractVO);
        Long saveId = this.changeService.save(ChangeTypeEnum.SALE_CON_CHANGE.getCode(), (Object)saleConContractVO, (Object)newSaleConContractVO, "" + payload.getId());
        ProcessInfo processInfo = this.startChangeWorkFlow(saleConContractVO, saveId);
        int changeFlag = 1;
        String changeStatus = WorkFlowStatusEnum.APPROVING_WORK.getCode();
        if (processInfo.getProcInstStatus().name().equals(ProcInstStatus.APPROVED.name())) {
            changeFlag = 0;
            changeStatus = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        }
        SaleConContractPayload payload0 = new SaleConContractPayload();
        payload0.setId(payload.getId());
        payload0.setChangeFlag(Integer.valueOf(changeFlag));
        ComChangePayload changePayload = new ComChangePayload();
        changePayload.setId(saveId);
        changePayload.setApprProcInstId(processInfo.getProcInstId());
        changePayload.setApprStatus(processInfo.getProcInstStatus().name());
        changePayload.setChangeStatus(changeStatus);
        this.transactionUtilService.executeWithRunnable(() -> {
            this.dao.updateByKeyDynamic(payload0);
            this.changeService.updateWorkFlow(changePayload);
        });
    }

    @Transactional
    public void updateChange(SaleConContractPayload payload) {
        SaleConContractVO saleConContractVO = this.queryByKey(payload.getId(), new Boolean[0]);
        saleConContractVO = (SaleConContractVO)this.udcUtil.translate(saleConContractVO);
        SaleConContractVO newSaleConContractVO = new SaleConContractVO();
        BeanCopyUtil.beanCopy((Object)saleConContractVO, (Object)newSaleConContractVO);
        this.buildNewContract(newSaleConContractVO, payload);
        newSaleConContractVO = (SaleConContractVO)this.udcUtil.translate(newSaleConContractVO);
        ComChangeVO comChangeVO = this.changeService.queryByKey(payload.getChangeBusinesskey());
        if (!ObjectUtils.isEmpty((Object)comChangeVO)) {
            Long saveId = comChangeVO.getId();
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setId(saveId);
            changePayload.setChangeContent(JSONObject.toJSONString((Object)newSaleConContractVO));
            this.changeService.updateByKeyDynamic(changePayload);
        }
    }

    public SaleConContractVO queryChangeDetail(Long businessKey) {
        if (businessKey != null) {
            ComChangeVO comChangeVO = this.changeService.queryByKey(businessKey);
            String changeContent = comChangeVO.getChangeContent();
            if (StringUtils.isEmpty((CharSequence)changeContent)) {
                throw TwException.error("", "\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            SaleConContractVO saleConContractVO = (SaleConContractVO)JSONObject.parseObject((String)changeContent, SaleConContractVO.class);
            return saleConContractVO;
        }
        return null;
    }

    private void buildNewContract(SaleConContractVO newSaleConContractVO, SaleConContractPayload payload) {
        if (payload.getOuBookId() != null) {
            newSaleConContractVO.setOuBookId(payload.getOuBookId());
            newSaleConContractVO.setOuName(this.cacheUtil.getCompanyNameByBookId(payload.getOuBookId()));
        }
        if (payload.getCustId() != null) {
            newSaleConContractVO.setCustId(payload.getCustId());
            newSaleConContractVO.setCustName(this.cacheUtil.getCompanyNameByBookId(payload.getCustId()));
        }
        if (org.springframework.util.StringUtils.hasText((String)payload.getWorkType())) {
            newSaleConContractVO.setWorkType(payload.getWorkType());
        }
        if (payload.getDeliBuId() != null) {
            newSaleConContractVO.setDeliBuId(payload.getDeliBuId());
        }
        if (org.springframework.util.StringUtils.hasText((String)payload.getProductClass())) {
            newSaleConContractVO.setProductClass(payload.getProductClass());
        }
        if (org.springframework.util.StringUtils.hasText((String)payload.getProductSubClass())) {
            newSaleConContractVO.setProductSubClass(payload.getProductSubClass());
        }
        if (payload.getSignDate() != null) {
            newSaleConContractVO.setSignDate(payload.getSignDate());
        }
        if (payload.getStartDate() != null) {
            newSaleConContractVO.setStartDate(payload.getStartDate());
        }
        if (payload.getEndDate() != null) {
            newSaleConContractVO.setEndDate(payload.getEndDate());
        }
        if (payload.getAmt() != null || payload.getTaxRate() != null) {
            BigDecimal newTax;
            BigDecimal oldAmt = newSaleConContractVO.getAmt() == null ? BigDecimal.ZERO : newSaleConContractVO.getAmt();
            BigDecimal newAmt = payload.getAmt() == null ? BigDecimal.ZERO : payload.getAmt();
            BigDecimal oldTax = newSaleConContractVO.getTaxRate() == null ? new BigDecimal("0.00") : newSaleConContractVO.getTaxRate();
            BigDecimal bigDecimal = newTax = payload.getTaxRate() == null ? new BigDecimal("0.00") : payload.getTaxRate();
            if (oldAmt.compareTo(newAmt) != 0 || oldTax.compareTo(newTax) != 0) {
                this.subAmtCount(payload);
                newSaleConContractVO.setAmt(payload.getAmt());
                newSaleConContractVO.setTaxRate(payload.getTaxRate());
                newSaleConContractVO.setExtraAmt(payload.getExtraAmt());
                newSaleConContractVO.setEffectiveAmt(payload.getEffectiveAmt());
                newSaleConContractVO.setDemandTotalAmt(payload.getDemandTotalAmt());
                BigDecimal amt = newSaleConContractVO.getAmt() == null ? BigDecimal.ZERO : newSaleConContractVO.getAmt();
                BigDecimal taxRate = newSaleConContractVO.getTaxRate() == null ? BigDecimal.ZERO : newSaleConContractVO.getTaxRate();
                BigDecimal notTaxAmt = amt.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
                newSaleConContractVO.setNotTaxAmt(notTaxAmt);
            }
        }
        this.transfer(newSaleConContractVO);
    }

    private ProcessInfo startChangeWorkFlow(SaleConContractVO saleConContractVO, Long saveId) {
        HashMap<String, ArrayList> batchMap = new HashMap<String, ArrayList>();
        PrdOrgOrganizationVO org = this.cacheUtil.getOrg(saleConContractVO.getDeliBuId());
        batchMap.put("Activity_144ixvi", Lists.newArrayList((Object[])new Long[]{org.getManageId()}));
        List userIds = this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_FIN_CHECK.getCode());
        if (ObjectUtils.isEmpty((Object)userIds)) {
            throw TwException.error("", "\u5e73\u53f0\u603b\u8d26\u4f1a\u8ba1\u89d2\u8272\u4eba\u5458\u4e0d\u5b58\u5728");
        }
        batchMap.put("Activity_16kw0qx", Lists.newArrayList((Iterable)userIds));
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.SALE_CON_CHANGE.name(), (String)("\u5b50\u5408\u540c\u53d8\u66f4\u5ba1\u6279-" + saleConContractVO.getName()), (String)("" + saveId), batchMap), new Long[0]);
        return processInfo;
    }

    @Transactional
    public void updateWorkFlow(SaleConContractVO saleConContractVO) {
        SaleConContractPayload saleConContractPayload = SaleConContractConvert.INSTANCE.toPayload(saleConContractVO);
        SaleConContractVO oldContractVO = this.queryByKey(saleConContractVO.getId(), new Boolean[0]);
        if (saleConContractVO.getApproveFlag() != null && saleConContractVO.getApproveFlag().booleanValue()) {
            this.saveChangeLog(saleConContractVO, oldContractVO);
        }
        this.dao.updateByKeyDynamic(saleConContractPayload);
    }

    private String saveChangeLog(SaleConContractVO newSaleConContractVO, SaleConContractVO oldContractVO) {
        String newCompanyName;
        String oldCompanyName;
        StringBuilder stringBuilder = new StringBuilder();
        if (newSaleConContractVO.getOuBookId() != null && !newSaleConContractVO.getOuBookId().equals(oldContractVO.getOuBookId())) {
            oldCompanyName = this.cacheUtil.getCompanyNameByBookId(oldContractVO.getOuBookId());
            newCompanyName = this.cacheUtil.getCompanyNameByBookId(newSaleConContractVO.getOuBookId());
            stringBuilder.append("\u7b7e\u7ea6\u516c\u53f8\u7531" + oldCompanyName + " \u53d8\u66f4\u4e3a " + newCompanyName);
        }
        if (newSaleConContractVO.getCustId() != null && !newSaleConContractVO.getCustId().equals(oldContractVO.getCustId())) {
            oldCompanyName = this.cacheUtil.getCompanyNameByBookId(oldContractVO.getCustId());
            newCompanyName = this.cacheUtil.getCompanyNameByBookId(newSaleConContractVO.getCustId());
            stringBuilder.append("\u5ba2\u6237\u540d\u79f0\u7531" + oldCompanyName + " \u53d8\u66f4\u4e3a " + newCompanyName);
        }
        if (org.springframework.util.StringUtils.hasText((String)newSaleConContractVO.getWorkType()) && !newSaleConContractVO.getWorkType().equals(oldContractVO.getWorkType())) {
            stringBuilder.append("\u5de5\u4f5c\u7c7b\u578b\u7531" + oldContractVO.getWorkTypeDesc() + " \u53d8\u66f4\u4e3a " + newSaleConContractVO.getWorkTypeDesc());
        }
        if (newSaleConContractVO.getDeliBuId() != null && !newSaleConContractVO.getDeliBuId().equals(oldContractVO.getDeliBuId())) {
            stringBuilder.append("\u4ea4\u4ed8bu\u7531" + oldContractVO.getDeliBuName() + " \u53d8\u66f4\u4e3a " + newSaleConContractVO.getDeliBuName());
        }
        if (org.springframework.util.StringUtils.hasText((String)newSaleConContractVO.getProductClass()) && !newSaleConContractVO.getProductClass().equals(oldContractVO.getProductClass())) {
            stringBuilder.append("\u9500\u552e\u5927\u7c7b\u7531" + oldContractVO.getProductClassDesc() + " \u53d8\u66f4\u4e3a " + newSaleConContractVO.getProductClassDesc());
        }
        if (!oldContractVO.getProductSubClass().equals(newSaleConContractVO.getProductSubClass())) {
            stringBuilder.append("\u9500\u552e\u5c0f\u7c7b\u7531" + oldContractVO.getProductSubClassDesc() + " \u53d8\u66f4\u4e3a " + newSaleConContractVO.getProductSubClassDesc());
        }
        if (newSaleConContractVO.getSignDate() != null && !newSaleConContractVO.getSignDate().equals(oldContractVO.getSignDate())) {
            stringBuilder.append("\u7b7e\u8ba2\u65e5\u671f\u7531" + oldContractVO.getSignDate() + " \u53d8\u66f4\u4e3a " + newSaleConContractVO.getSignDate());
        }
        if (newSaleConContractVO.getStartDate() != null && !newSaleConContractVO.getStartDate().equals(oldContractVO.getStartDate())) {
            stringBuilder.append("\u5408\u540c\u5f00\u59cb\u65e5\u671f\u7531" + oldContractVO.getStartDate() + " \u53d8\u66f4\u4e3a " + newSaleConContractVO.getStartDate());
        }
        if (newSaleConContractVO.getEndDate() != null && !newSaleConContractVO.getEndDate().equals(oldContractVO.getEndDate())) {
            stringBuilder.append("\u5408\u540c\u7ed3\u675f\u65e5\u671f\u7531" + oldContractVO.getEndDate() + " \u53d8\u66f4\u4e3a " + newSaleConContractVO.getEndDate());
        }
        if (newSaleConContractVO.getAmt() != null || newSaleConContractVO.getTaxRate() != null) {
            BigDecimal newTax;
            BigDecimal oldAmt = oldContractVO.getAmt() == null ? BigDecimal.ZERO : oldContractVO.getAmt();
            BigDecimal newAmt = newSaleConContractVO.getAmt() == null ? BigDecimal.ZERO : newSaleConContractVO.getAmt();
            BigDecimal oldTax = oldContractVO.getTaxRate() == null ? new BigDecimal("0.00") : oldContractVO.getTaxRate();
            BigDecimal bigDecimal = newTax = newSaleConContractVO.getTaxRate() == null ? new BigDecimal("0.00") : newSaleConContractVO.getTaxRate();
            if (oldAmt.compareTo(newAmt) != 0) {
                stringBuilder.append("\u5408\u540c\u91d1\u989d\u7531" + oldAmt + " \u53d8\u66f4\u4e3a " + newAmt);
            }
            if (oldTax.compareTo(newTax) != 0) {
                stringBuilder.append("\u5408\u540c\u7a0e\u7387\u7531" + oldContractVO.getTaxRateDesc() + " \u53d8\u66f4\u4e3a " + newSaleConContractVO.getTaxRateDesc());
            }
        }
        return stringBuilder.toString();
    }

    private void invalidProc(SaleConContractDO conContractDO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.INVALID.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
            Long loginUserId = GlobalUtil.getLoginUserId();
            boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
            if (isSystemAdmin) {
                variables.put("isFinPic", false);
            } else {
                List<Long> userIdsByRole1;
                List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(List.of("FIN_PIC"));
                if (!CollectionUtils.isEmpty(userIdsByRole) && userIdsByRole.contains(loginUserId)) {
                    variables.put("isFinPic", true);
                }
                if (!CollectionUtils.isEmpty(userIdsByRole1 = this.systemRoleDAO.queryUserIdByRoleCodes(List.of("BUSINESS_MANAGER"))) && userIdsByRole1.contains(loginUserId)) {
                    variables.put("isFinPic", false);
                }
            }
            String str = "-\u9500\u552e\u5408\u540c\u4f5c\u5e9f\u6d41\u7a0b";
            str = "MAIN".equalsIgnoreCase(conContractDO.getMainType()) ? "-\u9500\u552e\u4e3b\u5408\u540c\u4f5c\u5e9f\u6d41\u7a0b" : "-\u9500\u552e\u5b50\u5408\u540c\u4f5c\u5e9f\u6d41\u7a0b";
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.SALE_CON_INVALID.name(), (String)(conContractDO.getName() + str), (String)("" + conContractDO.getId()), variables), new Long[0]);
        }
        SaleConContractPayload payload = new SaleConContractPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(conContractDO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setStatus(status);
        this.transactionUtilService.executeWithRunnable(() -> this.dao.updateByKeyDynamic(payload));
    }

    public List<SaleConContractVO> queryListByConId(Long parentId) {
        List<SaleConContractVO> voList = this.dao.queryListByConId(parentId);
        return voList;
    }

    public List<PrdSystemLogVO> queryLogList(Long key) {
        return this.logService.queryLogList(key, PrdSystemObjectEnum.SaleConContract.getCode());
    }

    public String subCode(Long parentId) {
        SaleConContractVO mainCon = this.dao.queryByKey(parentId);
        List<SaleConContractDO> subCons = this.repo.findByParentId(parentId);
        String subCode = mainCon.getName() + "-" + (subCons.size() + 1);
        return subCode;
    }

    public void downloadSaleCon(HttpServletResponse response, SaleConContractQuery query) {
        try {
            query.setSize(Integer.valueOf(9999));
            log.info("=============================\u5f00\u59cb\u67e5\u8be2=======================================");
            PagingVO<SaleConContractVO> paging = this.paging(query);
            log.info("=============================\u7ed3\u675f\u67e5\u8be2=======================================");
            List records = paging.getRecords();
            Iterator iterator = records.iterator();
            while (iterator.hasNext()) {
                SaleConContractVO record;
                record.setStartDateStr((record = (SaleConContractVO)iterator.next()).getStartDate() == null ? "" : record.getStartDate().toString());
                record.setEndDateStr(record.getEndDate() == null ? "" : record.getEndDate().toString());
            }
            this.download(this.udcUtil.translateList(records), response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void transfer(SaleConContractVO vo) {
        String main = vo.getProductClass();
        String sub = vo.getProductSubClass();
        if (!ObjectUtils.isEmpty((Object)main) || !ObjectUtils.isEmpty((Object)sub)) {
            switch (main) {
                case "04": {
                    vo.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.ImpServiceCore.getCode(), sub));
                    break;
                }
                case "40": {
                    vo.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.PeopleDayService.getCode(), sub));
                    break;
                }
                case "05": {
                    vo.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.OperServiceCore.getCode(), sub));
                    break;
                }
                case "22": {
                    vo.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SoftwareHardwareTrade.getCode(), sub));
                    break;
                }
                case "23": {
                    vo.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SoftwareTradeCore.getCode(), sub));
                    break;
                }
                case "50": {
                    vo.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.DevelopSoftware.getCode(), sub));
                    break;
                }
                case "02": {
                    vo.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SoftwareMACore.getCode(), sub));
                    break;
                }
                case "11": {
                    vo.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.ServiceTradeCore.getCode(), sub));
                    break;
                }
                case "06": {
                    vo.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.ConsultingCore.getCode(), sub));
                    break;
                }
                case "01": {
                    vo.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.DSCore.getCode(), sub));
                    break;
                }
                case "21": {
                    vo.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.ServiceTrade.getCode(), sub));
                    break;
                }
                case "03": {
                    vo.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.HardwareTradeCore.getCode(), sub));
                    break;
                }
                case "07": {
                    vo.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CloudCore.getCode(), sub));
                    break;
                }
                case "24": {
                    vo.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CloudTrade.getCode(), sub));
                }
            }
        }
    }

    public Map<String, BigDecimal> extraAndDemandTotalAmt(Long conId) {
        List dVos;
        ConPurchaseDemandVO conPurchaseDemandVO;
        List conEpibolyCostConDVOS;
        BigDecimal ExtraAmt = BigDecimal.ZERO;
        BigDecimal DemandTotalAmt = BigDecimal.ZERO;
        ConEpibolyCostConVO conEpibolyCostConVO = this.costConService.queryByContractId(conId);
        if (conEpibolyCostConVO != null && !CollectionUtils.isEmpty((Collection)(conEpibolyCostConDVOS = conEpibolyCostConVO.getConEpibolyCostConDVOS()))) {
            ExtraAmt = ((ConEpibolyCostConDVO)conEpibolyCostConDVOS.get(0)).getAmt();
        }
        if (ExtraAmt == null) {
            ExtraAmt = BigDecimal.ZERO;
        }
        if ((conPurchaseDemandVO = this.demandService.queryBySaleConId(conId)) != null && !ObjectUtils.isEmpty((Object)(dVos = this.demandDService.queryByPurDemandId(conPurchaseDemandVO.getId())))) {
            for (ConPurchaseDemandDVO item : dVos) {
                if (item.getNotTaxAmt() == null) continue;
                DemandTotalAmt = DemandTotalAmt.add(item.getNotTaxAmt());
            }
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put("ExtraAmt", ExtraAmt);
        map.put("DemandTotalAmt", DemandTotalAmt);
        return map;
    }

    private Map<String, BigDecimal> extraAndDemandTotalAmtDib(Long conId) {
        List dVos;
        BigDecimal totalAmt = BigDecimal.ZERO;
        ConPurchaseDemandVO conPurchaseDemandVO = this.demandService.queryBySaleConId(conId);
        if (conPurchaseDemandVO != null && !ObjectUtils.isEmpty((Object)(dVos = this.demandDService.queryByPurDemandId(conPurchaseDemandVO.getId())))) {
            for (ConPurchaseDemandDVO item : dVos) {
                if (item.getNotTaxAmt() == null || !item.getDemandType().equals(PurchaseDemandTypeEnum.PURCHASING_AGENT.getCode())) continue;
                totalAmt = totalAmt.add(item.getNotTaxAmt());
            }
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put(PurchaseDemandTypeEnum.PURCHASING_AGENT.getCode(), totalAmt);
        return map;
    }

    public Map<String, BigDecimal> amountOfMoney(Long conId) {
        BigDecimal InvoicingAmount = BigDecimal.ZERO;
        BigDecimal AmountCollected = BigDecimal.ZERO;
        List conReceivablePlanVOS = this.conReceivablePlanService.queryBySaleConId(conId);
        for (ConReceivablePlanVO conReceivablePlanVO : conReceivablePlanVOS) {
            AmountCollected = conReceivablePlanVO.getActualRecvAmt() != null ? AmountCollected.add(conReceivablePlanVO.getActualRecvAmt()) : AmountCollected;
            InvoicingAmount = conReceivablePlanVO.getAlreadyInvAmt() != null ? InvoicingAmount.add(conReceivablePlanVO.getAlreadyInvAmt()) : InvoicingAmount;
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put("InvoicingAmount", InvoicingAmount);
        map.put("AmountCollected", AmountCollected);
        return map;
    }

    private Map<String, BigDecimal> amountOfMoney(Long conId, String mainType) {
        BigDecimal InvoicingAmount = BigDecimal.ZERO;
        BigDecimal AmountCollected = BigDecimal.ZERO;
        List<SaleConContractVO> voList = this.queryListByConId(conId);
        for (SaleConContractVO saleConContractVO : voList) {
            Map<String, BigDecimal> map = this.amountOfMoney(saleConContractVO.getId());
            InvoicingAmount = map.get("InvoicingAmount").add(InvoicingAmount);
            AmountCollected = map.get("AmountCollected").add(AmountCollected);
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put("InvoicingAmount", InvoicingAmount);
        map.put("AmountCollected", AmountCollected);
        return map;
    }

    public SaleConContractPayload subAmtCount(SaleConContractPayload payload) {
        if ("SUB".equalsIgnoreCase(payload.getMainType())) {
            Map<String, BigDecimal> map = this.extraAndDemandTotalAmt(payload.getId());
            BigDecimal extraAmt = map.get("ExtraAmt");
            payload.setExtraAmt(extraAmt);
            BigDecimal demandTotalAmt = map.get("DemandTotalAmt");
            BigDecimal amt = payload.getAmt() == null ? BigDecimal.ZERO : payload.getAmt();
            BigDecimal taxRate = payload.getTaxRate() == null ? BigDecimal.ZERO : payload.getTaxRate();
            BigDecimal notTaxAmt = amt.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
            payload.setDemandTotalAmt(demandTotalAmt);
            Map<String, BigDecimal> stringBigDecimalMap = this.extraAndDemandTotalAmtDib(payload.getId());
            BigDecimal purchasingAgent = stringBigDecimalMap.get(PurchaseDemandTypeEnum.PURCHASING_AGENT.getCode());
            BigDecimal agentAmt = payload.getAgentAmt() == null ? BigDecimal.ZERO : payload.getAgentAmt();
            BigDecimal effectiveAmt = notTaxAmt.subtract(agentAmt).subtract(purchasingAgent);
            payload.setEffectiveAmt(effectiveAmt);
        }
        return payload;
    }

    @Transactional
    public Long conFiling(Long[] keys) {
        Arrays.stream(keys).forEach(key -> {
            SaleConContractVO vo = this.dao.queryByKey((Long)key);
            if (vo.getFilingFlag() != null && vo.getFilingFlag() == 1) {
                throw TwException.error("", "\u5408\u540c\u3010+" + vo.getName() + "+\u3011\u5df2\u5f52\u6863\uff0c\u65e0\u9700\u91cd\u590d\u5f52\u6863\uff01");
            }
        });
        return this.dao.conFiling(keys);
    }

    public Long unConFiling(Long[] keys) {
        return this.dao.unConFiling(keys);
    }

    public Long fictitiousConSubmit(List<Long> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return 0L;
        }
        if (keys.size() != 1) {
            throw TwException.error("", "\u865a\u62df\u5408\u540c\u8bf7\u4e00\u4e2a\u4e2a\u63d0\u4ea4\uff01");
        }
        Long key = keys.get(0);
        SaleConContractVO saleConVO = this.queryByKey(key, new Boolean[0]);
        if ("NO_CONTRACT_VIRTUAL_CONTRACT".equalsIgnoreCase(saleConVO.getPlatType()) && "SUB".equalsIgnoreCase(saleConVO.getMainType()) && "CREATE".equalsIgnoreCase(saleConVO.getStatus())) {
            this.fictitiousConSubmitProc(saleConVO);
            return 1L;
        }
        throw TwException.error("", "\u865a\u62df\u5408\u540c\u8bf7\u4e00\u4e2a\u4e2a\u63d0\u4ea4\uff01");
    }

    public List<PurchaseContractManagerVO> queryPurchConList(Long saleconId) {
        List managerVOS = this.purchaseContractManagerService.queryBySaleConId(saleconId);
        if (!ObjectUtils.isEmpty((Object)managerVOS)) {
            ArrayList bookIdList = new ArrayList();
            managerVOS.forEach(purchaseContractManagerVO -> {
                bookIdList.add(purchaseContractManagerVO.getSupplierBookId());
                this.transSysSelectionAndName((PurchaseContractManagerVO)purchaseContractManagerVO);
            });
            Map nameByBookIds = this.businessPartnerService.findNameByBookIds(bookIdList);
            managerVOS.forEach(purchaseContractManagerVO -> purchaseContractManagerVO.setSupplierName((String)nameByBookIds.get(purchaseContractManagerVO.getSupplierBookId())));
        }
        return managerVOS;
    }

    public Long findIdByNo(String conNo) {
        return this.dao.findIdByNo(conNo);
    }

    private void transSysSelectionAndName(PurchaseContractManagerVO item) {
        if (item.getPurchaseBuId() != null) {
            item.setPurchaseBuName(this.cacheUtil.getOrgName(item.getPurchaseBuId()));
        }
        String main = item.getProductClass();
        String sub = item.getProductSubClass();
        if (!ObjectUtils.isEmpty((Object)main) || !ObjectUtils.isEmpty((Object)sub)) {
            switch (main) {
                case "01": {
                    item.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.DEVELOPMENT.getCode(), sub));
                    break;
                }
                case "02": {
                    item.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SOFTWAREMA.getCode(), sub));
                    break;
                }
                case "03": {
                    item.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.HARDWARE.getCode(), sub));
                    break;
                }
                case "04": {
                    item.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.IMPLEMENT.getCode(), sub));
                    break;
                }
                case "05": {
                    item.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.OPERATIONS.getCode(), sub));
                    break;
                }
                case "06": {
                    item.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SOFTWARE.getCode(), sub));
                    break;
                }
                case "51": {
                    item.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SYNTHESIS.getCode(), sub));
                }
            }
        }
    }

    private PrdOrgSyncLogDO saveSyncLog(String syncType, String syncData, LocalDateTime currentTime) {
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        this.daoLog.save(logDO);
        return logDO;
    }

    private void fictitiousConSubmitProc(SaleConContractVO conContract) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.INVALID.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
            Long signBuId = conContract.getSignBuId();
            PrdOrgOrganizationVO orgVo = this.orgService.queryDetailSimpleByOrgId(signBuId);
            if (!ObjectUtils.isEmpty((Object)orgVo) && "BS".equals(orgVo.getOrganizationType())) {
                variables.put("isSaleBuType", Boolean.valueOf(true));
            } else {
                variables.put("isSaleBuType", Boolean.valueOf(false));
            }
            Long signBuManageUserId = this.daoOrg.queryManageIdById(signBuId);
            variables.put("Activity_1azdmha", CollUtil.newArrayList((Object[])new Long[]{signBuManageUserId}));
            Long saleManUserId = conContract.getSaleManUserId();
            variables.put("Activity_06ed3o3", CollUtil.newArrayList((Object[])new Long[]{saleManUserId}));
            Long deliBuId = conContract.getDeliBuId();
            Long deliBuManageUserId = this.daoOrg.queryManageIdById(deliBuId);
            variables.put("Activity_0sxhwto", CollUtil.newArrayList((Object[])new Long[]{deliBuManageUserId}));
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.VIRTUAL_CON_SUBMIT.name(), (String)(conContract.getName() + "-\u65e0\u5408\u540c\u5165\u573a\u865a\u62df\u5b50\u5408\u540c\u63d0\u4ea4\u6d41\u7a0b"), (String)("" + conContract.getId()), variables), new Long[0]);
        }
        SaleConContractPayload payload = new SaleConContractPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(conContract.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setStatus(status);
        String closeFileCodes = conContract.getCloseFileCodes();
        if (org.springframework.util.StringUtils.hasText((String)closeFileCodes)) {
            payload.setCloseFileCodes(closeFileCodes);
        }
        this.transactionUtilService.executeWithRunnable(() -> this.dao.updateByKeyDynamic(payload));
    }

    private void download(List<SaleConContractVO> records, HttpServletResponse response) throws IOException {
        String sheetName = "\u9500\u552e\u5408\u540c\u6570\u636e";
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), SaleConContractVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, SaleConContractVO.class, null);
        sheet.doWrite(records);
    }

    private String createYdkFolder(String itemId, List<String> pathArry, String authTokenByYdk) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (org.springframework.util.StringUtils.hasText((String)itemId)) {
            map.put("ItemId", itemId);
        }
        map.put("PathArry", pathArry);
        map.put("LibraryId", this.yeedocProperties.getSaleConLibraryId());
        log.info("[\u9500\u552e\u5408\u540c\u521b\u5efa\u6587\u4ef6\u5939-\u6613\u9053\u58f3\u5f00\u59cb]-map:{}", (Object)JSONObject.toJSONString(map));
        String resultStr = this.yeedocService.createFolder(map, authTokenByYdk);
        if (StringUtils.isEmpty((CharSequence)resultStr)) {
            log.info("[\u9500\u552e\u5408\u540c\u521b\u5efa\u6587\u4ef6\u5939-\u6613\u9053\u58f3]-map:{}", (Object)JSONObject.toJSONString(map));
            log.info("[\u9500\u552e\u5408\u540c\u521b\u5efa\u6587\u4ef6\u5939-\u6613\u9053\u58f3]-resultStr:{}", (Object)resultStr);
            throw TwException.error("", "\u9500\u552e\u5408\u540c\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25!result = {" + resultStr + "}");
        }
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        log.info("[\u9500\u552e\u5408\u540c\u521b\u5efa\u6587\u4ef6\u5939-\u6613\u9053\u58f3\u8fd4\u56de\u503c]-resultJson:{}", (Object)resultJson);
        Object data = resultJson.get((Object)"Data");
        if (ObjectUtils.isEmpty((Object)data)) {
            throw TwException.error("", "\u9500\u552e\u5408\u540c\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25!result = {" + resultJson + "}");
        }
        JSONArray dataArray = JSONArray.parseArray((String)data.toString());
        String folderId = (String)JSONObject.parseObject((String)String.valueOf(dataArray.get(0))).get((Object)"FolderId");
        if (!org.springframework.util.StringUtils.hasText((String)folderId)) {
            throw TwException.error("", "\u9500\u552e\u5408\u540c\u521b\u5efa\u6587\u4ef6\u5939\u8fd4\u56de\u503cfolderId\u4e3a\u7a7a!");
        }
        return folderId;
    }

    private String reNameFolder(String itemId, String folderName, String authTokenByYdk) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ItemId", itemId);
        map.put("NewName", folderName);
        log.info("[\u9500\u552e\u5408\u540c\u6587\u4ef6\u5939\u91cd\u547d\u540d-\u6613\u9053\u58f3\u5f00\u59cb]-map:{}", (Object)JSONObject.toJSONString(map));
        String resultStr = this.yeedocService.reNameFolder(map, authTokenByYdk);
        if (StringUtils.isEmpty((CharSequence)resultStr)) {
            log.info("[\u9500\u552e\u5408\u540c\u6587\u4ef6\u5939\u91cd\u547d\u540d-\u6613\u9053\u58f3]-map:{}", (Object)JSONObject.toJSONString(map));
            log.info("[\u9500\u552e\u5408\u540c\u6587\u4ef6\u5939\u91cd\u547d\u540d-\u6613\u9053\u58f3]-resultStr:{}", (Object)resultStr);
            throw TwException.error("", "\u9500\u552e\u5408\u540c\u6587\u4ef6\u5939\u91cd\u547d\u540d\u5931\u8d25!result = {" + resultStr + "}");
        }
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        log.info("[\u9500\u552e\u5408\u540c\u6587\u4ef6\u5939\u91cd\u547d\u540d-\u6613\u9053\u58f3\u8fd4\u56de\u503c]-resultJson:{}", (Object)resultJson);
        if (ObjectUtils.isEmpty((Object)resultJson)) {
            throw TwException.error("", "\u9500\u552e\u5408\u540c\u6587\u4ef6\u5939\u91cd\u547d\u540d\u5931\u8d25!result = {" + resultJson + "}");
        }
        JSONObject date = resultJson.getJSONObject("Data");
        if (ObjectUtils.isEmpty((Object)date)) {
            throw TwException.error("", "\u9500\u552e\u5408\u540c\u6587\u4ef6\u5939\u91cd\u547d\u540d\u5931\u8d25!result = {" + resultJson + "}");
        }
        String folderId = date.getString("Id");
        if (!org.springframework.util.StringUtils.hasText((String)folderId)) {
            throw TwException.error("", "\u9500\u552e\u5408\u540c\u6587\u4ef6\u5939\u91cd\u547d\u540d\u8fd4\u56de\u503cfolderId\u4e3a\u7a7a!");
        }
        return folderId;
    }

    private Map<String, String> saveYdkFile(String ydkFolderId, Set<String> cacheKeys, String authTokenByYdk) {
        JSONObject itemIdResultJson;
        Object itemIdData;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(cacheKeys)) {
            return null;
        }
        map.put("FolderId", ydkFolderId);
        map.put("LibraryId", this.yeedocProperties.getSaleConLibraryId());
        map.put("CacheKey", cacheKeys);
        map.put("ItemList", Lists.newArrayList());
        map.put("AssociatedItemID", Lists.newArrayList());
        map.put("Description", "");
        log.info("[\u9500\u552e\u5408\u540c\u6700\u7ec8\u4fdd\u5b58\u9644\u4ef6-\u6613\u9053\u58f3\u5f00\u59cb]-map:{}", (Object)JSONObject.toJSONString(map));
        log.info("[\u9500\u552e\u5408\u540c\u6700\u7ec8\u4fdd\u5b58\u9644\u4ef6-\u6613\u9053\u58f3\u5f00\u59cb]-authTokenByYdk:{}", (Object)authTokenByYdk);
        String resultStr = this.yeedocService.newUploadFilesSave(map, authTokenByYdk);
        if (StringUtils.isEmpty((CharSequence)resultStr)) {
            log.info("[\u9500\u552e\u5408\u540c\u6700\u7ec8\u4fdd\u5b58\u9644\u4ef6-\u6613\u9053\u58f3]-resultStr:{}", (Object)resultStr);
            throw TwException.error("", "\u9500\u552e\u5408\u540c\u6700\u7ec8\u4fdd\u5b58\u9644\u4ef6\u5931\u8d25!result = {" + resultStr + "}");
        }
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        log.info("[\u9500\u552e\u5408\u540c\u6700\u7ec8\u4fdd\u5b58\u9644\u4ef6-\u6613\u9053\u58f3\u8fd4\u56de\u503c]-resultJson:{}", (Object)resultJson);
        Boolean isSuccess = resultJson.getBoolean("IsSuccess");
        String message = resultJson.getString("Message");
        if (!isSuccess.booleanValue() || !"\u4e0a\u4f20\u6210\u529f\uff01".equals(message)) {
            throw TwException.error("", "\u9500\u552e\u5408\u540c\u6700\u7ec8\u4fdd\u5b58\u9644\u4ef6\u5931\u8d25!result = {" + resultJson + "}");
        }
        HashMap<String, Object> getItemMap = new HashMap<String, Object>();
        getItemMap.put("CacheKeys", cacheKeys);
        log.info("[\u9500\u552e\u5408\u540c\u83b7\u53d6\u6613\u9053\u58f3\u9644\u4ef6id-\u6613\u9053\u58f3\u5f00\u59cb]-map:{}", (Object)JSONObject.toJSONString(getItemMap));
        log.info("[\u9500\u552e\u5408\u540c\u83b7\u53d6\u6613\u9053\u58f3\u9644\u4ef6id-\u6613\u9053\u58f3\u5f00\u59cb]-authTokenByYdk:{}", (Object)authTokenByYdk);
        String itemIdResult = this.yeedocService.getCaCheKeyItemId(getItemMap, authTokenByYdk);
        if (StringUtils.isEmpty((CharSequence)itemIdResult)) {
            log.info("[\u9500\u552e\u5408\u540c\u83b7\u53d6\u6613\u9053\u58f3\u9644\u4ef6id-\u6613\u9053\u58f3]-resultStr:{}", (Object)itemIdResult);
        }
        if (ObjectUtils.isEmpty((Object)(itemIdData = (itemIdResultJson = JSONObject.parseObject((String)itemIdResult)).get((Object)"Data")))) {
            throw TwException.error("", "\u9500\u552e\u5408\u540c\u83b7\u53d6\u6613\u9053\u58f3\u9644\u4ef6id\u5931\u8d25!result = {" + resultJson + "}");
        }
        List itemIdJsonObjectList = JSONArray.parseArray((String)itemIdData.toString()).toJavaList(JSONObject.class);
        Map<String, String> resultMap = itemIdJsonObjectList.stream().filter(Objects::nonNull).collect(Collectors.toMap(item -> item.getString("CacheKey"), item -> item.getString("ItemId")));
        return resultMap;
    }

    @Transactional(rollbackFor={Exception.class})
    public void activeVirtualContractCompleted(Long id) {
        Optional contractDOOptional = this.repo.findById(id);
        if (contractDOOptional.isPresent()) {
            SaleConContractDO saleConContractDO = (SaleConContractDO)contractDOOptional.get();
            if (saleConContractDO.getPlatType().equals(SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode())) {
                SaleConContractPayload saleConContractPayload = new SaleConContractPayload();
                saleConContractPayload.setId(id);
                saleConContractPayload.setPlatType(SaleConEnum.INTERNAL.getCode());
                this.dao.updateByKeyDynamic(saleConContractPayload);
                Long parentId = saleConContractDO.getParentId();
                if (null != parentId) {
                    Optional parentContractOptional = this.repo.findById(parentId);
                    if (parentContractOptional.isPresent()) {
                        SaleConContractDO parentContract = (SaleConContractDO)parentContractOptional.get();
                        if (parentContract.getPlatType().equals(SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode())) {
                            SaleConContractPayload updateParentContract = new SaleConContractPayload();
                            updateParentContract.setId(parentId);
                            updateParentContract.setPlatType(SaleConEnum.INTERNAL.getCode());
                            this.dao.updateByKeyDynamic(updateParentContract);
                        }
                    } else {
                        log.error("\u5408\u540c\u4fe1\u606f\u4e0d\u5b58\u5728\uff0cid:{}", (Object)parentId);
                    }
                }
            }
        } else {
            log.error("\u5408\u540c\u4fe1\u606f\u4e0d\u5b58\u5728\uff0cid:{}", (Object)id);
        }
    }

    public SaleConContractServiceImpl(SaleConContractRepo repo, SaleConContractDAO dao, ChangeFieldLogUtil changeFieldLogUtil, ConReceivablePlanService conReceivablePlanService, CacheUtil cacheUtil, PrdSystemLogService logService, PrdSystemRoleDAO systemRoleDAO, TransactionUtilService transactionUtilService, FileUtil fileUtil, UdcUtil udcUtil, WorkflowUtil workflowUtil, PrdOrgOrganizationDAO daoOrg, PrdOrgOrganizationService orgService, PrdOrgSyncLogDAO daoLog, ConReceivablePlanRepo conReceivablePlanRepo, BusinessPartnerService businessPartnerService, PrdSystemRoleService roleService, YeedocProperties yeedocProperties, YeedocService yeedocService, CrmCustomerOperationService crmCustomerOperationService, ApiRequestLogService apiRequestLogService, ComChangeService changeService) {
        this.repo = repo;
        this.dao = dao;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.conReceivablePlanService = conReceivablePlanService;
        this.cacheUtil = cacheUtil;
        this.logService = logService;
        this.systemRoleDAO = systemRoleDAO;
        this.transactionUtilService = transactionUtilService;
        this.fileUtil = fileUtil;
        this.udcUtil = udcUtil;
        this.workflowUtil = workflowUtil;
        this.daoOrg = daoOrg;
        this.orgService = orgService;
        this.daoLog = daoLog;
        this.conReceivablePlanRepo = conReceivablePlanRepo;
        this.businessPartnerService = businessPartnerService;
        this.roleService = roleService;
        this.yeedocProperties = yeedocProperties;
        this.yeedocService = yeedocService;
        this.crmCustomerOperationService = crmCustomerOperationService;
        this.apiRequestLogService = apiRequestLogService;
        this.changeService = changeService;
    }
}

