/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.task.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskPayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4efb\u52a1\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/taskInfo"})
public class TaskInfoController {
    private static final Logger log = LoggerFactory.getLogger(TaskInfoController.class);
    private final TaskInfoService taskInfoService;

    @PostMapping(value={"/updateTask"})
    @ApiOperation(value="\u4fee\u6539\u4efb\u52a1")
    public TwOutputUtil updateTask(@RequestBody TaskInfoPayload taskInfoPayload) {
        this.taskInfoService.updateTask(taskInfoPayload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/batchAddTask"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u4efb\u52a1")
    public TwOutputUtil addTask(@RequestBody TaskPayload taskPayload) {
        this.taskInfoService.batchAddTask(taskPayload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/taskDetail"})
    @UdcNameClass
    @ApiOperation(value="\u4efb\u52a1\u8be6\u60c5")
    public TwOutputUtil<TaskInfoVO> taskDetail(Long key, Boolean needTaskPackage) {
        return TwOutputUtil.ok(this.taskInfoService.queryByKey(key, needTaskPackage));
    }

    @GetMapping(value={"/taskList"})
    @UdcNameClass
    @ApiOperation(value="\u4efb\u52a1\u5217\u8868")
    public TwOutputUtil<TaskInfoVO> taskList(TaskInfoQuery taskInfoQuery) {
        return TwOutputUtil.ok(this.taskInfoService.queryList(taskInfoQuery));
    }

    @GetMapping(value={"/paging"})
    @ApiOperation(value="\u4efb\u52a1\u5206\u9875\u5217\u8868")
    @UdcNameClass
    public TwOutputUtil<PagingVO<TaskInfoVO>> paging(TaskInfoQuery taskInfoQuery) {
        PagingVO taskInfoVOPagingVO = this.taskInfoService.queryPage(taskInfoQuery);
        return TwOutputUtil.ok(taskInfoVOPagingVO);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51faexcel")
    @PostMapping(value={"/batchExport"})
    @UdcNameClass
    public void permissionBatchExport(HttpServletResponse response, @RequestBody TaskInfoQuery query) throws IOException {
        log.info("\u6279\u91cf\u5bfc\u51faexcel");
        this.taskInfoService.batchExport(response, query);
    }

    @PostMapping(value={"/saveChangeLog"})
    @ApiOperation(value="\u5f53\u91cf\u8c03\u6574--\u53d8\u66f4")
    public TwOutputUtil saveChangeLog(@RequestBody TaskInfoPayload payload) {
        this.taskInfoService.saveChangeLog(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/taskDecompose"})
    @ApiOperation(value="\u4efb\u52a1\u5206\u89e3")
    public TwOutputUtil taskDecompose(@RequestBody TaskPayload taskPayload) {
        this.taskInfoService.taskDecompose(taskPayload);
        return TwOutputUtil.ok();
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u4efb\u52a1-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.taskInfoService.deleteSoft(Arrays.asList(keys), new Boolean[0]);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/apply"})
    @ApiOperation(value="\u4efb\u52a1\u7533\u8bf7")
    public TwOutputUtil apply(@RequestBody TaskPayload taskPayload) {
        this.taskInfoService.taskApply(taskPayload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/taskFinish"})
    @ApiOperation(value="\u4efb\u52a1\u5b8c\u5de5\u7533\u8bf7")
    public TwOutputUtil finish(Long[] keys) {
        this.taskInfoService.taskFinish(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/taskClose"})
    @ApiOperation(value="\u4efb\u52a1\u5173\u95ed")
    public TwOutputUtil taskClose(Long[] keys) {
        this.taskInfoService.taskClose(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/operationTaskFinish"})
    @ApiOperation(value="\u5904\u7406\u4efb\u52a1\u5b8c\u5de5\u7533\u8bf7")
    public TwOutputUtil operationTaskFinish(Long key, String operationStatus) {
        this.taskInfoService.operationTaskFinish(key, operationStatus);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/updateTaskProgress"})
    @ApiOperation(value="\u66f4\u6539\u4efb\u52a1\u8fdb\u5ea6")
    public TwOutputUtil updateTaskProgress(Long key, BigDecimal progress) {
        this.taskInfoService.updateTaskProgress(key, progress);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/taskAssign"})
    @ApiOperation(value="\u4efb\u52a1\u6d3e\u53d1")
    public TwOutputUtil taskAssign(Long[] keys) {
        this.taskInfoService.taskAssign(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public TaskInfoController(TaskInfoService taskInfoService) {
        this.taskInfoService = taskInfoService;
    }
}

