/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActPlanPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActPlanService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActPlanVO;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActPlanDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/MARKET_PLAN/callBack"})
@Transactional
public class MarketPlanWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(MarketPlanWorkflowCallBackController.class);
    private final CrmActPlanDAO actPlanDAO;
    private final PrdSystemBusinessChangeService changeService;
    private final CrmActPlanService actPlanService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        CrmActPlanPayload actPlanPayload = new CrmActPlanPayload();
        actPlanPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        CrmActPlanVO crmActPlanVO = this.actPlanService.queryByKey(Long.valueOf(businessKey));
        if (crmActPlanVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    actPlanPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    actPlanPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case INVALID: {
                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.INVALID.getCode());
                    actPlanPayload.setDeleteFlag(Integer.valueOf(1));
                    actPlanPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    actPlanPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    actPlanPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    actPlanPayload.setApprovedTime(LocalDateTime.now());
                    this.actPlanDAO.updateByKeyDynamic(actPlanPayload);
                    crmActPlanVO = this.actPlanService.queryByKey(Long.valueOf(businessKey));
                    this.changeService.saveNewLog(ChangeTypeEnum.MARKET_PLAN.getCode(), (BaseViewModel)crmActPlanVO, null, null, Integer.valueOf(1));
                    List crmActPlanDetailVOS = this.actPlanService.queryDetails(crmActPlanVO.getId(), null);
                    for (CrmActPlanDetailVO crmActPlanDetailVO : crmActPlanDetailVOS) {
                        this.changeService.saveNewLog(ChangeTypeEnum.MARKET_PLAN_DETAIL.getCode(), (BaseViewModel)crmActPlanDetailVO, ChangeTypeEnum.MARKET_PLAN.getCode(), crmActPlanVO.getId().toString(), Integer.valueOf(1));
                    }
                    break;
                }
                case APPROVING: {
                    actPlanPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                }
            }
            if (!procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
                this.actPlanDAO.updateByKeyDynamic(actPlanPayload);
            }
        }
        return WorkflowResult.success(null);
    }

    public MarketPlanWorkflowCallBackController(CrmActPlanDAO actPlanDAO, PrdSystemBusinessChangeService changeService, CrmActPlanService actPlanService) {
        this.actPlanDAO = actPlanDAO;
        this.changeService = changeService;
        this.actPlanService = actPlanService;
    }
}

